/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

class CommonUtils {
    private static final String WINDOWS_OS_FAMILY_NAME = "Windows";
    private static final String SUN_OS_FAMILY_NAME = "SunOS";
    private static final String MAC_OS_FAMILY_NAME = "Mac";

    CommonUtils() {
    }

    public static String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    private static boolean osBelongsToFamily(String string) {
        String string2 = CommonUtils.getOperatingSystemName();
        return string2.toUpperCase().indexOf(string.toUpperCase()) > -1;
    }

    public static boolean isWindowsOS() {
        return CommonUtils.osBelongsToFamily(WINDOWS_OS_FAMILY_NAME);
    }

    public static boolean isSunOS() {
        return CommonUtils.osBelongsToFamily(SUN_OS_FAMILY_NAME);
    }

    public static boolean isMacOS() {
        return CommonUtils.osBelongsToFamily(MAC_OS_FAMILY_NAME);
    }
}

