/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.importchooser;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.bpel.properties.importchooser.ReferenceDecorator;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceCreator;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDataNode;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDecorator;
import org.netbeans.modules.xml.xpath.ext.schema.ExNamespaceContext;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BpelImportCreator
extends ExternalReferenceCreator<Process> {
    private ExternalReferenceDecorator decorator;

    public BpelImportCreator(Process process) {
        super((Component)process, null);
    }

    public void applyChanges() throws IOException {
        try {
            super.applyChanges();
            Process process = (Process)this.getModelComponent();
            BpelModel bpelModel = process.getBpelModel();
            List list = this.getSelectedNodes();
            for (Node node : list) {
                Import import_ = bpelModel.getBuilder().createImport();
                String string = this.getNamespace(node);
                if (this.mustNamespaceDiffer()) {
                    import_.setNamespace(string);
                }
                import_.setLocation(this.getLocation(node));
                switch (this.getImportType()) {
                    case schema: {
                        import_.setImportType("http://www.w3.org/2001/XMLSchema");
                        break;
                    }
                    case wsdl: {
                        import_.setImportType("http://schemas.xmlsoap.org/wsdl/");
                    }
                }
                ExNamespaceContext exNamespaceContext = process.getNamespaceContext();
                if (exNamespaceContext != null) {
                    String string2 = exNamespaceContext.getPrefix(string);
                    String string3 = null;
                    if (node instanceof ExternalReferenceDataNode) {
                        string3 = ((ExternalReferenceDataNode)node).getPrefix();
                    }
                    if (string2 == null || !string2.equals(string3)) {
                        if (string3 == null || string3.length() == 0) {
                            exNamespaceContext.addNamespace(string);
                        } else {
                            exNamespaceContext.addNamespace(string3, string);
                        }
                    }
                }
                process.addImport(import_);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String getTargetNamespace(Model model) {
        return Util.getTargetNamespace(model);
    }

    protected Map<String, String> getPrefixes(Model model) {
        if (model != null) {
            assert (model instanceof BpelModel);
            BpelModel bpelModel = (BpelModel)model;
            return ((AbstractDocumentComponent)bpelModel.getProcess()).getPrefixes();
        }
        return new HashMap<String, String>();
    }

    protected ExternalReferenceDecorator getNodeDecorator() {
        if (this.decorator == null) {
            this.decorator = new ReferenceDecorator((Process)this.getModelComponent(), this, this.getImportType());
        }
        return this.decorator;
    }

    public abstract Utilities.DocumentTypesEnum getImportType();

    public boolean mustNamespaceDiffer() {
        return true;
    }

    protected String referenceTypeName() {
        return NbBundle.getMessage(BpelImportCreator.class, (String)"LBL_WSDLFileImportDialog_Type");
    }
}

