/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.importchooser;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.bpel.properties.importchooser.NameGenerator;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.customizer.AbstractReferenceDecorator;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceCreator;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDataNode;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ReferenceDecorator
extends AbstractReferenceDecorator {
    private ExternalReferenceCreator myRefCreator;
    private Utilities.DocumentTypesEnum myDocType;
    private Process myProcess;
    private int myPrefixCounter;

    public ReferenceDecorator(Process process, ExternalReferenceCreator externalReferenceCreator, Utilities.DocumentTypesEnum documentTypesEnum) {
        this.myProcess = process;
        this.myRefCreator = externalReferenceCreator;
        this.myDocType = documentTypesEnum;
    }

    public String validate(ExternalReferenceNode externalReferenceNode) {
        if (externalReferenceNode.hasModel()) {
            Object object;
            Model model = externalReferenceNode.getModel();
            if (model == null || model.getState() != Model.State.VALID) {
                return NbBundle.getMessage(ReferenceDecorator.class, (String)"LBL_ReferenceDecorator_InvalidModel");
            }
            Model model2 = this.myRefCreator.getComponentModel();
            if (model2 instanceof BpelModel && ResolverUtility.isModelImported(model, (BpelModel)(object = (BpelModel)model2))) {
                return NbBundle.getMessage(ReferenceDecorator.class, (String)"LBL_ReferenceDecorator_AlreadyRefd");
            }
            object = externalReferenceNode.getNamespace();
            if (object == null || ((String)object).length() == 0) {
                return NbBundle.getMessage(ReferenceDecorator.class, (String)"LBL_ReferenceDecorator_NoNamespace");
            }
            String string = this.myRefCreator.getTargetNamespace();
            if (this.myRefCreator.mustNamespaceDiffer()) {
                if (!"NO_NAME_SPACE".equals(object) && string.equals(object)) {
                    return NbBundle.getMessage(ReferenceDecorator.class, (String)"LBL_ReferenceDecorator_SameNamespace");
                }
            } else if (!"NO_NAME_SPACE".equals(object) && !string.equals(object)) {
                return NbBundle.getMessage(ReferenceDecorator.class, (String)"LBL_ReferenceDecorator_DifferentNamespace");
            }
        }
        return null;
    }

    public ExternalReferenceDataNode createExternalReferenceNode(Node node) {
        return this.myRefCreator.createExternalReferenceNode(node);
    }

    public Utilities.DocumentTypesEnum getDocumentType() {
        return this.myDocType;
    }

    public String getHtmlDisplayName(String string, ExternalReferenceNode externalReferenceNode) {
        if (this.validate(externalReferenceNode) == null) {
            return string;
        }
        return "<s>" + string + "</s>";
    }

    public String getNamespace(Model model) {
        return Util.getTargetNamespace(model);
    }

    protected String generatePrefix(Model model) {
        String string;
        BpelModel bpelModel = this.myProcess.getBpelModel();
        if (model != null && (string = this.getNamespace(model)) != null && string.length() > 0) {
            String string2 = NameGenerator.getNamespacePrefix(string, (BpelEntity)this.myProcess);
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
            return NameGenerator.getInstance().generateNamespacePrefix(null, bpelModel, this.myPrefixCounter++);
        }
        return "";
    }
}

