/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.props.editors;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.CompensationHandlerHolder;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.references.ReferenceCollection;
import org.netbeans.modules.bpel.model.spi.FindHelper;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.xml.xam.Named;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompensationTargetEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private PropertyEnv myPropertyEnv = null;
    private List<CompensationHandlerHolder> chHoldersList;

    @Override
    public String getAsText() {
        CompensationHandlerHolder compensationHandlerHolder;
        BpelReference bpelReference = (BpelReference)this.getValue();
        if (bpelReference != null && (compensationHandlerHolder = (CompensationHandlerHolder)bpelReference.get()) != null && compensationHandlerHolder instanceof Named) {
            String string = ((Named)compensationHandlerHolder).getName();
            return string;
        }
        return Constants.NOT_ASSIGNED;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        Object[] objectArray;
        BpelNode bpelNode;
        Object t;
        CompensationHandlerHolder compensationHandlerHolder = this.findChHolderByName(string);
        BpelReference bpelReference = null;
        if (this.myPropertyEnv != null && (t = (bpelNode = (BpelNode)((Object)(objectArray = this.myPropertyEnv.getBeans())[0])).getReference()) instanceof ReferenceCollection) {
            bpelReference = ((ReferenceCollection)t).createReference((BpelReferenceable)compensationHandlerHolder, CompensationHandlerHolder.class);
        }
        this.setValue(bpelReference);
    }

    @Override
    public String[] getTags() {
        List<String> list = this.getChHolderNamesList();
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Object getValue() {
        Object object = super.getValue();
        if (object != null) assert (object instanceof BpelReference);
        return object;
    }

    @Override
    public void setValue(Object object) {
        if (object != null) assert (object instanceof BpelReference);
        super.setValue(object);
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        boolean bl = false;
        if (propertyEnv.equals(this.myPropertyEnv)) {
            Object[] objectArray = propertyEnv.getBeans();
            BpelNode bpelNode = (BpelNode)((Object)objectArray[0]);
            BpelNode bpelNode2 = (BpelNode)((Object)(objectArray = this.myPropertyEnv.getBeans())[0]);
            if (!bpelNode.equals((Object)bpelNode2)) {
                bl = true;
            }
        } else {
            bl = true;
        }
        this.myPropertyEnv = propertyEnv;
        if (bl) {
            this.chHoldersList = null;
        }
    }

    private CompensationHandlerHolder findChHolderByName(String string) {
        List<CompensationHandlerHolder> list = this.getChHoldersList();
        for (CompensationHandlerHolder compensationHandlerHolder : list) {
            if (compensationHandlerHolder instanceof Named) {
                String string2 = ((Named)compensationHandlerHolder).getName();
                if (!string.equals(string2)) continue;
                return compensationHandlerHolder;
            }
            assert (false) : "The CompensationHandlerHolder should be Named!";
        }
        return null;
    }

    private List<CompensationHandlerHolder> getChHoldersList() {
        if (this.chHoldersList == null) {
            this.chHoldersList = new ArrayList<CompensationHandlerHolder>();
            if (this.myPropertyEnv != null) {
                Object[] objectArray = this.myPropertyEnv.getBeans();
                BpelNode bpelNode = (BpelNode)((Object)objectArray[0]);
                Lookup lookup = bpelNode.getLookup();
                Object t = bpelNode.getReference();
                if (t instanceof BpelEntity) {
                    BpelEntity bpelEntity = (BpelEntity)t;
                    FindHelper findHelper = (FindHelper)Lookup.getDefault().lookup(FindHelper.class);
                    Iterator iterator = findHelper.scopeIterator(bpelEntity);
                    BaseScope baseScope = (BaseScope)iterator.next();
                    this.populateChHoldersList((BpelContainer)baseScope, this.chHoldersList);
                }
            }
        }
        return this.chHoldersList;
    }

    private List<String> getChHolderNamesList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<CompensationHandlerHolder> list = this.getChHoldersList();
        for (CompensationHandlerHolder compensationHandlerHolder : list) {
            if (!(compensationHandlerHolder instanceof Named)) continue;
            String string = ((Named)compensationHandlerHolder).getName();
            arrayList.add(string);
        }
        return arrayList;
    }

    private void populateChHoldersList(BpelContainer bpelContainer, List<CompensationHandlerHolder> list) {
        for (BpelEntity bpelEntity : bpelContainer.getChildren()) {
            if (bpelEntity instanceof CompensationHandlerHolder) {
                list.add((CompensationHandlerHolder)bpelEntity);
                continue;
            }
            if (!(bpelEntity instanceof BpelContainer)) continue;
            this.populateChHoldersList((BpelContainer)bpelEntity, list);
        }
    }
}

