/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.props.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.props.PropertyVetoError;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.form.RangeIntegerDocument;
import org.netbeans.modules.soa.ui.form.ValidablePropertyCustomizer;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.validation.util.DurationUtil;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DeadlinePropertyCustomizer
extends ValidablePropertyCustomizer
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private Timer inputDelayTimer;
    private PropertyEditor myPropertyEditor;
    private JTextField fldDay;
    private JTextField fldHour;
    private JTextField fldMinute;
    private JTextField fldMonth;
    private JTextField fldSecond;
    private JTextField fldYear;
    private JLabel lblDay;
    private JLabel lblErrorMessage;
    private JLabel lblHour;
    private JLabel lblMinute;
    private JLabel lblMonth;
    private JLabel lblSecond;
    private JLabel lblYear;

    public DeadlinePropertyCustomizer() {
        this.initComponents();
        this.getValidStateManager(true).addValidStateListener(new ValidStateManager.ValidStateListener(){

            public void stateChanged(ValidStateManager validStateManager, boolean bl) {
                if (validStateManager.isValid()) {
                    DeadlinePropertyCustomizer.this.lblErrorMessage.setText("");
                } else {
                    DeadlinePropertyCustomizer.this.lblErrorMessage.setText(validStateManager.getHtmlReasons());
                }
            }
        });
        this.fldYear.setDocument((Document)new RangeIntegerDocument(Integer.MIN_VALUE, Integer.MAX_VALUE));
        this.fldMonth.setDocument((Document)new RangeIntegerDocument(1, 12));
        this.fldDay.setDocument((Document)new RangeIntegerDocument(1, 31));
        this.fldHour.setDocument((Document)new RangeIntegerDocument(0, 23));
        this.fldMinute.setDocument((Document)new RangeIntegerDocument(0, 59));
        this.fldSecond.setDocument((Document)new RangeIntegerDocument(0, 59));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeadlinePropertyCustomizer.this.revalidate(true);
            }
        };
        this.inputDelayTimer = new Timer(400, actionListener);
        this.inputDelayTimer.setCoalesce(true);
        this.inputDelayTimer.setRepeats(false);
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                DeadlinePropertyCustomizer.this.inputDelayTimer.restart();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                DeadlinePropertyCustomizer.this.inputDelayTimer.restart();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                DeadlinePropertyCustomizer.this.inputDelayTimer.restart();
            }
        };
        this.fldYear.getDocument().addDocumentListener(documentListener);
        this.fldMonth.getDocument().addDocumentListener(documentListener);
        this.fldDay.getDocument().addDocumentListener(documentListener);
        this.fldHour.getDocument().addDocumentListener(documentListener);
        this.fldMinute.getDocument().addDocumentListener(documentListener);
        this.fldSecond.getDocument().addDocumentListener(documentListener);
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DeadlinePropertyCustomizer.this.inputDelayTimer.stop();
                DeadlinePropertyCustomizer.this.revalidate(true);
            }
        };
        this.fldYear.addFocusListener(focusAdapter);
        this.fldMonth.addFocusListener(focusAdapter);
        this.fldDay.addFocusListener(focusAdapter);
        this.fldHour.addFocusListener(focusAdapter);
        this.fldMinute.addFocusListener(focusAdapter);
        this.fldSecond.addFocusListener(focusAdapter);
        HelpCtx.setHelpIDString((JComponent)((Object)this), (String)this.getClass().getName());
        SoaUtil.activateInlineMnemonics((Container)((Object)this));
    }

    public synchronized void init(PropertyEnv propertyEnv, PropertyEditor propertyEditor) {
        assert (propertyEnv != null && propertyEditor != null) : "Wrong params";
        if (this.myPropertyEnv == propertyEnv) {
            return;
        }
        if (this.myPropertyEnv != null) {
            this.myPropertyEnv.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.myPropertyEditor = propertyEditor;
        super.init(propertyEnv, propertyEditor);
        this.myPropertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
        this.myPropertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        String string = propertyEditor.getAsText();
        string = DurationUtil.removeQuotes((String)string);
        this.parseUntil(string);
        this.revalidate(true);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            String string = DurationUtil.addQuotes((String)this.getContent());
            try {
                this.myPropertyEditor.setAsText(string);
            }
            catch (PropertyVetoError propertyVetoError) {
                this.myPropertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
                PropertyVetoError.defaultProcessing(propertyVetoError);
            }
        }
    }

    private void parseUntil(String string) {
        Date date = null;
        try {
            date = this.parseDate(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.fldYear.setText(Integer.toString(gregorianCalendar.get(1)));
        this.fldMonth.setText(Integer.toString(gregorianCalendar.get(2) + 1));
        this.fldDay.setText(Integer.toString(gregorianCalendar.get(5)));
        this.fldHour.setText(Integer.toString(gregorianCalendar.get(11)));
        this.fldMinute.setText(Integer.toString(gregorianCalendar.get(12)));
        this.fldSecond.setText(Integer.toString(gregorianCalendar.get(13)));
    }

    private Date parseDate(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setLenient(false);
        return simpleDateFormat.parse(string.replace("T".charAt(0), ' '));
    }

    private String getContent() {
        return DurationUtil.getContent((boolean)false, (int)DurationUtil.parseInt((String)this.fldYear.getText()), (int)DurationUtil.parseInt((String)this.fldMonth.getText()), (int)DurationUtil.parseInt((String)this.fldDay.getText()), (int)DurationUtil.parseInt((String)this.fldHour.getText()), (int)DurationUtil.parseInt((String)this.fldMinute.getText()), (double)DurationUtil.parseDouble((String)this.fldSecond.getText()));
    }

    public Validator createValidator() {
        return new MyValidator((ValidStateManager.Provider)this);
    }

    private void initComponents() {
        this.lblYear = new JLabel();
        this.fldYear = new JTextField();
        this.lblMonth = new JLabel();
        this.fldMonth = new JTextField();
        this.lblDay = new JLabel();
        this.fldDay = new JTextField();
        this.lblHour = new JLabel();
        this.fldHour = new JTextField();
        this.lblMinute = new JLabel();
        this.fldMinute = new JTextField();
        this.lblSecond = new JLabel();
        this.fldSecond = new JTextField();
        this.lblErrorMessage = new JLabel();
        this.lblYear.setLabelFor(this.fldYear);
        this.lblYear.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Year"));
        this.lblYear.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Year"));
        this.lblYear.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Year"));
        this.fldYear.setColumns(4);
        this.lblMonth.setLabelFor(this.fldMonth);
        this.lblMonth.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Month"));
        this.lblMonth.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Month"));
        this.lblMonth.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Month"));
        this.fldMonth.setColumns(4);
        this.lblDay.setLabelFor(this.fldDay);
        this.lblDay.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Day"));
        this.lblDay.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Day"));
        this.lblDay.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Day"));
        this.fldDay.setColumns(4);
        this.lblHour.setLabelFor(this.fldHour);
        this.lblHour.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Hour"));
        this.lblHour.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Hour"));
        this.lblHour.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Hour"));
        this.fldHour.setColumns(4);
        this.lblMinute.setLabelFor(this.fldMinute);
        this.lblMinute.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Minute"));
        this.lblMinute.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Minute"));
        this.lblMinute.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Minute"));
        this.fldMinute.setColumns(4);
        this.lblSecond.setLabelFor(this.fldSecond);
        this.lblSecond.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Second"));
        this.lblSecond.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Second"));
        this.lblSecond.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Second"));
        this.fldSecond.setColumns(4);
        this.lblErrorMessage.setForeground(new Color(255, 0, 0));
        this.lblErrorMessage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_ErrorLabel"));
        this.lblErrorMessage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_ErrorLabel"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.lblErrorMessage, -1, 295, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.lblYear).add(2, (Component)this.lblHour)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fldYear, -1, 41, Short.MAX_VALUE).add((Component)this.fldHour, -1, 41, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.lblMonth).add(2, (Component)this.lblMinute)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fldMonth, -1, 41, Short.MAX_VALUE).add((Component)this.fldMinute, -1, 41, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.lblDay).add(2, (Component)this.lblSecond)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fldDay, -1, 39, Short.MAX_VALUE).add((Component)this.fldSecond, -1, 39, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblYear).add((Component)this.fldYear, -2, -1, -2).add((Component)this.lblMonth).add((Component)this.lblDay).add((Component)this.fldDay, -2, -1, -2).add((Component)this.fldMonth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblHour).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblMinute).add((Component)this.lblSecond).add((Component)this.fldHour, -2, -1, -2).add((Component)this.fldSecond, -2, -1, -2).add((Component)this.fldMinute, -2, -1, -2))).addPreferredGap(0).add((Component)this.lblErrorMessage, -1, 49, Short.MAX_VALUE).addContainerGap()));
    }

    private class MyValidator
    extends DefaultValidator {
        public MyValidator(ValidStateManager.Provider provider) {
            super(provider, ErrorMessagesBundle.class);
        }

        public void doFastValidation() {
            String string = DurationUtil.getParseUntil((String)DeadlinePropertyCustomizer.this.fldYear.getText().trim(), (String)DeadlinePropertyCustomizer.this.fldMonth.getText().trim(), (String)DeadlinePropertyCustomizer.this.fldDay.getText().trim(), (String)DeadlinePropertyCustomizer.this.fldHour.getText().trim(), (String)DeadlinePropertyCustomizer.this.fldMinute.getText().trim(), (String)DeadlinePropertyCustomizer.this.fldSecond.getText().trim());
            try {
                DeadlinePropertyCustomizer.this.parseDate(string);
            }
            catch (ParseException parseException) {
                this.addReasonKey(Validator.Severity.ERROR, "ERR_INCORRECT_DATE_TIME", new String[]{string});
            }
        }
    }
}

