/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.props.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.props.PropertyVetoError;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.form.RangeDoubleDocument;
import org.netbeans.modules.soa.ui.form.RangeIntegerDocument;
import org.netbeans.modules.soa.ui.form.ValidablePropertyCustomizer;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.validation.util.Duration;
import org.netbeans.modules.soa.validation.util.DurationUtil;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DurationPropertyCustomizer
extends ValidablePropertyCustomizer
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private Timer inputDelayTimer;
    private PropertyEditor myPropertyEditor;
    private JTextField fldDay;
    private JTextField fldHour;
    private JTextField fldMinute;
    private JTextField fldMonth;
    private JTextField fldSecond;
    private JTextField fldYear;
    private JLabel lblDay;
    private JLabel lblErrorMessage;
    private JLabel lblHour;
    private JLabel lblMinute;
    private JLabel lblMonth;
    private JLabel lblSecond;
    private JLabel lblYear;

    public DurationPropertyCustomizer() {
        this.initComponents();
        this.getValidStateManager(true).addValidStateListener(new ValidStateManager.ValidStateListener(){

            public void stateChanged(ValidStateManager validStateManager, boolean bl) {
                if (validStateManager.isValid()) {
                    DurationPropertyCustomizer.this.lblErrorMessage.setText("");
                } else {
                    DurationPropertyCustomizer.this.lblErrorMessage.setText(validStateManager.getHtmlReasons());
                }
            }
        });
        this.fldYear.setDocument((Document)new RangeIntegerDocument(0, Integer.MAX_VALUE));
        this.fldMonth.setDocument((Document)new RangeIntegerDocument(0, Integer.MAX_VALUE));
        this.fldDay.setDocument((Document)new RangeIntegerDocument(0, Integer.MAX_VALUE));
        this.fldHour.setDocument((Document)new RangeIntegerDocument(0, Integer.MAX_VALUE));
        this.fldMinute.setDocument((Document)new RangeIntegerDocument(0, Integer.MAX_VALUE));
        this.fldSecond.setDocument((Document)new RangeDoubleDocument(0.0, Double.MAX_VALUE));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DurationPropertyCustomizer.this.revalidate(true);
            }
        };
        this.inputDelayTimer = new Timer(400, actionListener);
        this.inputDelayTimer.setCoalesce(true);
        this.inputDelayTimer.setRepeats(false);
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                DurationPropertyCustomizer.this.inputDelayTimer.restart();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                DurationPropertyCustomizer.this.inputDelayTimer.restart();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                DurationPropertyCustomizer.this.inputDelayTimer.restart();
            }
        };
        this.fldYear.getDocument().addDocumentListener(documentListener);
        this.fldMonth.getDocument().addDocumentListener(documentListener);
        this.fldDay.getDocument().addDocumentListener(documentListener);
        this.fldHour.getDocument().addDocumentListener(documentListener);
        this.fldMinute.getDocument().addDocumentListener(documentListener);
        this.fldSecond.getDocument().addDocumentListener(documentListener);
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DurationPropertyCustomizer.this.inputDelayTimer.stop();
                DurationPropertyCustomizer.this.revalidate(true);
            }
        };
        this.fldYear.addFocusListener(focusAdapter);
        this.fldMonth.addFocusListener(focusAdapter);
        this.fldDay.addFocusListener(focusAdapter);
        this.fldHour.addFocusListener(focusAdapter);
        this.fldMinute.addFocusListener(focusAdapter);
        this.fldSecond.addFocusListener(focusAdapter);
        HelpCtx.setHelpIDString((JComponent)((Object)this), (String)this.getClass().getName());
        SoaUtil.activateInlineMnemonics((Container)((Object)this));
    }

    public synchronized void init(PropertyEnv propertyEnv, PropertyEditor propertyEditor) {
        assert (propertyEnv != null && propertyEditor != null) : "Wrong params";
        if (this.myPropertyEnv == propertyEnv) {
            return;
        }
        if (this.myPropertyEnv != null) {
            this.myPropertyEnv.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.myPropertyEditor = propertyEditor;
        super.init(propertyEnv, propertyEditor);
        this.myPropertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
        this.myPropertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        String string = propertyEditor.getAsText();
        this.parseFor(string);
        this.revalidate(true);
        String string2 = null;
        FeatureDescriptor featureDescriptor = this.myPropertyEnv.getFeatureDescriptor();
        if (PropertyType.FOR_EXPRESSION.toString().equals(featureDescriptor.getName())) {
            string2 = this.getClass().getName() + ".For";
        } else if (PropertyType.REPEAT_EVERY_EXPRESSION.toString().equals(featureDescriptor.getName())) {
            string2 = this.getClass().getName() + ".RepeatEvery";
        }
        if (string2 != null && string2.length() != 0) {
            HelpCtx.setHelpIDString((JComponent)((Object)this), (String)string2);
            SoaUtil.fireHelpContextChange((Component)((Object)this), (HelpCtx)new HelpCtx(string2));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            String string = DurationUtil.addQuotes((String)this.getContent());
            try {
                this.myPropertyEditor.setAsText(string);
            }
            catch (PropertyVetoError propertyVetoError) {
                this.myPropertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
                PropertyVetoError.defaultProcessing(propertyVetoError);
            }
        }
    }

    private void parseFor(String string) {
        Duration duration = DurationUtil.parseDuration((String)string, (boolean)false);
        this.fldYear.setText("" + duration.getYears());
        this.fldMonth.setText("" + duration.getMonths());
        this.fldDay.setText("" + duration.getDays());
        this.fldHour.setText("" + duration.getHours());
        this.fldMinute.setText("" + duration.getMinutes());
        this.fldSecond.setText("" + duration.getSeconds());
    }

    private String getContent() {
        return DurationUtil.getContent((boolean)true, (int)DurationUtil.parseInt((String)this.fldYear.getText()), (int)DurationUtil.parseInt((String)this.fldMonth.getText()), (int)DurationUtil.parseInt((String)this.fldDay.getText()), (int)DurationUtil.parseInt((String)this.fldHour.getText()), (int)DurationUtil.parseInt((String)this.fldMinute.getText()), (double)DurationUtil.parseDouble((String)this.fldSecond.getText()));
    }

    public Validator createValidator() {
        return new MyValidator((ValidStateManager.Provider)this);
    }

    private void initComponents() {
        this.lblYear = new JLabel();
        this.fldYear = new JTextField();
        this.lblMonth = new JLabel();
        this.fldMonth = new JTextField();
        this.lblDay = new JLabel();
        this.fldDay = new JTextField();
        this.lblHour = new JLabel();
        this.fldHour = new JTextField();
        this.lblMinute = new JLabel();
        this.fldMinute = new JTextField();
        this.lblSecond = new JLabel();
        this.fldSecond = new JTextField();
        this.lblErrorMessage = new JLabel();
        this.lblYear.setLabelFor(this.fldYear);
        this.lblYear.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Years"));
        this.lblYear.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Years"));
        this.lblYear.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Years"));
        this.fldYear.setColumns(4);
        this.lblMonth.setLabelFor(this.fldMonth);
        this.lblMonth.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Months"));
        this.lblMonth.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Months"));
        this.lblMonth.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Months"));
        this.fldMonth.setColumns(4);
        this.lblDay.setLabelFor(this.fldDay);
        this.lblDay.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Days"));
        this.lblDay.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Days"));
        this.lblDay.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Days"));
        this.fldDay.setColumns(4);
        this.lblHour.setLabelFor(this.fldHour);
        this.lblHour.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Hours"));
        this.lblHour.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Hours"));
        this.lblHour.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Hours"));
        this.fldHour.setColumns(4);
        this.lblMinute.setLabelFor(this.fldMinute);
        this.lblMinute.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Minutes"));
        this.lblMinute.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Minutes"));
        this.lblMinute.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Minutes"));
        this.fldMinute.setColumns(4);
        this.lblSecond.setLabelFor(this.fldSecond);
        this.lblSecond.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Seconds"));
        this.lblSecond.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Seconds"));
        this.lblSecond.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Seconds"));
        this.fldSecond.setColumns(4);
        this.lblErrorMessage.setForeground(new Color(255, 0, 0));
        this.lblErrorMessage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_ErrorLabel"));
        this.lblErrorMessage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_ErrorLabel"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.lblErrorMessage, -1, 295, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.lblYear).add(2, (Component)this.lblHour)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fldYear, -1, 35, Short.MAX_VALUE).add((Component)this.fldHour, -1, 35, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.lblMonth).add(2, (Component)this.lblMinute)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fldMonth, -1, 34, Short.MAX_VALUE).add((Component)this.fldMinute, -1, 34, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.lblDay).add(2, (Component)this.lblSecond)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fldDay, -1, 34, Short.MAX_VALUE).add((Component)this.fldSecond, -1, 34, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblYear).add((Component)this.fldYear, -2, -1, -2).add((Component)this.lblMonth).add((Component)this.lblDay).add((Component)this.fldDay, -2, -1, -2).add((Component)this.fldMonth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblHour).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblMinute).add((Component)this.lblSecond).add((Component)this.fldHour, -2, -1, -2).add((Component)this.fldSecond, -2, -1, -2).add((Component)this.fldMinute, -2, -1, -2))).addPreferredGap(0).add((Component)this.lblErrorMessage, -1, 49, Short.MAX_VALUE).addContainerGap()));
    }

    private class MyValidator
    extends DefaultValidator {
        public MyValidator(ValidStateManager.Provider provider) {
            super(provider, ErrorMessagesBundle.class);
        }

        public void doFastValidation() {
            if (!this.check(DurationPropertyCustomizer.this.fldYear)) {
                this.addReasonKey(Validator.Severity.ERROR, "ERR_INVALID_YEARS");
            }
            if (!this.check(DurationPropertyCustomizer.this.fldMonth)) {
                this.addReasonKey(Validator.Severity.ERROR, "ERR_INVALID_MONTHS");
            }
            if (!this.check(DurationPropertyCustomizer.this.fldDay)) {
                this.addReasonKey(Validator.Severity.ERROR, "ERR_INVALID_DAYS");
            }
            if (!this.check(DurationPropertyCustomizer.this.fldHour)) {
                this.addReasonKey(Validator.Severity.ERROR, "ERR_INVALID_HOURS");
            }
            if (!this.check(DurationPropertyCustomizer.this.fldMinute)) {
                this.addReasonKey(Validator.Severity.ERROR, "ERR_INVALID_MINUTES");
            }
            if (DurationUtil.parseDouble((String)DurationPropertyCustomizer.this.fldSecond.getText()) < 0.0) {
                this.addReasonKey(Validator.Severity.ERROR, "ERR_INVALID_SECONDS");
            }
        }

        private boolean check(JTextField jTextField) {
            return DurationUtil.parseInt((String)jTextField.getText()) >= 0;
        }
    }
}

