/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.search;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.DecorationProvider;
import org.netbeans.modules.bpel.design.decoration.DecorationProviderFactory;
import org.netbeans.modules.bpel.design.decoration.GlowDescriptor;
import org.netbeans.modules.bpel.model.api.BpelEntity;

public final class Decorator
extends DecorationProvider
implements DecorationProviderFactory {
    private boolean myIsClearSelection;
    private boolean myIsClearHighlighting;
    private BpelEntity mySelectedEntity;
    private List<BpelEntity> myHighlightedEntities;
    private static final Decoration GREEN_DECORATION = new Decoration(new GlowDescriptor(new Color(56, 216, 120), 20.0));
    private static final Decoration YELLOW_DECORATION = new Decoration(new GlowDescriptor(new Color(255, 255, 0), 20.0));

    public Decorator() {
    }

    public DecorationProvider createInstance(DesignView designView) {
        return new Decorator(designView);
    }

    private Decorator(DesignView designView) {
        super(designView);
        this.myHighlightedEntities = new ArrayList<BpelEntity>();
    }

    public Decoration getDecoration(BpelEntity bpelEntity) {
        if (!this.myIsClearSelection && this.mySelectedEntity == bpelEntity) {
            return GREEN_DECORATION;
        }
        if (!this.myIsClearHighlighting && this.myHighlightedEntities.contains(bpelEntity)) {
            return YELLOW_DECORATION;
        }
        return null;
    }

    public void release() {
        this.mySelectedEntity = null;
        this.myHighlightedEntities = null;
    }

    void select(BpelEntity bpelEntity) {
        if (this.mySelectedEntity != null) {
            this.myIsClearSelection = true;
        }
        this.myIsClearSelection = false;
        this.mySelectedEntity = bpelEntity;
        this.fireDecorationChanged();
    }

    void clearHighlighting() {
        this.myIsClearHighlighting = true;
        this.myIsClearSelection = true;
        this.fireDecorationChanged();
        this.myHighlightedEntities = new ArrayList<BpelEntity>();
        this.myIsClearHighlighting = false;
        this.myIsClearSelection = false;
    }

    void doHighlight(BpelEntity bpelEntity, boolean bl) {
        if (bl) {
            this.myHighlightedEntities.add(bpelEntity);
        } else {
            this.myHighlightedEntities.remove(bpelEntity);
        }
        this.myIsClearSelection = !bl;
        this.fireDecorationChanged();
    }

    static Decorator getDecorator(DesignView designView) {
        List<DecorationProvider> list = designView.getDecorationManager().getProviders();
        for (DecorationProvider decorationProvider : list) {
            if (!(decorationProvider instanceof Decorator)) continue;
            return (Decorator)decorationProvider;
        }
        return null;
    }
}

