/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import java.io.File;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.debug.Context;
import org.jruby.debug.DebugBreakpoint;
import org.jruby.debug.DebugContext;
import org.jruby.debug.DebugFrame;
import org.jruby.debug.Debugger;
import org.jruby.debug.Util;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

final class DebugEventHook
implements EventHook {
    private final Debugger debugger;
    private final Ruby runtime;
    private int hookCount;
    private int lastDebuggedThnum;
    private int lastCheck;
    private boolean inDebugger;

    public DebugEventHook(Debugger debugger, Ruby runtime) {
        this.debugger = debugger;
        this.lastDebuggedThnum = -1;
        this.runtime = runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(ThreadContext tCtx, int event, String file, int line0, String methodName, IRubyObject klass) {
        boolean needsSuspend = false;
        RubyThread currThread = tCtx.getThread();
        Debugger.DebugContextPair contexts = this.debugger.threadContextLookup(currThread, true);
        if (contexts.debugContext.isIgnored()) {
            return;
        }
        if (contexts.debugContext.isSkipped()) {
            this.cleanUp(contexts.debugContext);
            return;
        }
        if (Util.isJRubyCore(file)) {
            return;
        }
        needsSuspend = contexts.debugContext.isSuspended();
        if (needsSuspend) {
            RubyThread.stop((IRubyObject)currThread);
        }
        DebugEventHook debugEventHook = this;
        synchronized (debugEventHook) {
            if (this.isInDebugger()) {
                return;
            }
            this.setInDebugger(true);
            try {
                this.processEvent(tCtx, event, Util.relativizeToPWD(file), line0, methodName, klass, contexts);
            }
            finally {
                this.setInDebugger(false);
            }
        }
    }

    private void processEvent(ThreadContext tCtx, int event, String file, int line0, String methodName, IRubyObject klass, Debugger.DebugContextPair contexts) {
        if (this.debugger.isDebug()) {
            Util.logEvent(event, file, line0, methodName, klass);
        }
        int line = line0 + 1;
        ++this.hookCount;
        Ruby runtime = tCtx.getRuntime();
        IRubyObject breakpoint = this.getNil();
        IRubyObject binding = this.getNil();
        Context context = contexts.context;
        DebugContext debugContext = contexts.debugContext;
        boolean moved = false;
        if (debugContext.getLastLine() != line || debugContext.getLastFile() == null || !Util.areSameFiles(debugContext.getLastFile(), file)) {
            debugContext.setEnableBreakpoint(true);
            moved = true;
        }
        if (event != 0) {
            debugContext.setStepped(true);
        }
        block0 : switch (event) {
            case 0: {
                if (debugContext.getStackSize() == 0) {
                    this.saveCallFrame(event, tCtx, file, line, methodName, debugContext);
                } else {
                    this.updateTopFrame(event, debugContext, tCtx, file, line, methodName);
                }
                if (this.debugger.isTracing() || debugContext.isTracing()) {
                    IRubyObject[] args = new IRubyObject[]{runtime.newString(file), runtime.newFixnum((long)line)};
                    context.callMethod(tCtx, "at_tracing", args);
                }
                if (debugContext.getDestFrame() == -1 || debugContext.getStackSize() == debugContext.getDestFrame()) {
                    if (moved || !debugContext.isForceMove()) {
                        debugContext.setStopNext(debugContext.getStopNext() - 1);
                    }
                    if (debugContext.getStopNext() < 0) {
                        debugContext.setStopNext(-1);
                    }
                    if (moved || debugContext.isStepped() && !debugContext.isForceMove()) {
                        debugContext.setStopLine(debugContext.getStopLine() - 1);
                        debugContext.setStepped(false);
                    }
                } else if (debugContext.getStackSize() < debugContext.getDestFrame()) {
                    debugContext.setStopNext(0);
                }
                if (debugContext.getStopNext() != 0 && debugContext.getStopLine() != 0 && (breakpoint = this.checkBreakpointsByPos(debugContext, file, line)).isNil()) break;
                binding = tCtx != null ? RubyBinding.newBinding((Ruby)runtime) : this.getNil();
                this.saveTopBinding(debugContext, binding);
                debugContext.setStopReason(DebugContext.StopReason.STEP);
                if (!breakpoint.isNil()) {
                    if (!this.checkBreakpointExpression(tCtx, breakpoint, binding) || !this.checkBreakpointHitCondition(breakpoint)) break;
                    if (breakpoint != debugContext.getBreakpoint()) {
                        debugContext.setStopReason(DebugContext.StopReason.BREAKPOINT);
                        context.callMethod(tCtx, "at_breakpoint", breakpoint);
                    } else {
                        debugContext.setBreakpoint(this.getNil());
                    }
                }
                debugContext.setDestFrame(-1);
                debugContext.setStopLine(-1);
                debugContext.setStopNext(-1);
                this.callAtLine(tCtx, (IRubyObject)context, debugContext, runtime, file, line);
                break;
            }
            case 3: {
                this.saveCallFrame(event, tCtx, file, line, methodName, debugContext);
                breakpoint = this.checkBreakpointsByMethod(debugContext, klass, methodName);
                if (breakpoint.isNil()) break;
                DebugFrame debugFrame = this.getTopFrame(debugContext);
                if (debugFrame != null) {
                    binding = debugFrame.getBinding();
                }
                if (tCtx != null && binding.isNil()) {
                    binding = RubyBinding.newBinding((Ruby)runtime);
                }
                this.saveTopBinding(debugContext, binding);
                if (!this.checkBreakpointExpression(tCtx, breakpoint, binding) || !this.checkBreakpointHitCondition(breakpoint)) break;
                if (breakpoint != debugContext.getBreakpoint()) {
                    debugContext.setStopReason(DebugContext.StopReason.BREAKPOINT);
                    context.callMethod(tCtx, "at_breakpoint", breakpoint);
                } else {
                    debugContext.setBreakpoint(this.getNil());
                }
                this.callAtLine(tCtx, (IRubyObject)context, debugContext, runtime, file, line);
                break;
            }
            case 5: {
                if (this.cCallNewFrameP(klass)) {
                    this.saveCallFrame(event, tCtx, file, line, methodName, debugContext);
                    break;
                }
                this.updateTopFrame(event, debugContext, tCtx, file, line, methodName);
                break;
            }
            case 6: {
                if (!this.cCallNewFrameP(klass)) break;
            }
            case 2: 
            case 4: {
                DebugFrame topFrame;
                String origMethodName;
                if (debugContext.getStackSize() == debugContext.getStopFrame()) {
                    debugContext.setStopNext(1);
                    debugContext.setStopFrame(0);
                }
                while (!(debugContext.getStackSize() <= 0 || (origMethodName = (topFrame = debugContext.popFrame()).getOrigMethodName()) == null && methodName == null || origMethodName != null && origMethodName.equals(methodName))) {
                }
                debugContext.setEnableBreakpoint(true);
                break;
            }
            case 1: {
                this.resetTopFrameMethodName(debugContext);
                this.saveCallFrame(event, tCtx, file, line, methodName, debugContext);
                break;
            }
            case 7: {
                this.updateTopFrame(event, debugContext, tCtx, file, line, methodName);
                IRubyObject exception = runtime.getGlobalVariables().get("$!");
                if (exception.isNil()) {
                    assert (tCtx.isWithinDefined()) : "$! should be nil only when within defined?";
                    break;
                }
                if (runtime.getClass("SystemExit").isInstance(exception) || this.debugger.getCatchpoints().isNil() || this.debugger.getCatchpoints().isEmpty()) break;
                RubyArray ancestors = exception.getType().ancestors();
                int l = ancestors.getLength();
                for (int i = 0; i < l; ++i) {
                    RubyModule module = (RubyModule)ancestors.get(i);
                    RubyString modName = module.name();
                    IRubyObject hitCount = this.debugger.getCatchpoints().op_aref(tCtx, (IRubyObject)modName);
                    if (hitCount.isNil()) continue;
                    hitCount = runtime.newFixnum((long)(RubyFixnum.fix2int((IRubyObject)hitCount) + 1));
                    this.debugger.getCatchpoints().op_aset(tCtx, (IRubyObject)modName, hitCount);
                    debugContext.setStopReason(DebugContext.StopReason.CATCHPOINT);
                    context.callMethod(tCtx, "at_catchpoint", exception);
                    DebugFrame debugFrame = this.getTopFrame(debugContext);
                    if (debugFrame != null) {
                        binding = debugFrame.getBinding();
                    }
                    if (tCtx != null && binding.isNil()) {
                        binding = RubyBinding.newBinding((Ruby)runtime);
                    }
                    this.saveTopBinding(debugContext, binding);
                    this.callAtLine(tCtx, (IRubyObject)context, debugContext, runtime, file, line);
                    break block0;
                }
                break;
            }
        }
        this.cleanUp(debugContext);
    }

    private IRubyObject getNil() {
        return this.runtime.getNil();
    }

    private IRubyObject getBreakpoints() {
        return this.debugger.getBreakpoints();
    }

    private void cleanUp(DebugContext debugContext) {
        debugContext.setStopReason(DebugContext.StopReason.NONE);
        if (this.hookCount - this.lastCheck > 3000) {
            this.debugger.checkThreadContexts(this.runtime);
            this.lastCheck = this.hookCount;
        }
    }

    public boolean isInterestedInEvent(int event) {
        return true;
    }

    private void saveCallFrame(int event, ThreadContext tCtx, String file, int line, String methodName, DebugContext debugContext) {
        RubyBinding binding = this.debugger.isKeepFrameBinding() ? RubyBinding.newBinding((Ruby)tCtx.getRuntime()) : tCtx.getRuntime().getNil();
        DebugFrame debugFrame = new DebugFrame();
        debugFrame.setFile(file);
        debugFrame.setLine(line);
        debugFrame.setBinding((IRubyObject)binding);
        debugFrame.setMethodName(methodName);
        debugFrame.setOrigMethodName(methodName);
        debugFrame.setDead(false);
        debugFrame.setSelf(tCtx.getFrameSelf());
        DebugFrame.Info info = debugFrame.getInfo();
        info.setFrame(tCtx.getCurrentFrame());
        info.setScope(tCtx.getCurrentScope().getStaticScope());
        info.setDynaVars(event == 0 ? tCtx.getCurrentScope() : null);
        debugContext.addFrame(debugFrame);
        if (this.debugger.isTrackFrameArgs()) {
            this.copyScalarArgs(tCtx, debugFrame);
        } else {
            debugFrame.setArgValues(this.runtime.getNil());
        }
    }

    private boolean isArgValueSmall(IRubyObject value) {
        return value == RubyObject.UNDEF || value instanceof RubyFixnum || value instanceof RubyFloat || value instanceof RubyNil || value instanceof RubyModule || value instanceof RubyFile || value instanceof RubyBoolean || value instanceof RubySymbol;
    }

    private void copyScalarArgs(ThreadContext tCtx, DebugFrame debugFrame) {
        RubyArray args = this.runtime.newArray(tCtx.getCurrentScope().getArgValues());
        int len = args.getLength();
        for (int i = 0; i < len; ++i) {
            IRubyObject obj = args.entry(i);
            if (this.isArgValueSmall(obj)) continue;
            args.store((long)i, (IRubyObject)this.runtime.newString(obj.getType().getName()));
        }
        debugFrame.setArgValues((IRubyObject)args);
    }

    private void updateTopFrame(int event, DebugContext debug_context, ThreadContext tCtx, String file, int line, String methodName) {
        DebugFrame topFrame = this.getTopFrame(debug_context);
        if (topFrame != null) {
            topFrame.setSelf(tCtx.getFrameSelf());
            topFrame.setFile(file);
            topFrame.setLine(line);
            topFrame.setMethodName(methodName);
            topFrame.getInfo().setDynaVars(event == 5 ? null : tCtx.getCurrentScope());
        }
    }

    private DebugFrame getTopFrame(DebugContext debugContext) {
        if (debugContext.getStackSize() == 0) {
            return null;
        }
        return debugContext.getTopFrame();
    }

    private IRubyObject checkBreakpointsByPos(DebugContext debugContext, String file, int line) {
        if (!debugContext.isEnableBreakpoint()) {
            return this.getNil();
        }
        if (this.checkBreakpointByPos(debugContext.getBreakpoint(), file, line)) {
            return debugContext.getBreakpoint();
        }
        RubyArray arr = this.getBreakpoints().convertToArray();
        if (arr.isEmpty()) {
            return this.getNil();
        }
        for (int i = 0; i < arr.size(); ++i) {
            IRubyObject breakpoint = arr.entry(i);
            if (!this.checkBreakpointByPos(breakpoint, file, line)) continue;
            return breakpoint;
        }
        return this.getNil();
    }

    private boolean checkBreakpointByPos(IRubyObject breakpoint, String file, int line) {
        String fileName;
        if (breakpoint.isNil()) {
            return false;
        }
        DebugBreakpoint debugBreakpoint = (DebugBreakpoint)breakpoint.dataGetStruct();
        if (!debugBreakpoint.isEnabled()) {
            return false;
        }
        if (debugBreakpoint.getType() != DebugBreakpoint.Type.POS) {
            return false;
        }
        if (debugBreakpoint.getPos().getLine() != line) {
            return false;
        }
        String source = ((RubyString)debugBreakpoint.getSource()).toString();
        String sourceName = new File(source).getName();
        return sourceName.equals(fileName = new File(file).getName());
    }

    private IRubyObject checkBreakpointsByMethod(DebugContext debugContext, IRubyObject klass, String methodName) {
        if (!debugContext.isEnableBreakpoint()) {
            return this.getNil();
        }
        if (this.checkBreakpointByMethod(debugContext.getBreakpoint(), klass, methodName)) {
            return debugContext.getBreakpoint();
        }
        RubyArray arr = this.getBreakpoints().convertToArray();
        if (arr.isEmpty()) {
            return this.getNil();
        }
        for (int i = 0; i < arr.size(); ++i) {
            IRubyObject breakpoint = arr.entry(i);
            if (!this.checkBreakpointByMethod(breakpoint, klass, methodName)) continue;
            return breakpoint;
        }
        return this.getNil();
    }

    private boolean checkBreakpointByMethod(IRubyObject breakpoint, IRubyObject klass, String methodName) {
        if (breakpoint.isNil()) {
            return false;
        }
        DebugBreakpoint debugBreakpoint = (DebugBreakpoint)breakpoint.dataGetStruct();
        if (!debugBreakpoint.isEnabled()) {
            return false;
        }
        if (debugBreakpoint.getType() != DebugBreakpoint.Type.METHOD) {
            return false;
        }
        if (!debugBreakpoint.getPos().getMethodName().equals(methodName)) {
            return false;
        }
        return debugBreakpoint.getSource().asString().eql((IRubyObject)klass.asString());
    }

    private boolean checkBreakpointExpression(ThreadContext tCtx, IRubyObject breakpoint, IRubyObject binding) {
        DebugBreakpoint debugBreakpoint = (DebugBreakpoint)breakpoint.dataGetStruct();
        if (debugBreakpoint.getExpr().isNil()) {
            return true;
        }
        try {
            IRubyObject result = RubyKernel.eval((ThreadContext)tCtx, (IRubyObject)breakpoint, (IRubyObject[])new IRubyObject[]{debugBreakpoint.getExpr(), binding}, (Block)Block.NULL_BLOCK);
            return result.isTrue();
        }
        catch (RaiseException e) {
            return false;
        }
    }

    private boolean checkBreakpointHitCondition(IRubyObject breakpoint) {
        DebugBreakpoint debugBreakpoint = (DebugBreakpoint)breakpoint.dataGetStruct();
        debugBreakpoint.setHitCount(debugBreakpoint.getHitCount() + 1);
        if (debugBreakpoint.getHitCondition() == null) {
            return true;
        }
        switch (debugBreakpoint.getHitCondition()) {
            case NONE: {
                return true;
            }
            case GE: {
                if (debugBreakpoint.getHitCount() < debugBreakpoint.getHitValue()) break;
                return true;
            }
            case EQ: {
                if (debugBreakpoint.getHitCount() != debugBreakpoint.getHitValue()) break;
                return true;
            }
            case MOD: {
                if (debugBreakpoint.getHitCount() % debugBreakpoint.getHitValue() != 0) break;
                return true;
            }
        }
        return false;
    }

    private void saveTopBinding(DebugContext context, IRubyObject binding) {
        DebugFrame debugFrame = this.getTopFrame(context);
        if (debugFrame != null) {
            debugFrame.setBinding(binding);
        }
    }

    private IRubyObject callAtLine(ThreadContext tCtx, IRubyObject context, DebugContext debugContext, Ruby runtime, String file, int line) {
        return this.callAtLine(tCtx, context, debugContext, (IRubyObject)runtime.newString(file), (IRubyObject)runtime.newFixnum((long)line));
    }

    private IRubyObject callAtLine(ThreadContext tCtx, IRubyObject context, DebugContext debugContext, IRubyObject file, IRubyObject line) {
        this.lastDebuggedThnum = debugContext.getThnum();
        this.saveCurrentPosition(debugContext);
        IRubyObject[] args = new IRubyObject[]{file, line};
        return context.callMethod(tCtx, "at_line", args);
    }

    private void saveCurrentPosition(DebugContext debugContext) {
        DebugFrame debugFrame = this.getTopFrame(debugContext);
        if (debugFrame == null) {
            return;
        }
        debugContext.setLastFile(debugFrame.getFile());
        debugContext.setLastLine(debugFrame.getLine());
        debugContext.setEnableBreakpoint(false);
        debugContext.setStepped(false);
        debugContext.setForceMove(false);
    }

    private boolean cCallNewFrameP(IRubyObject klass) {
        String cName = (klass = this.realClass(klass)).getType().getName();
        return "Proc".equals(cName) || "RubyKernel".equals(cName) || "Module".equals(cName);
    }

    private IRubyObject realClass(IRubyObject klass) {
        if (klass instanceof MetaClass) {
            return ((MetaClass)klass).getRealClass();
        }
        return klass;
    }

    private void resetTopFrameMethodName(DebugContext debugContext) {
        DebugFrame topFrame = this.getTopFrame(debugContext);
        if (topFrame != null) {
            topFrame.setMethodName("");
        }
    }

    private boolean isInDebugger() {
        return this.inDebugger;
    }

    private void setInDebugger(boolean inDebugger) {
        this.inDebugger = inDebugger;
    }

    int getLastDebuggedThnum() {
        return this.lastDebuggedThnum;
    }
}

