/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.core.startup.DOMFactoryImpl;
import org.netbeans.core.startup.LazyIterator;
import org.openide.util.Exceptions;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXFactoryImpl
extends SAXParserFactory {
    private Map<String, Boolean> features = new LinkedHashMap<String, Boolean>();
    private static final String SAXParserFactory_PROP = "javax.xml.parsers.SAXParserFactory";

    private static Class<? extends SAXParserFactory> getFirst() {
        try {
            String string = System.getProperty("nb.backup.javax.xml.parsers.SAXParserFactory");
            return string == null ? null : Class.forName(string, true, ClassLoader.getSystemClassLoader()).asSubclass(SAXParserFactory.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
            return null;
        }
    }

    public static void install() {
        System.getProperties().put(SAXParserFactory_PROP, SAXFactoryImpl.class.getName());
    }

    @Override
    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.features.get(string);
    }

    @Override
    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        SAXParser sAXParser = this.tryCreate();
        return sAXParser;
    }

    @Override
    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.features.put(string, bl);
        this.tryCreate();
    }

    private SAXParser tryCreate() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        LazyIterator<SAXFactoryImpl> lazyIterator = new LazyIterator<SAXFactoryImpl>(SAXFactoryImpl.getFirst(), SAXParserFactory.class, SAXFactoryImpl.class);
        while (lazyIterator.hasNext()) {
            try {
                SAXParser sAXParser = this.tryCreate((Class)lazyIterator.next());
                return sAXParser;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (lazyIterator.hasNext()) continue;
                throw parserConfigurationException;
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                if (lazyIterator.hasNext()) continue;
                throw sAXNotRecognizedException;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                if (lazyIterator.hasNext()) continue;
                throw sAXNotSupportedException;
            }
            catch (ClassCastException classCastException) {
                if (lazyIterator.hasNext()) continue;
                throw classCastException;
            }
            catch (SAXException sAXException) {
                if (lazyIterator.hasNext()) continue;
                throw new ParserConfigurationException();
            }
        }
        throw new IllegalStateException("Can't get here!");
    }

    private SAXParser tryCreate(Class<? extends SAXParserFactory> clazz) throws ParserConfigurationException, SAXException {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            SAXParserFactory sAXParserFactory = clazz.newInstance();
            sAXParserFactory.setValidating(this.isValidating());
            sAXParserFactory.setNamespaceAware(this.isNamespaceAware());
            for (Map.Entry<String, Boolean> entry : this.features.entrySet()) {
                sAXParserFactory.setFeature(entry.getKey(), entry.getValue());
            }
            return sAXParserFactory.newSAXParser();
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        throw (ParserConfigurationException)new ParserConfigurationException("Broken factory").initCause(reflectiveOperationException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        if (SAXFactoryImpl.getFirst() == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                System.setProperty("nb.backup.javax.xml.parsers.SAXParserFactory", SAXParserFactory.newInstance().getClass().getName());
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        DOMFactoryImpl.install();
        SAXFactoryImpl.install();
    }
}

