/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.jpda;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.Variable;

public abstract class EditorContext {
    public static final String BREAKPOINT_ANNOTATION_TYPE = "Breakpoint";
    public static final String DISABLED_BREAKPOINT_ANNOTATION_TYPE = "DisabledBreakpoint";
    public static final String CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "CondBreakpoint";
    public static final String DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "DisabledCondBreakpoint";
    public static final String FIELD_BREAKPOINT_ANNOTATION_TYPE = "FieldBreakpoint";
    public static final String DISABLED_FIELD_BREAKPOINT_ANNOTATION_TYPE = "DisabledFieldBreakpoint";
    public static final String METHOD_BREAKPOINT_ANNOTATION_TYPE = "MethodBreakpoint";
    public static final String DISABLED_METHOD_BREAKPOINT_ANNOTATION_TYPE = "DisabledMethodBreakpoint";
    public static final String CURRENT_LINE_ANNOTATION_TYPE = "CurrentPC";
    public static final String CALL_STACK_FRAME_ANNOTATION_TYPE = "CallSite";
    public static final String CURRENT_LAST_OPERATION_ANNOTATION_TYPE = "LastOperation";
    public static final String CURRENT_OUT_OPERATION_ANNOTATION_TYPE = "StepOutOperation";
    public static final String CURRENT_EXPRESSION_SECONDARY_LINE_ANNOTATION_TYPE = "CurrentExpression";
    public static final String CURRENT_EXPRESSION_CURRENT_LINE_ANNOTATION_TYPE = "CurrentExpressionLine";
    public static final String OTHER_THREAD_ANNOTATION_TYPE = "OtherThread";
    public static final String PROP_LINE_NUMBER = "lineNumber";

    public abstract boolean showSource(String var1, int var2, Object var3);

    public abstract void createTimeStamp(Object var1);

    public abstract void disposeTimeStamp(Object var1);

    public abstract void updateTimeStamp(Object var1, String var2);

    public abstract Object annotate(String var1, int var2, String var3, Object var4);

    public Object annotate(String string, int n, String string2, Object object, JPDAThread jPDAThread) {
        return null;
    }

    public Object annotate(String string, int n, int n2, String string2, Object object) {
        return null;
    }

    public abstract int getLineNumber(Object var1, Object var2);

    public abstract void removeAnnotation(Object var1);

    public abstract int getCurrentLineNumber();

    public abstract String getCurrentClassName();

    public abstract String getCurrentURL();

    public abstract String getCurrentMethodName();

    public abstract String getCurrentFieldName();

    public abstract String getSelectedIdentifier();

    public abstract String getSelectedMethodName();

    public abstract int getFieldLineNumber(String var1, String var2, String var3);

    public int getMethodLineNumber(String string, String string2, String string3, String string4) {
        return -1;
    }

    public String[] getCurrentMethodDeclaration() {
        return null;
    }

    public abstract String getClassName(String var1, int var2);

    public abstract String[] getImports(String var1);

    protected final Operation createMethodOperation(Position position, Position position2, Position position3, Position position4, String string, String string2, int n) {
        return new Operation(position, position2, position3, position4, string, string2, n);
    }

    protected final void addNextOperationTo(Operation operation, Operation operation2) {
        operation.addNextOperation(operation2);
    }

    protected final Position createPosition(int n, int n2, int n3) {
        return new Position(n, n2, n3);
    }

    public Operation[] getOperations(String string, int n, BytecodeProvider bytecodeProvider) {
        throw new UnsupportedOperationException("This method is not implemented.");
    }

    public MethodArgument[] getArguments(String string, Operation operation) {
        throw new UnsupportedOperationException("This method is not implemented by " + this);
    }

    public MethodArgument[] getArguments(String string, int n) {
        throw new UnsupportedOperationException("This method is not implemented by " + this);
    }

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public abstract void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public abstract void removePropertyChangeListener(String var1, PropertyChangeListener var2);

    public static final class MethodArgument {
        private String name;
        private String type;
        private Position startPos;
        private Position endPos;

        public MethodArgument(String string, String string2, Position position, Position position2) {
            this.name = string;
            this.type = string2;
            this.startPos = position;
            this.endPos = position2;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public Position getStartPosition() {
            return this.startPos;
        }

        public Position getEndPosition() {
            return this.endPos;
        }
    }

    public static final class Position {
        private final int offset;
        private final int line;
        private final int column;

        Position(int n, int n2, int n3) {
            this.offset = n;
            this.line = n2;
            this.column = n3;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(Object object) {
            if (object instanceof Position) {
                Position position = (Position)object;
                return position.offset == this.offset;
            }
            return false;
        }

        public int hashCode() {
            return this.offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Operation {
        private final Position startPosition;
        private final Position endPosition;
        private final int bytecodeIndex;
        private Position methodStartPosition;
        private Position methodEndPosition;
        private String methodName;
        private String methodClassType;
        private Variable returnValue;
        private List<Operation> nextOperations;

        Operation(Position position, Position position2, Position position3, Position position4, String string, String string2, int n) {
            this.startPosition = position;
            this.endPosition = position2;
            this.bytecodeIndex = n;
            this.methodStartPosition = position3;
            this.methodEndPosition = position4;
            this.methodName = string;
            this.methodClassType = string2;
        }

        synchronized void addNextOperation(Operation operation) {
            if (this.nextOperations == null) {
                this.nextOperations = new ArrayList<Operation>();
            }
            this.nextOperations.add(operation);
        }

        public Position getStartPosition() {
            return this.startPosition;
        }

        public Position getEndPosition() {
            return this.endPosition;
        }

        public Position getMethodStartPosition() {
            return this.methodStartPosition;
        }

        public Position getMethodEndPosition() {
            return this.methodEndPosition;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodClassType() {
            return this.methodClassType;
        }

        public int getBytecodeIndex() {
            return this.bytecodeIndex;
        }

        public void setReturnValue(Variable variable) {
            this.returnValue = variable;
        }

        public Variable getReturnValue() {
            return this.returnValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Operation> getNextOperations() {
            if (this.nextOperations == null) {
                return Collections.emptyList();
            }
            Operation operation = this;
            synchronized (operation) {
                return Collections.unmodifiableList(this.nextOperations);
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Operation) {
                Operation operation = (Operation)object;
                return this.bytecodeIndex == operation.bytecodeIndex && (this.startPosition == null ? operation.startPosition == null : this.startPosition.equals(operation.startPosition)) && (this.endPosition == null ? operation.endPosition == null : this.endPosition.equals(operation.endPosition));
            }
            return false;
        }

        public int hashCode() {
            return this.bytecodeIndex;
        }
    }

    public static interface BytecodeProvider {
        public byte[] constantPool();

        public byte[] byteCodes();

        public int[] indexAtLines(int var1, int var2);
    }
}

