/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.spi.RakeTaskCustomizer;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.ui.Manager;
import org.netbeans.modules.ruby.testrunner.ui.RspecHandlerFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizer;
import org.netbeans.modules.ruby.testrunner.ui.TestSession;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RspecRunner
implements TestRunner,
RakeTaskCustomizer {
    private static final String PLUGIN_SPEC_PATH = "vendor/plugins/rspec/bin/spec";
    private static final TestRunner INSTANCE = new RspecRunner();
    private static final String SPEC_OPTS = "spec/spec.opts";
    private static final String NETBEANS_SPEC_OPTS = "spec/spec.opts.netbeans";
    public static final String RSPEC_MEDIATOR_SCRIPT = "nb_rspec_mediator.rb";

    public TestRunner getInstance() {
        return INSTANCE;
    }

    public boolean supports(TestRunner.TestType testType) {
        return TestRunner.TestType.RSPEC == testType;
    }

    public void runTest(FileObject fileObject, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        this.run(FileOwnerQuery.getOwner((FileObject)fileObject), arrayList2, fileObject.getName(), bl);
    }

    public void runSingleTest(FileObject fileObject, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--line");
        arrayList.add(string);
        arrayList.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        this.run(FileOwnerQuery.getOwner((FileObject)fileObject), arrayList, fileObject.getName(), bl);
    }

    public void runAllTests(Project project, boolean bl) {
        RubyBaseProject rubyBaseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        FileObject[] fileObjectArray = rubyBaseProject.getTestSourceRootFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FileObject fileObject : fileObjectArray) {
            Enumeration enumeration = fileObject.getChildren(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2.isFolder() || !"rb".equals(fileObject2.getExt()) || !fileObject2.getName().endsWith("spec")) continue;
                arrayList.add(FileUtil.toFile((FileObject)fileObject2).getAbsolutePath());
            }
        }
        this.run(project, arrayList, ProjectUtils.getInformation((Project)project).getDisplayName(), bl);
    }

    private void run(Project project, List<String> list, String string, boolean bl) {
        FileLocator fileLocator = (FileLocator)project.getLookup().lookup(FileLocator.class);
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        if (list.isEmpty()) {
            TestSession testSession = new TestSession(fileLocator, bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST);
            Manager.getInstance().emptyTestRun(testSession);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--require");
        arrayList.add(RspecRunner.getMediatorScript().getAbsolutePath());
        arrayList.add("--runner");
        arrayList.add("NbRspecMediator");
        RspecRunner.addSpecOpts(project, list);
        arrayList.addAll(list);
        ExecutionDescriptor executionDescriptor = null;
        Object var9_10 = null;
        executionDescriptor = new ExecutionDescriptor(rubyPlatform, string, FileUtil.toFile((FileObject)project.getProjectDirectory()), this.getSpec(project).getAbsolutePath());
        executionDescriptor.additionalArgs(arrayList.toArray(new String[arrayList.size()]));
        executionDescriptor.initialArgs(RubyProjectUtil.getLoadPath((Project)project));
        executionDescriptor.debug(bl);
        executionDescriptor.allowInput();
        executionDescriptor.fileLocator(fileLocator);
        executionDescriptor.addStandardRecognizers();
        TestRecognizer testRecognizer = new TestRecognizer(Manager.getInstance(), fileLocator, RspecHandlerFactory.getHandlers(), bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST);
        TestExecutionManager.getInstance().start(executionDescriptor, testRecognizer);
    }

    private File getSpec(Project project) {
        FileObject fileObject;
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        String string = rubyPlatform.findExecutable("spec");
        if (string != null) {
            return new File(string);
        }
        FileObject fileObject2 = project.getProjectDirectory();
        if (fileObject2 != null && (fileObject = fileObject2.getFileObject(PLUGIN_SPEC_PATH)) != null) {
            return FileUtil.toFile((FileObject)fileObject);
        }
        assert (false) : "Could not find RSpec binary";
        return null;
    }

    private static File getMediatorScript() {
        File file = InstalledFileLocator.getDefault().locate(RSPEC_MEDIATOR_SCRIPT, "org.netbeans.modules.ruby.testrunner", false);
        if (file == null) {
            throw new IllegalStateException("Could not locate nb_rspec_mediator.rb");
        }
        return file;
    }

    private static void addSpecOpts(Project project, List<String> list) {
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject(NETBEANS_SPEC_OPTS);
        if (fileObject2 == null) {
            fileObject2 = fileObject.getFileObject(SPEC_OPTS);
        }
        if (fileObject2 != null) {
            list.add("--options");
            list.add(FileUtil.toFile((FileObject)fileObject2).getAbsolutePath());
        }
    }

    public void customize(Project project, RakeTask rakeTask, ExecutionDescriptor executionDescriptor, boolean bl) {
        if (!rakeTask.getTask().equals("spec")) {
            return;
        }
        rakeTask.addTaskParameters(new String[]{"SPEC_OPTS=\"--require " + RspecRunner.getMediatorScript().getAbsolutePath() + " --runner NbRspecMediator\""});
        FileLocator fileLocator = (FileLocator)project.getLookup().lookup(FileLocator.class);
        TestRecognizer testRecognizer = new TestRecognizer(Manager.getInstance(), fileLocator, RspecHandlerFactory.getHandlers(), bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST);
        executionDescriptor.addOutputRecognizer((OutputRecognizer)testRecognizer);
    }
}

