/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.ruby.testrunner.TestRunnerSettings;
import org.netbeans.modules.ruby.testrunner.ui.Report;
import org.netbeans.modules.ruby.testrunner.ui.ResultPanelOutput;
import org.netbeans.modules.ruby.testrunner.ui.ResultPanelTree;
import org.netbeans.modules.ruby.testrunner.ui.StatisticsPanel;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

final class ResultDisplayHandler {
    private static final Logger LOGGER = Logger.getLogger(ResultDisplayHandler.class.getName());
    private static ResourceBundle bundle = NbBundle.getBundle(ResultDisplayHandler.class);
    private ResultPanelTree treePanel;
    private ResultPanelOutput outputListener;
    private JSplitPane displayComp;
    static final Object[] EMPTY_QUEUE = new Object[0];
    private final Object queueLock = new Object();
    private volatile Object[] outputQueue;
    private volatile int outputQueueSize = 0;
    private int outputQueueAvailSpace;
    static final String ANONYMOUS_SUITE = new String();
    private String runningSuite;
    private final List<Report> reports = new ArrayList<Report>();
    private String message;
    private boolean sessionFinished;
    private Map<String, Method> methodsMap;

    ResultDisplayHandler() {
    }

    JSplitPane getDisplayComponent() {
        if (this.displayComp == null) {
            this.displayComp = this.createDisplayComp();
        }
        return this.displayComp;
    }

    private JSplitPane createDisplayComp() {
        TestRunnerSettings.DividerSettings dividerSettings = TestRunnerSettings.getDefault().getDividerSettings(null);
        return this.createDisplayComp(new StatisticsPanel(this), new ResultPanelOutput(this), dividerSettings.getOrientation(), dividerSettings.getLocation());
    }

    private JSplitPane createDisplayComp(Component component, Component component2, int n, final int n2) {
        JSplitPane jSplitPane = new JSplitPane(n, component, component2){

            public void addNotify() {
                super.addNotify();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        this.setDividerLocation(n2);
                    }
                });
            }

            public void removeNotify() {
                TestRunnerSettings.DividerSettings dividerSettings = new TestRunnerSettings.DividerSettings(this.getOrientation(), this.getDividerLocation());
                TestRunnerSettings.getDefault().setDividerSettings(dividerSettings);
                super.removeNotify();
            }
        };
        jSplitPane.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResultPanelTree"));
        jSplitPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResultPanelTree"));
        return jSplitPane;
    }

    void displayShown() {
    }

    void displayHidden() {
    }

    Object getOutputQueueLock() {
        return this.queueLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOutputListener(ResultPanelOutput resultPanelOutput) {
        Object object = this.queueLock;
        synchronized (object) {
            this.outputListener = resultPanelOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayOutput(String string, boolean bl) {
        Object object = this.queueLock;
        synchronized (object) {
            int n;
            if (this.outputQueue == null) {
                this.outputQueue = new Object[40];
                this.outputQueueAvailSpace = this.outputQueue.length - 1;
                this.outputQueueSize = 0;
            }
            int n2 = n = bl ? 2 : 1;
            if ((this.outputQueueAvailSpace -= n) < 0) {
                int n3 = this.outputQueue.length < 640 ? this.outputQueue.length * 2 : this.outputQueue.length * 3 / 2;
                Object[] objectArray = this.outputQueue;
                this.outputQueue = new Object[n3];
                System.arraycopy(objectArray, 0, this.outputQueue, 0, this.outputQueueSize);
                this.outputQueueAvailSpace += this.outputQueue.length - objectArray.length;
            }
            if (bl) {
                this.outputQueue[this.outputQueueSize++] = Boolean.TRUE;
            }
            this.outputQueue[this.outputQueueSize++] = string;
            if (this.outputListener != null) {
                this.outputListener.outputAvailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] consumeOutput() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.outputQueueSize == 0) {
                return EMPTY_QUEUE;
            }
            Object[] objectArray = this.outputQueue;
            this.outputQueue = null;
            this.outputQueueSize = 0;
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displaySuiteRunning(String string) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            assert (this.runningSuite == null);
            String string2 = string = string != null ? string : ANONYMOUS_SUITE;
            if (this.treePanel == null) {
                this.runningSuite = string;
                return;
            }
        }
        this.displayInDispatchThread("displaySuiteRunning", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayReport(Report report) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.reports.add(report);
                this.runningSuite = null;
                return;
            }
            assert (this.runningSuite == null);
        }
        this.displayInDispatchThread("displayReport", report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayMessage(String string) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.message = string;
                return;
            }
        }
        this.displayInDispatchThread("displayMsg", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayMessageSessionFinished(String string) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.sessionFinished = true;
                this.message = string;
                return;
            }
        }
        this.displayInDispatchThread("displayMsgSessionFinished", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayInDispatchThread(final String string, final Object object) {
        assert (string != null);
        Method method = null;
        Object object2 = this;
        synchronized (object2) {
            assert (this.treePanel != null);
            method = this.prepareMethod(string);
            if (method == null) {
                LOGGER.log(Level.WARNING, "No such method: " + string);
                return;
            }
        }
        object2 = method;
        EventQueue.invokeLater(new Runnable((Method)object2){
            final /* synthetic */ Method val$finalMethod;
            {
                this.val$finalMethod = method;
            }

            public void run() {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Invoking: " + string + " with param: " + object);
                    }
                    this.val$finalMethod.invoke((Object)ResultDisplayHandler.this.treePanel, object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(65536, (Throwable)exception);
                }
            }
        });
    }

    private Method prepareMethod(String string) {
        Method method;
        if (this.methodsMap == null) {
            this.methodsMap = new HashMap<String, Method>(4);
            method = null;
        } else {
            method = this.methodsMap.get(string);
        }
        if (method == null && !this.methodsMap.containsKey(string)) {
            Class clazz;
            if (string.equals("displayReport")) {
                clazz = Report.class;
            } else {
                assert (string.equals("displayMsg") || string.equals("displayMsgSessionFinished") || string.equals("displaySuiteRunning"));
                clazz = String.class;
            }
            try {
                method = ResultPanelTree.class.getDeclaredMethod(string, clazz);
            }
            catch (Exception exception) {
                method = null;
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
            this.methodsMap.put(string, method);
        }
        return method;
    }

    synchronized void setTreePanel(ResultPanelTree resultPanelTree) {
        assert (EventQueue.isDispatchThread());
        if (this.treePanel != null) {
            return;
        }
        this.treePanel = resultPanelTree;
        if (this.message != null) {
            resultPanelTree.displayMsg(this.message);
            this.message = null;
        }
        if (!this.reports.isEmpty()) {
            resultPanelTree.displayReports(this.reports);
            this.reports.clear();
        }
        if (this.runningSuite != null) {
            resultPanelTree.displaySuiteRunning(this.runningSuite != ANONYMOUS_SUITE ? this.runningSuite : null);
            this.runningSuite = null;
        }
        if (this.sessionFinished) {
            resultPanelTree.displayMsgSessionFinished(this.message);
        }
    }
}

