/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.testrunner.ui.Manager;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizerHandler;
import org.netbeans.modules.ruby.testrunner.ui.TestSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestRecognizer
extends OutputRecognizer {
    private static final Logger LOGGER = Logger.getLogger(TestRecognizer.class.getName());
    private final Manager manager;
    private TestSession session;
    private final FileLocator fileLocator;
    private final TestSession.SessionType sessionType;
    private final List<TestRecognizerHandler> handlers;

    public TestRecognizer(Manager manager, FileLocator fileLocator, List<TestRecognizerHandler> list, TestSession.SessionType sessionType) {
        this.manager = manager;
        this.fileLocator = fileLocator;
        this.handlers = list;
        this.sessionType = sessionType;
        this.session = new TestSession(fileLocator, sessionType);
    }

    public void refreshSession() {
        this.session = new TestSession(this.fileLocator, this.sessionType);
    }

    public void start() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Session starting: " + this.session);
        }
    }

    public OutputRecognizer.RecognizedOutput processLine(String string) {
        for (TestRecognizerHandler testRecognizerHandler : this.handlers) {
            if (!testRecognizerHandler.matches(string)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Handler [" + testRecognizerHandler + "] matched line: " + string);
            }
            try {
                testRecognizerHandler.updateUI(this.manager, this.session);
                return testRecognizerHandler.getRecognizedOutput();
            }
            catch (IllegalStateException illegalStateException) {
                LOGGER.log(Level.WARNING, "Failed to process line: " + string + " with handler: " + testRecognizerHandler, illegalStateException);
                return null;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "No handler for line: " + string);
        }
        this.manager.displayOutput(this.session, string, false);
        return null;
    }

    public void finish() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Session finished: " + this.session);
        }
        this.manager.sessionFinished(this.session);
    }
}

