/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.awt.Image;
import org.netbeans.modules.ruby.testrunner.ui.Report;
import org.netbeans.modules.ruby.testrunner.ui.ResultDisplayHandler;
import org.netbeans.modules.ruby.testrunner.ui.Status;
import org.netbeans.modules.ruby.testrunner.ui.TestsuiteNodeChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

final class TestsuiteNode
extends AbstractNode {
    private String suiteName;
    private Report report;
    private boolean filtered;

    TestsuiteNode(String string, boolean bl) {
        this(null, string, bl);
    }

    TestsuiteNode(Report report, boolean bl) {
        this(report, null, bl);
    }

    private TestsuiteNode(Report report, String string, boolean bl) {
        super((Children)(report != null ? new TestsuiteNodeChildren(report, bl) : Children.LEAF));
        this.report = report;
        this.suiteName = report != null ? report.suiteClassName : string;
        this.filtered = bl;
        assert (this.suiteName != null);
        this.setDisplayName();
        this.setIconBaseWithExtension("org/netbeans/modules/ruby/testrunner/ui/res/class.gif");
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public Image getIcon(int n) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/ruby/testrunner/ui/res/class.gif");
        if (this.containsFailed()) {
            Image image2 = ImageUtilities.loadImage((String)"org/netbeans/modules/ruby/testrunner/ui/res/error-badge.gif");
            return ImageUtilities.mergeImages((Image)image, (Image)image2, (int)0, (int)10);
        }
        return image;
    }

    void displayReport(Report report) {
        assert (this.report == null && report != null);
        assert (report.suiteClassName.equals(this.suiteName) || this.suiteName == ResultDisplayHandler.ANONYMOUS_SUITE);
        this.report = report;
        this.suiteName = report.suiteClassName;
        this.setDisplayName();
        this.setChildren((Children)new TestsuiteNodeChildren(report, this.filtered));
    }

    Report getReport() {
        return this.report;
    }

    private void setDisplayName() {
        boolean bl;
        String string = this.report == null ? (this.suiteName != ResultDisplayHandler.ANONYMOUS_SUITE ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteRunning", (Object)this.suiteName) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteRunningNoname")) : ((bl = this.containsFailed()) ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteFailed", (Object)this.suiteName) : this.suiteName);
        this.setDisplayName(string);
    }

    public String getHtmlDisplayName() {
        assert (this.suiteName != null);
        StringBuffer stringBuffer = new StringBuffer(60);
        if (this.suiteName != ResultDisplayHandler.ANONYMOUS_SUITE) {
            stringBuffer.append(this.suiteName);
            stringBuffer.append("&nbsp;&nbsp;");
        } else {
            stringBuffer.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteNoname"));
            stringBuffer.append("&nbsp;");
        }
        if (this.report != null) {
            Status status = this.report.getStatus();
            stringBuffer.append("<font color='#");
            stringBuffer.append(status.getHtmlDisplayColor() + "'>");
            stringBuffer.append(TestsuiteNode.suiteStatusToMsg(status, true));
            stringBuffer.append("</font>");
        } else {
            stringBuffer.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteRunning_HTML"));
        }
        return stringBuffer.toString();
    }

    static String suiteStatusToMsg(Status status, boolean bl) {
        String string = null;
        string = Status.ERROR == status || Status.FAILED == status ? "MSG_TestsuiteFailed" : (Status.PENDING == status ? "MSG_TestsuitePending" : "MSG_TestsuitePassed");
        string = bl ? string + "_HTML" : string;
        return NbBundle.getMessage(TestsuiteNode.class, (String)string);
    }

    void setFiltered(boolean bl) {
        if (bl == this.filtered) {
            return;
        }
        this.filtered = bl;
        Children children = this.getChildren();
        if (children != Children.LEAF) {
            ((TestsuiteNodeChildren)children).setFiltered(bl);
        }
    }

    private boolean containsFailed() {
        return this.report != null && this.report.failures + this.report.errors != 0;
    }

    public SystemAction[] getActions(boolean bl) {
        return new SystemAction[0];
    }
}

