/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.api;

import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsEnvironment;
import org.netbeans.modules.groovy.grails.settings.GrailsSettings;

public final class GrailsProjectConfig {
    private static final String DEFAULT_PORT = "8080";
    private final Project prj;
    private final GrailsSettings settings = GrailsSettings.getInstance();

    private GrailsProjectConfig(Project project) {
        this.prj = project;
    }

    public static GrailsProjectConfig forProject(Project project) {
        return new GrailsProjectConfig(project);
    }

    public Project getProject() {
        return this.prj;
    }

    public String getPort() {
        String string = this.settings.getPortForProject(this.prj);
        if (string == null) {
            string = DEFAULT_PORT;
        }
        return string;
    }

    public void setPort(String string) {
        assert (string != null);
        this.settings.setPortForProject(this.prj, string);
    }

    public GrailsEnvironment getEnvironment() {
        return this.settings.getEnvForProject(this.prj);
    }

    public void setEnvironment(GrailsEnvironment grailsEnvironment) {
        assert (grailsEnvironment != null);
        this.settings.setEnvForProject(this.prj, grailsEnvironment);
    }

    public String getDeployDir() {
        return this.settings.getDeployDirForProject(this.prj);
    }

    public void setDeployDir(String string) {
        assert (string != null);
        this.settings.setDeployDirForProject(this.prj, string);
    }

    public boolean getAutoDeployFlag() {
        return this.settings.getAutoDeployFlagForProject(this.prj);
    }

    public void setAutoDeployFlag(boolean bl) {
        this.settings.setAutoDeployFlagForProject(this.prj, bl);
    }

    public String getDebugBrowser() {
        return this.settings.getDebugBrowserForProject(this.prj);
    }

    public void setDebugBrowser(String string) {
        assert (string != null);
        this.settings.setDebugBrowserProject(this.prj, string);
    }
}

