/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.servicetag;

import org.netbeans.modules.servicetag.SystemEnvironment;

class LinuxSystemEnvironment
extends SystemEnvironment {
    private String dmiInfo = null;
    private static final int SN = 1;
    private static final int SYS = 2;
    private static final int CPU = 3;

    LinuxSystemEnvironment() {
        this.setHostId(this.getLinuxHostId());
        this.setSystemModel(this.getCommandOutput("/bin/uname", "-i"));
        this.setSystemManufacturer(this.getLinuxSystemManufacturer());
        this.setCpuManufacturer(this.getLinuxCpuManufacturer());
        this.setSerialNumber(this.getLinuxSN());
    }

    private String getLinuxHostId() {
        String string = this.getCommandOutput("/usr/bin/hostid");
        if (string.startsWith("0x")) {
            string = string.substring(2);
        }
        return string;
    }

    private String getLinuxCpuManufacturer() {
        String string = this.getLinuxPSNInfo(3);
        if (string.length() > 0) {
            return string;
        }
        String string2 = this.getFileContent("/proc/cpuinfo");
        for (String string3 : string2.split("\n")) {
            String[] stringArray;
            if (!string3.contains("vendor_id") || (stringArray = string3.split(":", 2)).length <= 1) continue;
            return stringArray[1].trim();
        }
        return this.getLinuxDMIInfo("dmi type 4", "manufacturer");
    }

    private String getLinuxSystemManufacturer() {
        String string = this.getLinuxPSNInfo(2);
        if (string.length() > 0) {
            return string;
        }
        return this.getLinuxDMIInfo("dmi type 1", "manufacturer");
    }

    private String getLinuxSN() {
        String string = this.getLinuxPSNInfo(1);
        if (string.length() > 0) {
            return string;
        }
        return this.getLinuxDMIInfo("dmi type 1", "serial number");
    }

    private String getLinuxPSNInfo(int n) {
        String string = this.getFileContent("/var/run/psn");
        String[] stringArray = string.split("\n");
        if (n <= stringArray.length) {
            return stringArray[n - 1];
        }
        return "";
    }

    private synchronized String getLinuxDMIInfo(String string, String string2) {
        if (this.dmiInfo == null) {
            Thread thread = new Thread(){

                public void run() {
                    LinuxSystemEnvironment.this.dmiInfo = LinuxSystemEnvironment.this.getCommandOutput("/usr/sbin/dmidecode");
                }
            };
            thread.start();
            try {
                thread.join(2000L);
                if (thread.isAlive()) {
                    thread.interrupt();
                    this.dmiInfo = "";
                }
            }
            catch (InterruptedException interruptedException) {
                thread.interrupt();
            }
        }
        if (this.dmiInfo.length() == 0) {
            return "";
        }
        boolean bl = false;
        for (String string3 : this.dmiInfo.split("\n")) {
            String string4 = string3.toLowerCase();
            if (bl) {
                if (!string4.contains(string2)) continue;
                String string5 = string2 + ":";
                int n = string4.indexOf(string5) + string5.length();
                if (string4.contains(string5) && n < string4.length()) {
                    return string4.substring(n).trim();
                }
                String[] stringArray = string4.split(":");
                return stringArray[stringArray.length - 1];
            }
            if (!string4.contains(string)) continue;
            bl = true;
        }
        return "";
    }
}

