/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.servicetag;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.netbeans.modules.servicetag.RegistrationData;
import org.netbeans.modules.servicetag.ServiceTag;
import org.netbeans.modules.servicetag.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RegistrationDocument {
    private static final String REGISTRATION_DATA_SCHEMA = "/org/netbeans/modules/servicetag/resources/product_registration.xsd";
    private static final String REGISTRATION_DATA_VERSION = "1.0";
    private static final String SERVICE_TAG_VERSION = "1.0";
    static final String ST_NODE_REGISTRATION_DATA = "registration_data";
    static final String ST_ATTR_REGISTRATION_VERSION = "version";
    static final String ST_NODE_ENVIRONMENT = "environment";
    static final String ST_NODE_HOSTNAME = "hostname";
    static final String ST_NODE_HOST_ID = "hostId";
    static final String ST_NODE_OS_NAME = "osName";
    static final String ST_NODE_OS_VERSION = "osVersion";
    static final String ST_NODE_OS_ARCH = "osArchitecture";
    static final String ST_NODE_SYSTEM_MODEL = "systemModel";
    static final String ST_NODE_SYSTEM_MANUFACTURER = "systemManufacturer";
    static final String ST_NODE_CPU_MANUFACTURER = "cpuManufacturer";
    static final String ST_NODE_SERIAL_NUMBER = "serialNumber";
    static final String ST_NODE_REGISTRY = "registry";
    static final String ST_ATTR_REGISTRY_URN = "urn";
    static final String ST_ATTR_REGISTRY_VERSION = "version";
    static final String ST_NODE_SERVICE_TAG = "service_tag";
    static final String ST_NODE_INSTANCE_URN = "instance_urn";
    static final String ST_NODE_PRODUCT_NAME = "product_name";
    static final String ST_NODE_PRODUCT_VERSION = "product_version";
    static final String ST_NODE_PRODUCT_URN = "product_urn";
    static final String ST_NODE_PRODUCT_PARENT_URN = "product_parent_urn";
    static final String ST_NODE_PRODUCT_PARENT = "product_parent";
    static final String ST_NODE_PRODUCT_DEFINED_INST_ID = "product_defined_inst_id";
    static final String ST_NODE_PRODUCT_VENDOR = "product_vendor";
    static final String ST_NODE_PLATFORM_ARCH = "platform_arch";
    static final String ST_NODE_TIMESTAMP = "timestamp";
    static final String ST_NODE_CONTAINER = "container";
    static final String ST_NODE_SOURCE = "source";
    static final String ST_NODE_INSTALLER_UID = "installer_uid";

    RegistrationDocument() {
    }

    static RegistrationData load(InputStream inputStream) throws IOException {
        Document document = RegistrationDocument.initializeDocument(inputStream);
        Element element = RegistrationDocument.getRegistrationDataRoot(document);
        Element element2 = RegistrationDocument.getSingletonElementFromRoot(element, ST_NODE_REGISTRY);
        String string = element2.getAttribute(ST_ATTR_REGISTRY_URN);
        RegistrationData registrationData = new RegistrationData(string);
        RegistrationDocument.addServiceTags(element2, registrationData);
        Element element3 = RegistrationDocument.getSingletonElementFromRoot(element, ST_NODE_ENVIRONMENT);
        RegistrationDocument.buildEnvironmentMap(element3, registrationData);
        return registrationData;
    }

    static void store(OutputStream outputStream, RegistrationData registrationData) throws IOException {
        Document document = RegistrationDocument.initializeDocument();
        RegistrationDocument.addEnvironmentNodes(document, registrationData.getEnvironmentMap());
        RegistrationDocument.addServiceTagRegistry(document, registrationData.getRegistrationURN(), registrationData.getServiceTags());
        RegistrationDocument.transform(document, outputStream);
    }

    private static Document initializeDocument(InputStream inputStream) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL uRL = RegistrationDocument.class.getResource(REGISTRATION_DATA_SCHEMA);
            Schema schema = schemaFactory.newSchema(uRL);
            Validator validator = schema.newValidator();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(inputStream));
            validator.validate(new DOMSource(document));
            return document;
        }
        catch (SAXException sAXException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error generated in parsing");
            illegalArgumentException.initCause(sAXException);
            throw illegalArgumentException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            InternalError internalError = new InternalError("Error in creating the new document");
            internalError.initCause(parserConfigurationException);
            throw internalError;
        }
    }

    private static Document initializeDocument() throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(ST_NODE_REGISTRATION_DATA);
            document.appendChild(element);
            element.setAttribute("version", "1.0");
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            InternalError internalError = new InternalError("Error in creating the new document");
            internalError.initCause(parserConfigurationException);
            throw internalError;
        }
    }

    private static void transform(Document document, OutputStream outputStream) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", new Integer(3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("standalone", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"))));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            InternalError internalError = new InternalError("Error generated during transformation");
            internalError.initCause(unsupportedEncodingException);
            throw internalError;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            InternalError internalError = new InternalError("Error in creating the new document");
            internalError.initCause(transformerConfigurationException);
            throw internalError;
        }
        catch (TransformerException transformerException) {
            InternalError internalError = new InternalError("Error generated during transformation");
            internalError.initCause(transformerException);
            throw internalError;
        }
    }

    private static void addServiceTagRegistry(Document document, String string, Set<ServiceTag> set) {
        Element element = document.createElement(ST_NODE_REGISTRY);
        element.setAttribute(ST_ATTR_REGISTRY_URN, string);
        element.setAttribute("version", "1.0");
        Element element2 = RegistrationDocument.getRegistrationDataRoot(document);
        element2.appendChild(element);
        for (ServiceTag serviceTag : set) {
            RegistrationDocument.addServiceTagElement(document, element, serviceTag);
        }
    }

    private static void addServiceTagElement(Document document, Element element, ServiceTag serviceTag) {
        Element element2 = document.createElement(ST_NODE_SERVICE_TAG);
        element.appendChild(element2);
        RegistrationDocument.addChildElement(document, element2, ST_NODE_INSTANCE_URN, serviceTag.getInstanceURN());
        RegistrationDocument.addChildElement(document, element2, ST_NODE_PRODUCT_NAME, serviceTag.getProductName());
        RegistrationDocument.addChildElement(document, element2, ST_NODE_PRODUCT_VERSION, serviceTag.getProductVersion());
        RegistrationDocument.addChildElement(document, element2, ST_NODE_PRODUCT_URN, serviceTag.getProductURN());
        RegistrationDocument.addChildElement(document, element2, ST_NODE_PRODUCT_PARENT_URN, serviceTag.getProductParentURN());
        RegistrationDocument.addChildElement(document, element2, ST_NODE_PRODUCT_PARENT, serviceTag.getProductParent());
        RegistrationDocument.addChildElement(document, element2, ST_NODE_PRODUCT_DEFINED_INST_ID, serviceTag.getProductDefinedInstanceID());
        RegistrationDocument.addChildElement(document, element2, ST_NODE_PRODUCT_VENDOR, serviceTag.getProductVendor());
        RegistrationDocument.addChildElement(document, element2, ST_NODE_PLATFORM_ARCH, serviceTag.getPlatformArch());
        RegistrationDocument.addChildElement(document, element2, ST_NODE_TIMESTAMP, Util.formatTimestamp(serviceTag.getTimestamp()));
        RegistrationDocument.addChildElement(document, element2, ST_NODE_CONTAINER, serviceTag.getContainer());
        RegistrationDocument.addChildElement(document, element2, ST_NODE_SOURCE, serviceTag.getSource());
        RegistrationDocument.addChildElement(document, element2, ST_NODE_INSTALLER_UID, String.valueOf(serviceTag.getInstallerUID()));
    }

    private static void addChildElement(Document document, Element element, String string, String string2) {
        Element element2 = document.createElement(string);
        element2.appendChild(document.createTextNode(string2));
        element.appendChild(element2);
    }

    private static void addServiceTags(Element element, RegistrationData registrationData) {
        NodeList nodeList = element.getElementsByTagName(ST_NODE_SERVICE_TAG);
        int n = nodeList == null ? 0 : nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            ServiceTag serviceTag = RegistrationDocument.getServiceTag(element2);
            registrationData.addServiceTag(serviceTag);
        }
    }

    private static void buildEnvironmentMap(Element element, RegistrationData registrationData) {
        registrationData.setEnvironment(ST_NODE_HOSTNAME, RegistrationDocument.getTextValue(element, ST_NODE_HOSTNAME));
        registrationData.setEnvironment(ST_NODE_HOST_ID, RegistrationDocument.getTextValue(element, ST_NODE_HOST_ID));
        registrationData.setEnvironment(ST_NODE_OS_NAME, RegistrationDocument.getTextValue(element, ST_NODE_OS_NAME));
        registrationData.setEnvironment(ST_NODE_OS_VERSION, RegistrationDocument.getTextValue(element, ST_NODE_OS_VERSION));
        registrationData.setEnvironment(ST_NODE_OS_ARCH, RegistrationDocument.getTextValue(element, ST_NODE_OS_ARCH));
        registrationData.setEnvironment(ST_NODE_SYSTEM_MODEL, RegistrationDocument.getTextValue(element, ST_NODE_SYSTEM_MODEL));
        registrationData.setEnvironment(ST_NODE_SYSTEM_MANUFACTURER, RegistrationDocument.getTextValue(element, ST_NODE_SYSTEM_MANUFACTURER));
        registrationData.setEnvironment(ST_NODE_CPU_MANUFACTURER, RegistrationDocument.getTextValue(element, ST_NODE_CPU_MANUFACTURER));
        registrationData.setEnvironment(ST_NODE_SERIAL_NUMBER, RegistrationDocument.getTextValue(element, ST_NODE_SERIAL_NUMBER));
    }

    private static void addEnvironmentNodes(Document document, Map<String, String> map) {
        Element element = RegistrationDocument.getRegistrationDataRoot(document);
        Element element2 = document.createElement(ST_NODE_ENVIRONMENT);
        element.appendChild(element2);
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            RegistrationDocument.addChildElement(document, element2, entry.getKey(), entry.getValue());
        }
    }

    private static Element getRegistrationDataRoot(Document document) {
        Element element = document.getDocumentElement();
        if (!element.getNodeName().equals(ST_NODE_REGISTRATION_DATA)) {
            throw new IllegalArgumentException("Not a registration_data node \"" + element.getNodeName() + "\"");
        }
        return element;
    }

    private static Element getSingletonElementFromRoot(Element element, String string) {
        int n;
        NodeList nodeList = element.getElementsByTagName(string);
        int n2 = n = nodeList == null ? 0 : nodeList.getLength();
        if (n != 1) {
            throw new IllegalArgumentException("Invalid number of " + string + " nodes = " + n);
        }
        Element element2 = (Element)nodeList.item(0);
        if (!element2.getNodeName().equals(string)) {
            throw new IllegalArgumentException("Not a  " + string + " node \"" + element2.getNodeName() + "\"");
        }
        return element2;
    }

    private static ServiceTag getServiceTag(Element element) {
        return new ServiceTag(RegistrationDocument.getTextValue(element, ST_NODE_INSTANCE_URN), RegistrationDocument.getTextValue(element, ST_NODE_PRODUCT_NAME), RegistrationDocument.getTextValue(element, ST_NODE_PRODUCT_VERSION), RegistrationDocument.getTextValue(element, ST_NODE_PRODUCT_URN), RegistrationDocument.getTextValue(element, ST_NODE_PRODUCT_PARENT), RegistrationDocument.getTextValue(element, ST_NODE_PRODUCT_PARENT_URN), RegistrationDocument.getTextValue(element, ST_NODE_PRODUCT_DEFINED_INST_ID), RegistrationDocument.getTextValue(element, ST_NODE_PRODUCT_VENDOR), RegistrationDocument.getTextValue(element, ST_NODE_PLATFORM_ARCH), RegistrationDocument.getTextValue(element, ST_NODE_CONTAINER), RegistrationDocument.getTextValue(element, ST_NODE_SOURCE), Util.getIntValue(RegistrationDocument.getTextValue(element, ST_NODE_INSTALLER_UID)), Util.parseTimestamp(RegistrationDocument.getTextValue(element, ST_NODE_TIMESTAMP)));
    }

    private static String getTextValue(Element element, String string) {
        Element element2;
        Node node;
        String string2 = "";
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0 && (node = (element2 = (Element)nodeList.item(0)).getFirstChild()) != null) {
            string2 = node.getNodeValue();
        }
        return string2;
    }
}

