/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ClassBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ConditionsPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MethodBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private static final String HELP_ID = "debug.add.breakpoint.java.method";
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private MethodBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JEditorPane tfClassName;
    private JPanel cPanel;
    private JCheckBox cbAllMethods;
    private JComboBox cbBreakpointType;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JPanel panelClassName;
    private JLabel stopOnLabel;
    private JTextField tfMethodName;

    private static MethodBreakpoint createBreakpoint() {
        String string;
        String string2;
        try {
            string2 = EditorContextBridge.getContext().getCurrentClassName();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            string2 = "";
        }
        try {
            string = EditorContextBridge.getContext().getCurrentMethodName();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            string = "";
        }
        MethodBreakpoint methodBreakpoint = MethodBreakpoint.create((String)string2, (String)string);
        try {
            methodBreakpoint.setMethodSignature(EditorContextBridge.getCurrentMethodSignature());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        methodBreakpoint.setPrintText(NbBundle.getBundle(MethodBreakpointPanel.class).getString("CTL_Method_Breakpoint_Print_Text"));
        return methodBreakpoint;
    }

    public MethodBreakpointPanel() {
        this(MethodBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public MethodBreakpointPanel(MethodBreakpoint methodBreakpoint) {
        this.breakpoint = methodBreakpoint;
        this.initComponents();
        String string = "";
        String[] stringArray = methodBreakpoint.getClassFilters();
        string = ClassBreakpointPanel.concatClassFilters(stringArray);
        this.tfClassName = new JEditorPane("text/x-java", string);
        this.tfClassName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSN_Method_Breakpoint_ClassName"));
        this.tfClassName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_Method_Breakpoint_ClassName"));
        this.jLabel3.setLabelFor(this.tfClassName);
        HelpCtx.setHelpIDString((JComponent)this.tfClassName, (String)HELP_ID);
        this.panelClassName.add("Center", WatchPanel.createScrollableLineEditor(this.tfClassName));
        if ("".equals(methodBreakpoint.getMethodName())) {
            this.tfMethodName.setText(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"Method_Breakpoint_ALL_METHODS"));
            this.cbAllMethods.setSelected(true);
            this.tfMethodName.setEnabled(false);
        } else {
            this.tfMethodName.setText(methodBreakpoint.getMethodName() + " " + MethodBreakpointPanel.createParamTypesFromSignature(methodBreakpoint.getMethodSignature()));
        }
        this.cbBreakpointType.addItem(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"LBL_Method_Breakpoint_Type_Entry"));
        this.cbBreakpointType.addItem(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"LBL_Method_Breakpoint_Type_Exit"));
        this.cbBreakpointType.addItem(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"LBL_Method_Breakpoint_Type_Entry_or_Exit"));
        switch (methodBreakpoint.getBreakpointType()) {
            case 1: {
                this.cbBreakpointType.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.cbBreakpointType.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.cbBreakpointType.setSelectedIndex(2);
            }
        }
        this.conditionsPanel = new ConditionsPanel(HELP_ID);
        this.conditionsPanel.showClassFilter(false);
        this.conditionsPanel.setCondition(methodBreakpoint.getCondition());
        this.conditionsPanel.setHitCountFilteringStyle(methodBreakpoint.getHitCountFilteringStyle());
        this.conditionsPanel.setHitCount(methodBreakpoint.getHitCountFilter());
        this.cPanel.add((Component)this.conditionsPanel, "Center");
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)methodBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.putClientProperty("HelpID_AddBreakpointPanel", HELP_ID);
    }

    private static String createParamTypesFromSignature(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        int n = string.lastIndexOf(")");
        if (n < 0) {
            ErrorManager.getDefault().notify((Throwable)new IllegalArgumentException("Bad signature: " + string));
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        int[] nArray = new int[]{1};
        while (nArray[0] < string.length() && string.charAt(nArray[0]) != ')') {
            if (nArray[0] > 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(MethodBreakpointPanel.getType(string, nArray));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static String createSignatureFromParamTypes(String string) {
        StringBuilder stringBuilder = new StringBuilder("(");
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(44, n);
            if (n2 < 0) {
                n2 = string.length();
            }
            String string2 = string.substring(n, n2);
            stringBuilder.append(MethodBreakpointPanel.getSignature(string2.trim()));
            n = n2 + 1;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static String getSignature(String string) {
        if (string.equals("boolean")) {
            return "Z";
        }
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("double")) {
            return "D";
        }
        if (string.endsWith("[]")) {
            return "[" + MethodBreakpointPanel.getSignature(string.substring(0, string.length() - 2));
        }
        return "L" + string.replace('.', '/') + ";";
    }

    private static String getType(String string, int[] nArray) throws IllegalArgumentException {
        char c = string.charAt(nArray[0]);
        if (c == 'Z') {
            nArray[0] = nArray[0] + 1;
            return "boolean";
        }
        if (c == 'B') {
            nArray[0] = nArray[0] + 1;
            return "byte";
        }
        if (c == 'C') {
            nArray[0] = nArray[0] + 1;
            return "char";
        }
        if (c == 'S') {
            nArray[0] = nArray[0] + 1;
            return "short";
        }
        if (c == 'I') {
            nArray[0] = nArray[0] + 1;
            return "int";
        }
        if (c == 'J') {
            nArray[0] = nArray[0] + 1;
            return "long";
        }
        if (c == 'F') {
            nArray[0] = nArray[0] + 1;
            return "float";
        }
        if (c == 'D') {
            nArray[0] = nArray[0] + 1;
            return "double";
        }
        if (c == 'L') {
            nArray[0] = nArray[0] + 1;
            int n = string.indexOf(";", nArray[0]);
            if (n < 0) {
                throw new IllegalArgumentException("Bad signature: '" + string + "', 'L' not followed by ';' at position " + nArray[0]);
            }
            String string2 = string.substring(nArray[0], n);
            string2 = string2.replace('/', '.');
            nArray[0] = n + 1;
            return string2;
        }
        if (c == '[') {
            nArray[0] = nArray[0] + 1;
            String string3 = MethodBreakpointPanel.getType(string, nArray);
            return string3 + "[]";
        }
        throw new IllegalArgumentException("Bad signature: '" + string + "', unrecognized element '" + c + "' at position " + nArray[0]);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointMethodJPDA");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.cbAllMethods = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.tfMethodName = new JTextField();
        this.panelClassName = new JPanel();
        this.stopOnLabel = new JLabel();
        this.cbBreakpointType = new JComboBox();
        this.cPanel = new JPanel();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pSettings.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"L_Method_Breakpoint_BorderTitle")));
        this.pSettings.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MethodBreakpointPanel.class, (String)"L_Method_Breakpoint_Class_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_L_Method_Breakpoint_Class_Name"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAllMethods, (String)NbBundle.getMessage(MethodBreakpointPanel.class, (String)"CB_Method_Breakpoint_All_Methods"));
        this.cbAllMethods.setToolTipText(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"TTT_CB_Method_Breakpoint_All_Methods"));
        this.cbAllMethods.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAllMethods.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MethodBreakpointPanel.this.cbAllMethodsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbAllMethods, gridBagConstraints);
        this.cbAllMethods.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_CB_Method_Breakpoint_All_Methods"));
        this.jLabel1.setLabelFor(this.tfMethodName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MethodBreakpointPanel.class, (String)"L_Method_Breakpoint_Method_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_L_Method_Breakpoint_Method_Name"));
        this.tfMethodName.setToolTipText(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"TTT_TF_Method_Breakpoint_Method_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfMethodName, gridBagConstraints);
        this.tfMethodName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_TF_Method_Breakpoint_Method_Name"));
        this.panelClassName.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.panelClassName, gridBagConstraints);
        this.stopOnLabel.setLabelFor(this.cbBreakpointType);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.stopOnLabel, (String)resourceBundle.getString("L_Method_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.stopOnLabel, gridBagConstraints);
        this.stopOnLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSD_StopOn_LBL"));
        this.cbBreakpointType.setToolTipText(resourceBundle.getString("TTT_CB_Class_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.cbBreakpointType, gridBagConstraints);
        this.cbBreakpointType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSN_CB_Method_Breakpoint_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.cPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cPanel, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"ACSN_MethodBreakpointPanel"));
    }

    private void cbAllMethodsActionPerformed(ActionEvent actionEvent) {
        if (this.cbAllMethods.isSelected()) {
            this.tfMethodName.setText(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"Method_Breakpoint_ALL_METHODS"));
            this.tfMethodName.setEnabled(false);
        } else {
            this.tfMethodName.setText("");
            this.tfMethodName.setEnabled(true);
        }
    }

    public boolean ok() {
        String string = this.valiadateMsg();
        if (string == null) {
            string = this.conditionsPanel.valiadateMsg();
        }
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            return false;
        }
        this.actionsPanel.ok();
        String string2 = this.tfClassName.getText().trim();
        this.breakpoint.setClassFilters(new String[]{string2});
        if (!this.cbAllMethods.isSelected()) {
            String string3;
            String string4;
            String string5 = this.tfMethodName.getText().trim();
            int n = string5.indexOf("(");
            if (n < 0) {
                string4 = string5;
                string3 = null;
            } else {
                string4 = string5.substring(0, n).trim();
                int n2 = string5.indexOf(")", n);
                if (n2 < 0) {
                    n2 = string5.length();
                }
                string3 = string5.substring(n + 1, n2);
                string3 = MethodBreakpointPanel.createSignatureFromParamTypes(string3);
            }
            this.breakpoint.setMethodName(string4);
            this.breakpoint.setMethodSignature(string3);
        } else {
            this.breakpoint.setMethodName("");
        }
        switch (this.cbBreakpointType.getSelectedIndex()) {
            case 0: {
                this.breakpoint.setBreakpointType(1);
                break;
            }
            case 1: {
                this.breakpoint.setBreakpointType(2);
                break;
            }
            case 2: {
                this.breakpoint.setBreakpointType(3);
            }
        }
        this.breakpoint.setCondition(this.conditionsPanel.getCondition());
        this.breakpoint.setHitCountFilter(this.conditionsPanel.getHitCount(), this.conditionsPanel.getHitCountFilteringStyle());
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    private String valiadateMsg() {
        if (this.tfClassName.getText().trim().length() == 0 || this.tfMethodName.getText().trim().length() == 0 && !this.cbAllMethods.isSelected()) {
            return NbBundle.getMessage(MethodBreakpointPanel.class, (String)"MSG_No_Class_or_Method_Name_Spec");
        }
        return null;
    }
}

