/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.debugging.ThreadsListener;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugTreeView
extends BeanTreeView
implements TreeExpansionListener {
    private int thickness;
    private Color highlightColor = new Color(233, 239, 248);
    private Color currentThreadColor = new Color(233, 255, 230);
    private Color whiteColor = UIManager.getDefaults().getColor("Tree.background");
    private JPDAThread focusedThread;

    DebugTreeView() {
        this.setBackground(this.whiteColor);
        this.tree.setOpaque(false);
        ((JComponent)this.tree.getParent()).setOpaque(false);
        this.tree.addTreeExpansionListener(this);
    }

    public JTree getTree() {
        return this.tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreePath> getVisiblePaths() {
        JTree jTree = this.tree;
        synchronized (jTree) {
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            int n = this.tree.getRowCount();
            for (int i = 0; i < n; ++i) {
                TreePath treePath = this.tree.getPathForRow(i);
                if (!this.tree.isVisible(treePath)) continue;
                arrayList.add(treePath);
            }
            return arrayList;
        }
    }

    public Object getJPDAObject(TreePath treePath) {
        Node node = Visualizer.findNode((Object)treePath.getLastPathComponent());
        JPDAThread jPDAThread = (JPDAThread)node.getLookup().lookup(JPDAThread.class);
        if (jPDAThread != null) {
            return jPDAThread;
        }
        JPDAThreadGroup jPDAThreadGroup = (JPDAThreadGroup)node.getLookup().lookup(JPDAThreadGroup.class);
        return jPDAThreadGroup;
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.tree.addTreeExpansionListener(treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.tree.removeTreeExpansionListener(treeExpansionListener);
    }

    void setExpansionModel(TreeExpansionModel treeExpansionModel) {
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintStripes(graphics, (JComponent)((Object)this));
    }

    void paintStripes(Graphics graphics, JComponent jComponent) {
        int n;
        JPDAThread jPDAThread;
        int n2;
        int n3;
        int n4;
        int n5;
        List<TreePath> list = this.getVisiblePaths();
        int n6 = list.size();
        int n7 = n6 * this.thickness;
        Rectangle rectangle = list.size() > 0 ? this.tree.getRowBounds(this.tree.getRowForPath(list.get(0))) : null;
        this.thickness = rectangle != null ? (int)Math.round(rectangle.getHeight()) : 18;
        int n8 = this.getWidth();
        int n9 = this.getHeight();
        if (n8 <= 0 || n9 <= 0) {
            return;
        }
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle2 == null) {
            n5 = 0;
            n4 = 0;
            n3 = n8;
            n2 = n9;
        } else {
            n4 = rectangle2.x;
            n5 = rectangle2.y;
            n3 = rectangle2.width;
            n2 = rectangle2.height;
        }
        if (n3 > n8) {
            n3 = n8;
        }
        if (n2 > n9) {
            n2 = n9;
        }
        Color color = graphics.getColor();
        JPDADebugger jPDADebugger = ThreadsListener.getDefault().getDebugger();
        JPDAThread jPDAThread2 = jPDAThread = jPDADebugger != null ? jPDADebugger.getCurrentThread() : null;
        if (jPDAThread != null && !jPDAThread.isSuspended()) {
            jPDAThread = null;
        }
        boolean bl = false;
        boolean bl2 = false;
        Iterator<TreePath> iterator = list.iterator();
        int n10 = n5 / this.thickness;
        for (n = 0; n <= n10 && iterator.hasNext(); ++n) {
            Node node = Visualizer.findNode((Object)iterator.next().getLastPathComponent());
            JPDAThread jPDAThread3 = (JPDAThread)node.getLookup().lookup(JPDAThread.class);
            boolean bl3 = bl = this.focusedThread != null && jPDAThread3 == this.focusedThread;
            if (jPDAThread3 == null) continue;
            bl2 = jPDAThread == jPDAThread3;
        }
        int n11 = Math.min(n5 + n2 - 1, n7);
        for (n = n5 / this.thickness * this.thickness; n < n11; n += this.thickness) {
            int n12 = Math.max(n, n5);
            int n13 = Math.min(n5 + n2, n12 + this.thickness);
            if (bl || bl2) {
                graphics.setColor(bl ? this.highlightColor : this.currentThreadColor);
                graphics.fillRect(n4, n12, n3, n13 - n12);
            }
            if (iterator.hasNext()) {
                Node node = Visualizer.findNode((Object)iterator.next().getLastPathComponent());
                JPDAThread jPDAThread4 = (JPDAThread)node.getLookup().lookup(JPDAThread.class);
                boolean bl4 = bl = this.focusedThread != null && jPDAThread4 == this.focusedThread;
                if (jPDAThread4 == null) continue;
                bl2 = jPDAThread == jPDAThread4;
                continue;
            }
            bl = false;
            bl2 = false;
        }
        graphics.setColor(color);
    }

    boolean threadFocuseGained(JPDAThread jPDAThread) {
        if (jPDAThread != null && this.focusedThread != jPDAThread) {
            this.focusedThread = jPDAThread;
            this.repaint();
            return true;
        }
        return false;
    }

    boolean threadFocuseLost(JPDAThread jPDAThread) {
        if (jPDAThread != null && this.focusedThread == jPDAThread) {
            this.focusedThread = null;
            this.repaint();
            return true;
        }
        return false;
    }

    private void collectVisiblePaths(List<TreePath> list, TreePath treePath) {
        list.add(treePath);
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(treePath);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                treePath = enumeration.nextElement();
                this.collectVisiblePaths(list, treePath);
            }
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.repaint();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.repaint();
    }
}

