/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.models.CachedChildrenTreeModel;
import org.netbeans.modules.debugger.jpda.ui.models.SourcesModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class DebuggingTreeModel
extends CachedChildrenTreeModel {
    public static final String SORT_ALPHABET = "sort.alphabet";
    public static final String SORT_SUSPEND = "sort.suspend";
    public static final String SHOW_SYSTEM_THREADS = "show.systemThreads";
    public static final String SHOW_THREAD_GROUPS = "show.threadGroups";
    public static final String SHOW_SUSPENDED_THREADS_ONLY = "show.suspendedThreadsOnly";
    private static final Set<String> SYSTEM_THREAD_NAMES = new HashSet<String>(Arrays.asList("Reference Handler", "Signal Dispatcher", "Finalizer", "Java2D Disposer", "TimerQueue", "Attach Listener"));
    private static final Set<String> SYSTEM_MAIN_THREAD_NAMES = new HashSet<String>(Arrays.asList("DestroyJavaVM", "AWT-XAWT", "AWT-Shutdown"));
    private JPDADebugger debugger;
    private Listener listener;
    private PreferenceChangeListener prefListener;
    private PropertyChangeListener debuggerListener = new DebuggerFinishListener();
    private Collection<ModelListener> listeners = new HashSet<ModelListener>();
    private Map<JPDAThread, ThreadStateListener> threadStateListeners = new WeakHashMap<JPDAThread, ThreadStateListener>();
    private Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");

    public DebuggingTreeModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", this.debuggerListener);
        if (this.debugger.getState() == 4) {
            this.debugger.removePropertyChangeListener("state", this.debuggerListener);
        } else {
            this.prefListener = new DebuggingPreferenceChangeListener();
            this.preferences.addPreferenceChangeListener(this.prefListener);
        }
    }

    protected Object[] computeChildren(Object object) throws UnknownTypeException {
        if (object == "Root") {
            boolean bl = this.preferences.getBoolean(SHOW_THREAD_GROUPS, false);
            if (bl) {
                return this.getTopLevelThreadsAndGroups();
            }
            return this.debugger.getThreadsCollector().getAllThreads().toArray();
        }
        if (object instanceof JPDAThread) {
            JPDAThread jPDAThread = (JPDAThread)object;
            this.watchState(jPDAThread);
            try {
                return jPDAThread.getCallStack();
            }
            catch (AbsentInformationException absentInformationException) {
                return new Object[0];
            }
        }
        if (object instanceof JPDAThreadGroup) {
            JPDAThread[] jPDAThreadArray = ((JPDAThreadGroup)object).getThreads();
            JPDAThreadGroup[] jPDAThreadGroupArray = ((JPDAThreadGroup)object).getThreadGroups();
            Object[] objectArray = new Object[jPDAThreadArray.length + jPDAThreadGroupArray.length];
            System.arraycopy(jPDAThreadArray, 0, objectArray, 0, jPDAThreadArray.length);
            System.arraycopy(jPDAThreadGroupArray, 0, objectArray, jPDAThreadArray.length, jPDAThreadGroupArray.length);
            return objectArray;
        }
        if (object instanceof CallStackFrame) {
            return new Object[0];
        }
        throw new UnknownTypeException((Object)object.toString());
    }

    protected Object[] reorder(Object[] objectArray) {
        boolean bl;
        boolean bl2 = this.preferences.getBoolean(SHOW_SYSTEM_THREADS, false);
        boolean bl3 = this.preferences.getBoolean(SHOW_SUSPENDED_THREADS_ONLY, false);
        if (!bl2 || bl3) {
            objectArray = this.filterSystemThreads(objectArray, !bl2, bl3);
        }
        if (!(bl = this.preferences.getBoolean(SORT_ALPHABET, true))) {
            boolean bl4 = this.preferences.getBoolean(SORT_SUSPEND, false);
            if (bl4) {
                Object[] objectArray2 = new Object[objectArray.length];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray = objectArray2;
                Arrays.sort(objectArray, new ThreadSuspendComparator());
            }
        } else {
            Object[] objectArray3 = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
            objectArray = objectArray3;
            Arrays.sort(objectArray, new ThreadAlphabetComparator());
        }
        return objectArray;
    }

    private Object[] filterSystemThreads(Object[] objectArray, boolean bl, boolean bl2) {
        ArrayList<Object> arrayList = null;
        for (Object object : objectArray) {
            if (!(object instanceof JPDAThread)) continue;
            JPDAThread jPDAThread = (JPDAThread)object;
            if ((!bl || !this.isSystem(jPDAThread)) && (!bl2 || jPDAThread.isSuspended() || jPDAThread == this.debugger.getCurrentThread())) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
            }
            arrayList.remove(object);
        }
        return arrayList != null ? arrayList.toArray() : objectArray;
    }

    private Object[] getTopLevelThreadsAndGroups() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashSet<JPDAThreadGroup> hashSet = new HashSet<JPDAThreadGroup>();
        for (JPDAThread jPDAThread : this.debugger.getThreadsCollector().getAllThreads()) {
            JPDAThreadGroup jPDAThreadGroup = jPDAThread.getParentThreadGroup();
            if (jPDAThreadGroup == null) {
                linkedList.add(jPDAThread);
                continue;
            }
            while (jPDAThreadGroup.getParentThreadGroup() != null) {
                jPDAThreadGroup = jPDAThreadGroup.getParentThreadGroup();
            }
            hashSet.add(jPDAThreadGroup);
        }
        linkedList.addAll(hashSet);
        return linkedList.toArray();
    }

    private boolean isSystem(JPDAThread jPDAThread) {
        if (SYSTEM_THREAD_NAMES.contains(jPDAThread.getName())) {
            JPDAThreadGroup jPDAThreadGroup = jPDAThread.getParentThreadGroup();
            return jPDAThreadGroup != null && "system".equals(jPDAThreadGroup.getName());
        }
        if (SYSTEM_MAIN_THREAD_NAMES.contains(jPDAThread.getName())) {
            JPDAThreadGroup jPDAThreadGroup = jPDAThread.getParentThreadGroup();
            return jPDAThreadGroup != null && "main".equals(jPDAThreadGroup.getName());
        }
        return false;
    }

    protected boolean cacheChildrenOf(Object object) {
        if (object instanceof JPDAThread) {
            return false;
        }
        return super.cacheChildrenOf(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object instanceof CallStackFrame) {
            return 0;
        }
        if (object instanceof JPDAThread && !((JPDAThread)object).isSuspended()) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object instanceof CallStackFrame) {
            return true;
        }
        return object instanceof JPDAThread && !((JPDAThread)object).isSuspended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(modelListener);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(modelListener);
            if (this.listeners.size() == 0 && this.listener != null) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeChanged(Object object) {
        ModelListener[] modelListenerArray;
        try {
            this.recomputeChildren();
        }
        catch (UnknownTypeException unknownTypeException) {
            Exceptions.printStackTrace((Throwable)unknownTypeException);
            return;
        }
        ModelEvent.NodeChanged nodeChanged = this.listeners;
        synchronized (nodeChanged) {
            modelListenerArray = this.listeners.toArray(new ModelListener[0]);
        }
        nodeChanged = new ModelEvent.NodeChanged((Object)this, object);
        for (int i = 0; i < modelListenerArray.length; ++i) {
            modelListenerArray[i].modelChanged((ModelEvent)nodeChanged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireThreadStateChanged(Object object) {
        ArrayList<ModelListener> arrayList;
        if (this.preferences.getBoolean(SHOW_SUSPENDED_THREADS_ONLY, false)) {
            this.fireNodeChanged("Root");
        }
        ModelEvent.NodeChanged nodeChanged = this.listeners;
        synchronized (nodeChanged) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        nodeChanged = new ModelEvent.NodeChanged((Object)this, object, 8);
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged((ModelEvent)nodeChanged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchState(JPDAThread jPDAThread) {
        Map<JPDAThread, ThreadStateListener> map = this.threadStateListeners;
        synchronized (map) {
            if (!this.threadStateListeners.containsKey(jPDAThread)) {
                this.threadStateListeners.put(jPDAThread, new ThreadStateListener(jPDAThread));
            }
        }
    }

    private final class DebuggerFinishListener
    implements PropertyChangeListener {
        private DebuggerFinishListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("state".equals(propertyChangeEvent.getPropertyName()) && DebuggingTreeModel.this.debugger.getState() == 4) {
                if (DebuggingTreeModel.this.prefListener != null) {
                    try {
                        DebuggingTreeModel.this.preferences.removePreferenceChangeListener(DebuggingTreeModel.this.prefListener);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                DebuggingTreeModel.this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
            }
        }
    }

    private final class DebuggingPreferenceChangeListener
    implements PreferenceChangeListener {
        private DebuggingPreferenceChangeListener() {
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            if (DebuggingTreeModel.SORT_ALPHABET.equals(string) || DebuggingTreeModel.SORT_SUSPEND.equals(string) || DebuggingTreeModel.SHOW_SYSTEM_THREADS.equals(string) || DebuggingTreeModel.SHOW_THREAD_GROUPS.equals(string) || DebuggingTreeModel.SHOW_SUSPENDED_THREADS_ONLY.equals(string) || "show.packageNames".equals(string)) {
                try {
                    DebuggingTreeModel.this.fireNodeChanged("Root");
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Exceptions.printStackTrace((Throwable)throwable);
                }
            }
        }
    }

    private static final class ThreadSuspendComparator
    implements Comparator {
        private ThreadSuspendComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof JPDAThreadGroup) {
                if (object2 instanceof JPDAThreadGroup) {
                    return 0;
                }
                return 1;
            }
            if (object2 instanceof JPDAThreadGroup) {
                return -1;
            }
            if (!(object instanceof JPDAThread) && !(object2 instanceof JPDAThread)) {
                return 0;
            }
            boolean bl = ((JPDAThread)object).isSuspended();
            boolean bl2 = ((JPDAThread)object2).isSuspended();
            if (bl && !bl2) {
                return -1;
            }
            if (!bl && bl2) {
                return 1;
            }
            return 0;
        }
    }

    private static final class ThreadAlphabetComparator
    implements Comparator {
        private ThreadAlphabetComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof JPDAThreadGroup) {
                if (object2 instanceof JPDAThreadGroup) {
                    String string = ((JPDAThreadGroup)object).getName();
                    String string2 = ((JPDAThreadGroup)object2).getName();
                    return Collator.getInstance().compare(string, string2);
                }
                return 1;
            }
            if (object2 instanceof JPDAThreadGroup) {
                return -1;
            }
            if (!(object instanceof JPDAThread) && !(object2 instanceof JPDAThread)) {
                return 0;
            }
            String string = ((JPDAThread)object).getName();
            String string3 = ((JPDAThread)object2).getName();
            return Collator.getInstance().compare(string, string3);
        }
    }

    public static class DebuggingSuspendColumn
    extends SourcesModel.AbstractColumn {
        public String getID() {
            return "suspend";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(DebuggingTreeModel.class).getString("CTL_Debugging_Column_Suspend_Name");
        }

        public Character getDisplayedMnemonic() {
            return new Character(NbBundle.getBundle(DebuggingTreeModel.class).getString("CTL_Debugging_Column_Suspend_Name_Mnc").charAt(0));
        }

        public Class getType() {
            return Boolean.TYPE;
        }

        public String getShortDescription() {
            return NbBundle.getBundle(DebuggingTreeModel.class).getString("CTL_Debugging_Column_Suspend_Desc");
        }

        public boolean initiallyVisible() {
            return true;
        }
    }

    public static class DefaultDebuggingColumn
    extends SourcesModel.AbstractColumn {
        public String getID() {
            return "DefaultDebuggingColumn";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(DebuggingTreeModel.class).getString("CTL_Debugging_Column_Name_Name");
        }

        public Character getDisplayedMnemonic() {
            return new Character(NbBundle.getBundle(DebuggingTreeModel.class).getString("CTL_Debugging_Column_Name_Name_Mnc").charAt(0));
        }

        public String getShortDescription() {
            return NbBundle.getBundle(DebuggingTreeModel.class).getString("CTL_Debugging_Column_Name_Desc");
        }

        public Class getType() {
            return null;
        }
    }

    private class ThreadStateListener
    implements PropertyChangeListener {
        private Reference<JPDAThread> tr;
        private RequestProcessor.Task task;

        public ThreadStateListener(JPDAThread jPDAThread) {
            this.tr = new WeakReference<JPDAThread>(jPDAThread);
            ((Customizer)jPDAThread).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jPDAThread));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JPDAThread jPDAThread;
            if (propertyChangeEvent.getPropertyName().equals("suspended")) {
                // empty if block
            }
            if ((jPDAThread = this.tr.get()) != null) {
                ThreadStateListener threadStateListener = this;
                synchronized (threadStateListener) {
                    if (this.task == null) {
                        this.task = RequestProcessor.getDefault().create((Runnable)new Refresher());
                    }
                    this.task.schedule(200);
                }
            }
        }

        private class Refresher
        implements Runnable {
            private Refresher() {
            }

            public void run() {
                JPDAThread jPDAThread = (JPDAThread)ThreadStateListener.this.tr.get();
                if (jPDAThread != null) {
                    DebuggingTreeModel.this.fireThreadStateChanged(jPDAThread);
                }
            }
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        private WeakReference<DebuggingTreeModel> model;
        private RequestProcessor.Task task;
        private Set<Object> nodesToRefresh;
        private Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");

        public Listener(DebuggingTreeModel debuggingTreeModel, JPDADebugger jPDADebugger) {
            this.debugger = jPDADebugger;
            this.model = new WeakReference<DebuggingTreeModel>(debuggingTreeModel);
            jPDADebugger.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private DebuggingTreeModel getModel() {
            DebuggingTreeModel debuggingTreeModel = (DebuggingTreeModel)this.model.get();
            if (debuggingTreeModel == null) {
                this.destroy();
            }
            return debuggingTreeModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            Listener listener = this;
            synchronized (listener) {
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
            }
        }

        private RequestProcessor.Task createTask() {
            RequestProcessor.Task task = new RequestProcessor("Debugging Threads Refresh", 1).create((Runnable)new RefreshTree());
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JPDAThreadGroup jPDAThreadGroup;
            Object object;
            if (propertyChangeEvent.getPropertyName() == "threadStarted") {
                object = (JPDAThread)propertyChangeEvent.getNewValue();
                jPDAThreadGroup = object.getParentThreadGroup();
            } else if (propertyChangeEvent.getPropertyName() == "threadDied") {
                object = (JPDAThread)propertyChangeEvent.getOldValue();
                for (jPDAThreadGroup = object.getParentThreadGroup(); jPDAThreadGroup != null && jPDAThreadGroup.getThreads().length == 0 && jPDAThreadGroup.getThreadGroups().length == 0; jPDAThreadGroup = jPDAThreadGroup.getParentThreadGroup()) {
                }
            } else if (propertyChangeEvent.getPropertyName() == "threadGroupAdded") {
                jPDAThreadGroup = (JPDAThreadGroup)propertyChangeEvent.getNewValue();
                jPDAThreadGroup = jPDAThreadGroup.getParentThreadGroup();
            } else {
                return;
            }
            object = new ArrayList();
            if (jPDAThreadGroup == null || !this.preferences.getBoolean(DebuggingTreeModel.SHOW_THREAD_GROUPS, false)) {
                object.add("Root");
            } else if (jPDAThreadGroup != null) {
                do {
                    object.add(jPDAThreadGroup);
                } while ((jPDAThreadGroup = jPDAThreadGroup.getParentThreadGroup()) != null);
            }
            Listener listener = this;
            synchronized (listener) {
                if (this.task == null) {
                    this.task = this.createTask();
                }
                if (this.nodesToRefresh == null) {
                    this.nodesToRefresh = new LinkedHashSet<Object>();
                }
                this.nodesToRefresh.addAll((Collection<Object>)object);
                this.task.schedule(100);
            }
        }

        private class RefreshTree
        implements Runnable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList arrayList;
                DebuggingTreeModel debuggingTreeModel = Listener.this.getModel();
                if (debuggingTreeModel == null) {
                    return;
                }
                Listener listener = Listener.this;
                synchronized (listener) {
                    arrayList = new ArrayList(Listener.this.nodesToRefresh);
                    Listener.this.nodesToRefresh.clear();
                }
                for (Object e : arrayList) {
                    debuggingTreeModel.fireNodeChanged(e);
                }
            }
        }
    }
}

