/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MonitorModel
implements TreeModelFilter,
NodeModelFilter,
NodeActionsProviderFilter,
TableModel,
Constants {
    public static final String CONTENDED_MONITOR = "org/netbeans/modules/debugger/resources/allInOneView/ContendedMonitor";
    public static final String OWNED_MONITORS = "org/netbeans/modules/debugger/resources/allInOneView/OwnedMonitors";
    public static final String MONITOR = "org/netbeans/modules/debugger/resources/allInOneView/Monitor";
    private RequestProcessor evaluationRP = new RequestProcessor();
    private final Collection modelListeners = new HashSet();
    private Map shortDescriptionMap = new HashMap();

    public Object getRoot(TreeModel treeModel) {
        return treeModel.getRoot();
    }

    public Object[] getChildren(TreeModel treeModel, Object object, int n, int n2) throws UnknownTypeException {
        if (object instanceof ThreadWithBordel) {
            try {
                JPDAThread jPDAThread = ((ThreadWithBordel)object).originalThread;
                ObjectVariable objectVariable = jPDAThread.getContendedMonitor();
                ObjectVariable[] objectVariableArray = jPDAThread.getOwnedMonitors();
                ContendedMonitor contendedMonitor = null;
                OwnedMonitors ownedMonitors = null;
                if (objectVariable != null && n == 0 && n2 > 0) {
                    contendedMonitor = new ContendedMonitor(objectVariable);
                }
                if (objectVariableArray.length > 0 && (objectVariable != null && n < 2 && n2 > 1 || objectVariable == null && n == 0 && n2 > 0)) {
                    ownedMonitors = new OwnedMonitors(objectVariableArray);
                }
                int n3 = 0;
                if (contendedMonitor != null) {
                    ++n3;
                }
                if (ownedMonitors != null) {
                    ++n3;
                }
                Object[] objectArray = new Object[n3];
                n3 = 0;
                if (contendedMonitor != null) {
                    objectArray[n3++] = contendedMonitor;
                }
                if (ownedMonitors != null) {
                    objectArray[n3++] = ownedMonitors;
                }
                return objectArray;
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
            return new Object[0];
        }
        if (object instanceof JPDAThreadGroup) {
            JPDAThreadGroup jPDAThreadGroup = (JPDAThreadGroup)object;
            Object[] objectArray = treeModel.getChildren(object, n, n2);
            int n4 = objectArray.length;
            for (int i = 0; i < n4; ++i) {
                if (!(objectArray[i] instanceof JPDAThread)) continue;
                try {
                    JPDAThread jPDAThread = (JPDAThread)objectArray[i];
                    if (jPDAThread.getContendedMonitor() == null && jPDAThread.getOwnedMonitors().length == 0) continue;
                    ThreadWithBordel threadWithBordel = new ThreadWithBordel();
                    threadWithBordel.originalThread = jPDAThread;
                    objectArray[i] = threadWithBordel;
                    continue;
                }
                catch (ObjectCollectedException objectCollectedException) {
                    continue;
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
            return objectArray;
        }
        if (object instanceof OwnedMonitors) {
            OwnedMonitors ownedMonitors = (OwnedMonitors)object;
            Object[] objectArray = new Object[n2 - n];
            System.arraycopy(ownedMonitors.variables, n, objectArray, 0, n2 - n);
            return objectArray;
        }
        return treeModel.getChildren(object, n, n2);
    }

    public int getChildrenCount(TreeModel treeModel, Object object) throws UnknownTypeException {
        if (object instanceof ThreadWithBordel) {
            return Integer.MAX_VALUE;
        }
        if (object instanceof ThreadWithBordel) {
            return treeModel.getChildrenCount((Object)((ThreadWithBordel)object).originalThread);
        }
        if (object instanceof OwnedMonitors) {
            return ((OwnedMonitors)object).variables.length;
        }
        return treeModel.getChildrenCount(object);
    }

    public boolean isLeaf(TreeModel treeModel, Object object) throws UnknownTypeException {
        if (object instanceof ThreadWithBordel) {
            return false;
        }
        if (object instanceof OwnedMonitors) {
            return false;
        }
        if (object instanceof ContendedMonitor) {
            return true;
        }
        if (object instanceof ObjectVariable) {
            return true;
        }
        return treeModel.isLeaf(object);
    }

    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (object instanceof ContendedMonitor) {
            ObjectVariable objectVariable = ((ContendedMonitor)object).variable;
            return MessageFormat.format(NbBundle.getBundle(MonitorModel.class).getString("CTL_MonitorModel_Column_ContendedMonitor"), objectVariable.getType(), objectVariable.getValue());
        }
        if (object instanceof ThreadWithBordel) {
            return nodeModel.getDisplayName((Object)((ThreadWithBordel)object).originalThread);
        }
        if (object instanceof OwnedMonitors) {
            return NbBundle.getBundle(MonitorModel.class).getString("CTL_MonitorModel_Column_OwnedMonitors");
        }
        if (object instanceof ObjectVariable) {
            ObjectVariable objectVariable = (ObjectVariable)object;
            return MessageFormat.format(NbBundle.getBundle(MonitorModel.class).getString("CTL_MonitorModel_Column_Monitor"), objectVariable.getType(), objectVariable.getValue());
        }
        return nodeModel.getDisplayName(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final NodeModel nodeModel, final Object object) throws UnknownTypeException {
        Map map = this.shortDescriptionMap;
        synchronized (map) {
            Object v = this.shortDescriptionMap.remove(object);
            if (v instanceof String) {
                return (String)v;
            }
            if (v instanceof UnknownTypeException) {
                throw (UnknownTypeException)((Object)v);
            }
        }
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object3;
                Object object2;
                if (object instanceof ContendedMonitor) {
                    object2 = ((ContendedMonitor)object).variable;
                    try {
                        object3 = "(" + object2.getType() + ") " + object2.getToStringValue();
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        object3 = invalidExpressionException.getLocalizedMessage();
                    }
                } else if (object instanceof ThreadWithBordel) {
                    try {
                        object3 = nodeModel.getShortDescription((Object)((ThreadWithBordel)object).originalThread);
                    }
                    catch (UnknownTypeException unknownTypeException) {
                        object3 = unknownTypeException;
                    }
                } else if (object instanceof OwnedMonitors) {
                    object3 = "";
                } else if (object instanceof ObjectVariable) {
                    object2 = (ObjectVariable)object;
                    try {
                        object3 = "(" + object2.getType() + ") " + object2.getToStringValue();
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        object3 = invalidExpressionException.getLocalizedMessage();
                    }
                } else {
                    try {
                        object3 = nodeModel.getShortDescription(object);
                    }
                    catch (UnknownTypeException unknownTypeException) {
                        object3 = unknownTypeException;
                    }
                }
                if (object3 != null && !"".equals(object3)) {
                    object2 = MonitorModel.this.shortDescriptionMap;
                    synchronized (object2) {
                        MonitorModel.this.shortDescriptionMap.put(object, object3);
                    }
                    MonitorModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)MonitorModel.this, object, 4));
                }
            }
        });
        return "";
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (object instanceof ContendedMonitor) {
            return CONTENDED_MONITOR;
        }
        if (object instanceof ThreadWithBordel) {
            return nodeModel.getIconBase((Object)((ThreadWithBordel)object).originalThread);
        }
        if (object instanceof OwnedMonitors) {
            return OWNED_MONITORS;
        }
        if (object instanceof ObjectVariable) {
            return MONITOR;
        }
        return nodeModel.getIconBase(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent modelEvent) {
        Object[] objectArray;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            objectArray = this.modelListeners.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((ModelListener)objectArray[i]).modelChanged(modelEvent);
        }
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof ContendedMonitor) {
            return new Action[0];
        }
        if (object instanceof OwnedMonitors) {
            return new Action[0];
        }
        if (object instanceof ThreadWithBordel) {
            return nodeActionsProvider.getActions((Object)((ThreadWithBordel)object).originalThread);
        }
        if (object instanceof ObjectVariable) {
            return new Action[0];
        }
        return nodeActionsProvider.getActions(object);
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        if (object instanceof ContendedMonitor) {
            return;
        }
        if (object instanceof OwnedMonitors) {
            return;
        }
        if (object instanceof ThreadWithBordel) {
            nodeActionsProvider.performDefaultAction((Object)((ThreadWithBordel)object).originalThread);
            return;
        }
        if (object instanceof ObjectVariable) {
            return;
        }
        nodeActionsProvider.performDefaultAction(object);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof OwnedMonitors || object instanceof ContendedMonitor || object instanceof ObjectVariable) {
            if (string == "ThreadState") {
                return "";
            }
            if (string == "ThreadSuspended") {
                return null;
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if ((object instanceof OwnedMonitors || object instanceof ContendedMonitor || object instanceof ObjectVariable) && (string == "ThreadState" || string == "ThreadSuspended")) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
    }

    static class ThreadWithBordel {
        JPDAThread originalThread;

        ThreadWithBordel() {
        }
    }

    private static class ContendedMonitor {
        ObjectVariable variable;

        ContendedMonitor(ObjectVariable objectVariable) {
            this.variable = objectVariable;
        }
    }

    private static class OwnedMonitors {
        ObjectVariable[] variables;

        OwnedMonitors(ObjectVariable[] objectVariableArray) {
            this.variables = objectVariableArray;
        }
    }
}

