/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class NumericDisplayFilter
implements TableModelFilter,
NodeActionsProviderFilter,
Constants {
    private final Map variableToDisplaySettings = new HashMap();
    private HashSet listeners;

    public Object getValueAt(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        if ((string == "WatchValue" || string == "WatchToString" || string == "LocalsValue" || string == "LocalsToString") && object instanceof Variable && this.isIntegralType((Variable)object)) {
            Variable variable = (Variable)object;
            return this.getValue(variable, (NumericDisplaySettings)this.variableToDisplaySettings.get(variable));
        }
        return tableModel.getValueAt(object, string);
    }

    public boolean isReadOnly(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        return tableModel.isReadOnly(object, string);
    }

    public void setValueAt(TableModel tableModel, Object object, String string, Object object2) throws UnknownTypeException {
        if ((string == "WatchValue" || string == "WatchToString" || string == "LocalsValue" || string == "LocalsToString") && object instanceof Variable && this.isIntegralType((Variable)object) && object2 instanceof String) {
            Variable variable = (Variable)object;
            object2 = this.setValue(variable, (NumericDisplaySettings)this.variableToDisplaySettings.get(variable), (String)object2);
        }
        tableModel.setValueAt(object, string, object2);
    }

    public void addModelListener(ModelListener modelListener) {
        HashSet hashSet = this.listeners == null ? new HashSet() : (HashSet)this.listeners.clone();
        hashSet.add(modelListener);
        this.listeners = hashSet;
    }

    public void removeModelListener(ModelListener modelListener) {
        if (this.listeners == null) {
            return;
        }
        HashSet hashSet = (HashSet)this.listeners.clone();
        hashSet.remove(modelListener);
        this.listeners = hashSet;
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        nodeActionsProvider.performDefaultAction(object);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        Variable variable;
        Action[] actionArray;
        if (!(object instanceof Variable)) {
            return nodeActionsProvider.getActions(object);
        }
        try {
            actionArray = nodeActionsProvider.getActions(object);
        }
        catch (UnknownTypeException unknownTypeException) {
            actionArray = new Action[]{};
        }
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (object instanceof Variable && this.isIntegralType(variable = (Variable)object)) {
            arrayList.add(new DisplayAsAction((Variable)object));
        }
        arrayList.addAll(Arrays.asList(actionArray));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static int getChar(String string) {
        string = string.substring(1, string.length() - 1);
        char c = string.charAt(0);
        return c & 0xFFFF;
    }

    private Object getValue(Variable variable, NumericDisplaySettings numericDisplaySettings) {
        if (numericDisplaySettings == null) {
            return variable.getValue();
        }
        String string = variable.getType();
        try {
            switch (numericDisplaySettings.getDisplayAs()) {
                case 0: {
                    if ("char".equals(string)) {
                        int n = NumericDisplayFilter.getChar(variable.getValue());
                        return Integer.toString(n);
                    }
                    return variable.getValue();
                }
                case 1: {
                    if ("int".equals(string)) {
                        return "0x" + Integer.toHexString(Integer.parseInt(variable.getValue()));
                    }
                    if ("short".equals(string)) {
                        String string2 = Integer.toHexString(Short.parseShort(variable.getValue()));
                        if (string2.length() > 4) {
                            string2 = string2.substring(string2.length() - 4, string2.length());
                        }
                        return "0x" + string2;
                    }
                    if ("byte".equals(string)) {
                        String string3 = Integer.toHexString(Byte.parseByte(variable.getValue()));
                        if (string3.length() > 2) {
                            string3 = string3.substring(string3.length() - 2, string3.length());
                        }
                        return "0x" + string3;
                    }
                    if ("char".equals(string)) {
                        int n = NumericDisplayFilter.getChar(variable.getValue());
                        return "0x" + Integer.toHexString(n);
                    }
                    return "0x" + Long.toHexString(Long.parseLong(variable.getValue()));
                }
                case 2: {
                    if ("int".equals(string)) {
                        return "0" + Integer.toOctalString(Integer.parseInt(variable.getValue()));
                    }
                    if ("short".equals(string)) {
                        String string4 = Integer.toOctalString(Short.parseShort(variable.getValue()));
                        if (string4.length() > 5) {
                            string4 = string4.substring(string4.length() - 5, string4.length());
                        }
                        return "0" + (string4.charAt(0) == '0' ? "1" : "") + string4;
                    }
                    if ("byte".equals(string)) {
                        String string5 = Integer.toOctalString(Byte.parseByte(variable.getValue()));
                        if (string5.length() > 3) {
                            string5 = "1" + string5.substring(string5.length() - 2, string5.length());
                        }
                        return "0" + string5;
                    }
                    if ("char".equals(string)) {
                        int n = NumericDisplayFilter.getChar(variable.getValue());
                        return "0" + Integer.toOctalString(n);
                    }
                    return "0" + Long.toOctalString(Long.parseLong(variable.getValue()));
                }
                case 3: {
                    if ("int".equals(string)) {
                        return Integer.toBinaryString(Integer.parseInt(variable.getValue()));
                    }
                    if ("short".equals(string)) {
                        String string6 = Integer.toBinaryString(Short.parseShort(variable.getValue()));
                        if (string6.length() > 16) {
                            string6 = string6.substring(string6.length() - 16, string6.length());
                        }
                        return string6;
                    }
                    if ("byte".equals(string)) {
                        String string7 = Integer.toBinaryString(Byte.parseByte(variable.getValue()));
                        if (string7.length() > 8) {
                            string7 = string7.substring(string7.length() - 8, string7.length());
                        }
                        return string7;
                    }
                    if ("char".equals(string)) {
                        int n = NumericDisplayFilter.getChar(variable.getValue());
                        return Integer.toBinaryString(n);
                    }
                    return Long.toBinaryString(Long.parseLong(variable.getValue()));
                }
                case 4: {
                    if ("char".equals(string)) {
                        return variable.getValue();
                    }
                    return "'" + new Character((char)Integer.parseInt(variable.getValue())) + "'";
                }
            }
            return variable.getValue();
        }
        catch (NumberFormatException numberFormatException) {
            return numberFormatException.getLocalizedMessage();
        }
    }

    private Object setValue(Variable variable, NumericDisplaySettings numericDisplaySettings, String string) {
        if (numericDisplaySettings == null) {
            return string;
        }
        String string2 = variable.getType();
        try {
            switch (numericDisplaySettings.getDisplayAs()) {
                case 3: {
                    if ("int".equals(string2)) {
                        return Integer.toString(Integer.parseInt(string, 2));
                    }
                    if ("short".equals(string2)) {
                        return Short.toString(Short.parseShort(string, 2));
                    }
                    if ("byte".equals(string2)) {
                        return Byte.toString(Byte.parseByte(string, 2));
                    }
                    if ("char".equals(string2)) {
                        return "'" + Character.toString((char)Integer.parseInt(string, 2)) + "'";
                    }
                    return Long.toString(Long.parseLong(string, 2)) + "l";
                }
            }
            return string;
        }
        catch (NumberFormatException numberFormatException) {
            return numberFormatException.getLocalizedMessage();
        }
    }

    private boolean isIntegralType(Variable variable) {
        if (!VariablesTreeModelFilter.isEvaluated(variable)) {
            return false;
        }
        String string = variable.getType();
        return "int".equals(string) || "char".equals(string) || "byte".equals(string) || "long".equals(string) || "short".equals(string);
    }

    private String localize(String string) {
        return NbBundle.getBundle(NumericDisplayFilter.class).getString(string);
    }

    private static class NumericDisplaySettings {
        public static final int DECIMAL = 0;
        public static final int HEXADECIMAL = 1;
        public static final int OCTAL = 2;
        public static final int BINARY = 3;
        public static final int CHAR = 4;
        private int displayAs;

        public NumericDisplaySettings(int n) {
            this.displayAs = n;
        }

        public int getDisplayAs() {
            return this.displayAs;
        }
    }

    private class DisplayAsAction
    extends AbstractAction
    implements Presenter.Popup {
        private Variable variable;
        private String type;

        public DisplayAsAction(Variable variable) {
            this.variable = variable;
            this.type = variable.getType();
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu jMenu = new JMenu(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Popup"));
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Decimal")){

                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayAsAction.this.onDisplayAs(0);
                }
            });
            JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(new AbstractAction(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Hexadecimal")){

                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayAsAction.this.onDisplayAs(1);
                }
            });
            JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(new AbstractAction(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Octal")){

                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayAsAction.this.onDisplayAs(2);
                }
            });
            JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem(new AbstractAction(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Binary")){

                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayAsAction.this.onDisplayAs(3);
                }
            });
            JRadioButtonMenuItem jRadioButtonMenuItem5 = new JRadioButtonMenuItem(new AbstractAction(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Character")){

                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayAsAction.this.onDisplayAs(4);
                }
            });
            NumericDisplaySettings numericDisplaySettings = (NumericDisplaySettings)NumericDisplayFilter.this.variableToDisplaySettings.get(this.variable);
            if (numericDisplaySettings != null) {
                switch (numericDisplaySettings.getDisplayAs()) {
                    case 0: {
                        jRadioButtonMenuItem.setSelected(true);
                        break;
                    }
                    case 1: {
                        jRadioButtonMenuItem2.setSelected(true);
                        break;
                    }
                    case 2: {
                        jRadioButtonMenuItem3.setSelected(true);
                        break;
                    }
                    case 3: {
                        jRadioButtonMenuItem4.setSelected(true);
                        break;
                    }
                    case 4: {
                        jRadioButtonMenuItem5.setSelected(true);
                    }
                }
            } else if ("char".equals(this.type)) {
                jRadioButtonMenuItem5.setSelected(true);
            } else {
                jRadioButtonMenuItem.setSelected(true);
            }
            jMenu.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem2);
            jMenu.add(jRadioButtonMenuItem3);
            jMenu.add(jRadioButtonMenuItem4);
            jMenu.add(jRadioButtonMenuItem5);
            return jMenu;
        }

        private void onDisplayAs(int n) {
            NumericDisplaySettings numericDisplaySettings = (NumericDisplaySettings)NumericDisplayFilter.this.variableToDisplaySettings.get(this.variable);
            if (numericDisplaySettings == null) {
                numericDisplaySettings = "char".equals(this.type) ? new NumericDisplaySettings(4) : new NumericDisplaySettings(0);
            }
            if (numericDisplaySettings.getDisplayAs() == n) {
                return;
            }
            NumericDisplayFilter.this.variableToDisplaySettings.put(this.variable, new NumericDisplaySettings(n));
            this.fireModelChanged();
        }

        private void fireModelChanged() {
            if (NumericDisplayFilter.this.listeners == null) {
                return;
            }
            ModelEvent.TableValueChanged tableValueChanged = new ModelEvent.TableValueChanged((Object)this, (Object)this.variable, null);
            for (ModelListener modelListener : NumericDisplayFilter.this.listeners) {
                modelListener.modelChanged((ModelEvent)tableValueChanged);
            }
        }
    }
}

