/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import javax.swing.Action;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.models.MonitorModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class ThreadsActionsProvider
implements NodeActionsProvider {
    private Action MAKE_CURRENT_ACTION = Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_ThreadAction_MakeCurrent_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            if (object instanceof MonitorModel.ThreadWithBordel) {
                object = ((MonitorModel.ThreadWithBordel)object).originalThread;
            }
            return ThreadsActionsProvider.this.debugger.getCurrentThread() != object;
        }

        public void perform(Object[] objectArray) {
            if (objectArray[0] instanceof MonitorModel.ThreadWithBordel) {
                objectArray[0] = ((MonitorModel.ThreadWithBordel)objectArray[0]).originalThread;
            }
            ((JPDAThread)objectArray[0]).makeCurrent();
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static Action GO_TO_SOURCE_ACTION = Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_ThreadAction_GoToSource_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            if (object instanceof MonitorModel.ThreadWithBordel) {
                object = ((MonitorModel.ThreadWithBordel)object).originalThread;
            }
            return ThreadsActionsProvider.isGoToSourceSupported((JPDAThread)object);
        }

        public void perform(Object[] objectArray) {
            if (objectArray[0] instanceof MonitorModel.ThreadWithBordel) {
                objectArray[0] = ((MonitorModel.ThreadWithBordel)objectArray[0]).originalThread;
            }
            String string = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
            SourcePath sourcePath = (SourcePath)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, SourcePath.class);
            sourcePath.showSource((JPDAThread)objectArray[0], string);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private Action SUSPEND_ACTION = Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_ThreadAction_Suspend_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            if (object instanceof MonitorModel.ThreadWithBordel) {
                object = ((MonitorModel.ThreadWithBordel)object).originalThread;
            }
            if (object instanceof JPDAThread) {
                return !((JPDAThread)object).isSuspended();
            }
            return true;
        }

        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2 = object = objectArray[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)objectArray[i]).originalThread : objectArray[i];
                if (object instanceof JPDAThread) {
                    ((JPDAThread)object).suspend();
                    continue;
                }
                ((JPDAThreadGroup)object).suspend();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ALL);
    private Action RESUME_ACTION = Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_ThreadAction_Resume_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            if (object instanceof MonitorModel.ThreadWithBordel) {
                object = ((MonitorModel.ThreadWithBordel)object).originalThread;
            }
            if (object instanceof JPDAThread) {
                return ((JPDAThread)object).isSuspended();
            }
            return true;
        }

        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2 = object = objectArray[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)objectArray[i]).originalThread : objectArray[i];
                if (object instanceof JPDAThread) {
                    ((JPDAThread)object).resume();
                    continue;
                }
                ((JPDAThreadGroup)object).resume();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ALL);
    private Action INTERRUPT_ACTION = Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_ThreadAction_Interrupt_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            if (object instanceof MonitorModel.ThreadWithBordel) {
                object = ((MonitorModel.ThreadWithBordel)object).originalThread;
            }
            if (object instanceof JPDAThread) {
                return !((JPDAThread)object).isSuspended();
            }
            return false;
        }

        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2 = object = objectArray[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)objectArray[i]).originalThread : objectArray[i];
                if (!(object instanceof JPDAThread)) continue;
                ((JPDAThread)object).interrupt();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ALL);
    private JPDADebugger debugger;

    public ThreadsActionsProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return new Action[0];
        }
        if (object instanceof JPDAThreadGroup) {
            return new Action[]{this.RESUME_ACTION, this.SUSPEND_ACTION};
        }
        if (object instanceof JPDAThread) {
            JPDAThread jPDAThread = (JPDAThread)object;
            boolean bl = jPDAThread.isSuspended();
            Action action = null;
            action = bl ? this.RESUME_ACTION : this.SUSPEND_ACTION;
            return new Action[]{this.MAKE_CURRENT_ACTION, action, this.INTERRUPT_ACTION, GO_TO_SOURCE_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (!(object instanceof JPDAThread)) {
            if (object instanceof JPDAThreadGroup) {
                return;
            }
            throw new UnknownTypeException(object);
        }
        ((JPDAThread)object).makeCurrent();
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    private static boolean isGoToSourceSupported(JPDAThread jPDAThread) {
        String string = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
        if (!jPDAThread.isSuspended()) {
            return false;
        }
        SourcePath sourcePath = (SourcePath)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, SourcePath.class);
        return sourcePath.sourceAvailable(jPDAThread, string, true);
    }
}

