/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.VariablesFilter;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

public class VariablesTreeModelFilter
implements TreeModelFilter,
ExtendedNodeModelFilter,
TableModelFilter,
NodeActionsProviderFilter,
Runnable {
    private ContextProvider lookupProvider;
    private final Collection modelListeners = new HashSet();
    private RequestProcessor evaluationRP = new RequestProcessor();
    private RequestProcessor.Task evaluationTask;
    private LinkedList evaluationQueue = new LinkedList();
    private HashMap typeToFilter;
    private HashMap ancestorToFilter;

    public VariablesTreeModelFilter(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
    }

    public Object getRoot(TreeModel treeModel) {
        return treeModel.getRoot();
    }

    public static boolean isEvaluated(Object object) {
        if (object instanceof Refreshable) {
            return ((Refreshable)object).isCurrent();
        }
        return true;
    }

    private static void waitToEvaluate(Object object) {
        if (object instanceof Refreshable) {
            try {
                ((Refreshable)object).refresh();
            }
            catch (RefreshFailedException refreshFailedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEvaluationMonitor(Object object, Runnable runnable) {
        LinkedList linkedList = this.evaluationQueue;
        synchronized (linkedList) {
            if (this.evaluationQueue.contains(object) && this.evaluationQueue.contains(runnable)) {
                return;
            }
            if (this.evaluationTask == null) {
                this.evaluationTask = this.evaluationRP.create((Runnable)this);
            }
            this.evaluationQueue.add(object);
            this.evaluationQueue.add(runnable);
            this.evaluationTask.schedule(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object var1_1;
        do {
            var1_1 = null;
            Runnable runnable = null;
            LinkedList linkedList = this.evaluationQueue;
            synchronized (linkedList) {
                if (!this.evaluationQueue.isEmpty()) {
                    var1_1 = this.evaluationQueue.removeFirst();
                    runnable = (Runnable)this.evaluationQueue.removeFirst();
                }
            }
            if (var1_1 == null) continue;
            VariablesTreeModelFilter.waitToEvaluate(var1_1);
            if (runnable != null) {
                runnable.run();
                continue;
            }
            this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)this, var1_1));
        } while (var1_1 != null);
        this.evaluationTask = null;
    }

    public Object[] getChildren(TreeModel treeModel, final Object object, int n, int n2) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, new Runnable(){

            public void run() {
                VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, object, 8));
            }
        });
        Object[] objectArray = variablesFilter == null ? treeModel.getChildren(object, n, n2) : variablesFilter.getChildren(treeModel, (Variable)object, n, n2);
        return objectArray;
    }

    public int getChildrenCount(TreeModel treeModel, final Object object) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, new Runnable(){

            public void run() {
                VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, object, 8));
            }
        });
        int n = variablesFilter == null ? treeModel.getChildrenCount(object) : variablesFilter.getChildrenCount(treeModel, (Variable)object);
        return n;
    }

    public boolean isLeaf(TreeModel treeModel, Object object) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (variablesFilter == null) {
            return treeModel.isLeaf(object);
        }
        return variablesFilter.isLeaf(treeModel, (Variable)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent modelEvent) {
        Object[] objectArray;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            objectArray = this.modelListeners.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((ModelListener)objectArray[i]).modelChanged(modelEvent);
        }
    }

    public String getDisplayName(final NodeModel nodeModel, final Object object) throws UnknownTypeException {
        final String[] stringArray = new String[]{null};
        VariablesFilter variablesFilter = this.getFilter(object, true, new Runnable(){

            public void run() {
                String string;
                VariablesFilter variablesFilter = VariablesTreeModelFilter.this.getFilter(object, false, null);
                if (variablesFilter == null) {
                    return;
                }
                try {
                    string = variablesFilter.getDisplayName(nodeModel, (Variable)object);
                }
                catch (UnknownTypeException unknownTypeException) {
                    string = unknownTypeException.toString();
                }
                if (!string.equals(stringArray[0])) {
                    VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, object, 1));
                }
            }
        });
        if (variablesFilter == null) {
            String string;
            stringArray[0] = string = nodeModel.getDisplayName(object);
            return string;
        }
        return variablesFilter.getDisplayName(nodeModel, (Variable)object);
    }

    public String getIconBase(final NodeModel nodeModel, final Object object) throws UnknownTypeException {
        final String[] stringArray = new String[]{null};
        VariablesFilter variablesFilter = this.getFilter(object, true, new Runnable(){

            public void run() {
                String string;
                VariablesFilter variablesFilter = VariablesTreeModelFilter.this.getFilter(object, false, null);
                if (variablesFilter == null) {
                    return;
                }
                try {
                    string = variablesFilter.getIconBase(nodeModel, (Variable)object);
                }
                catch (UnknownTypeException unknownTypeException) {
                    string = unknownTypeException.toString();
                }
                if (!string.equals(stringArray[0])) {
                    VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, object, 2));
                }
            }
        });
        if (variablesFilter == null) {
            String string;
            stringArray[0] = string = nodeModel.getIconBase(object);
            return string;
        }
        return variablesFilter.getIconBase(nodeModel, (Variable)object);
    }

    public String getShortDescription(final NodeModel nodeModel, final Object object) throws UnknownTypeException {
        final String[] stringArray = new String[]{null};
        VariablesFilter variablesFilter = this.getFilter(object, true, new Runnable(){

            public void run() {
                String string;
                VariablesFilter variablesFilter = VariablesTreeModelFilter.this.getFilter(object, false, null);
                if (variablesFilter == null) {
                    return;
                }
                try {
                    string = variablesFilter.getShortDescription(nodeModel, (Variable)object);
                }
                catch (UnknownTypeException unknownTypeException) {
                    string = unknownTypeException.toString();
                }
                if (!string.equals(stringArray[0])) {
                    VariablesTreeModelFilter.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesTreeModelFilter.this, object, 4));
                }
            }
        });
        if (variablesFilter == null) {
            return nodeModel.getShortDescription(object);
        }
        return variablesFilter.getShortDescription(nodeModel, (Variable)object);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (variablesFilter == null) {
            return nodeActionsProvider.getActions(object);
        }
        return variablesFilter.getActions(nodeActionsProvider, (Variable)object);
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (variablesFilter == null) {
            nodeActionsProvider.performDefaultAction(object);
        } else {
            variablesFilter.performDefaultAction(nodeActionsProvider, (Variable)object);
        }
    }

    public Object getValueAt(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, false, null);
        Object object2 = variablesFilter == null ? tableModel.getValueAt(object, string) : variablesFilter.getValueAt(tableModel, (Variable)object, string);
        return object2;
    }

    public boolean isReadOnly(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (variablesFilter == null) {
            return tableModel.isReadOnly(object, string);
        }
        return variablesFilter.isReadOnly(tableModel, (Variable)object, string);
    }

    public void setValueAt(TableModel tableModel, Object object, String string, Object object2) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, false, null);
        if (variablesFilter == null) {
            tableModel.setValueAt(object, string, object2);
        } else {
            variablesFilter.setValueAt(tableModel, (Variable)object, string, object2);
        }
    }

    private VariablesFilter getFilter(Object object, boolean bl, Runnable runnable) {
        VariablesFilter variablesFilter;
        Object object2;
        if (this.typeToFilter == null) {
            this.typeToFilter = new HashMap();
            this.ancestorToFilter = new HashMap();
            object2 = this.lookupProvider.lookup(null, VariablesFilter.class);
            int n = object2.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                variablesFilter = (VariablesFilter)object2.get(i);
                String[] stringArray = variablesFilter.getSupportedAncestors();
                int n3 = stringArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    this.ancestorToFilter.put(stringArray[n2], variablesFilter);
                }
                stringArray = variablesFilter.getSupportedTypes();
                n3 = stringArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    this.typeToFilter.put(stringArray[n2], variablesFilter);
                }
            }
        }
        if (this.typeToFilter.size() == 0) {
            return null;
        }
        if (!(object instanceof Variable)) {
            return null;
        }
        object2 = (Variable)object;
        if (bl && !VariablesTreeModelFilter.isEvaluated(object2)) {
            if (runnable != null) {
                this.postEvaluationMonitor(object, runnable);
            }
            return null;
        }
        String string = object2.getType();
        VariablesFilter variablesFilter2 = (VariablesFilter)this.typeToFilter.get(string);
        if (variablesFilter2 != null) {
            return variablesFilter2;
        }
        if (!(object instanceof ObjectVariable)) {
            return null;
        }
        variablesFilter = (ObjectVariable)object;
        for (variablesFilter = variablesFilter.getSuper(); variablesFilter != null; variablesFilter = variablesFilter.getSuper()) {
            string = variablesFilter.getType();
            variablesFilter2 = (VariablesFilter)this.ancestorToFilter.get(string);
            if (variablesFilter2 == null) continue;
            return variablesFilter2;
        }
        return null;
    }

    public boolean canRename(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (!(variablesFilter instanceof ExtendedNodeModelFilter)) {
            return extendedNodeModel.canRename(object);
        }
        return ((ExtendedNodeModelFilter)variablesFilter).canRename(extendedNodeModel, object);
    }

    public boolean canCopy(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (!(variablesFilter instanceof ExtendedNodeModelFilter)) {
            return extendedNodeModel.canCopy(object);
        }
        return ((ExtendedNodeModelFilter)variablesFilter).canCopy(extendedNodeModel, object);
    }

    public boolean canCut(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (!(variablesFilter instanceof ExtendedNodeModelFilter)) {
            return extendedNodeModel.canCut(object);
        }
        return ((ExtendedNodeModelFilter)variablesFilter).canCut(extendedNodeModel, object);
    }

    public Transferable clipboardCopy(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (!(variablesFilter instanceof ExtendedNodeModelFilter)) {
            return extendedNodeModel.clipboardCopy(object);
        }
        return ((ExtendedNodeModelFilter)variablesFilter).clipboardCopy(extendedNodeModel, object);
    }

    public Transferable clipboardCut(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (!(variablesFilter instanceof ExtendedNodeModelFilter)) {
            return extendedNodeModel.clipboardCut(object);
        }
        return ((ExtendedNodeModelFilter)variablesFilter).clipboardCut(extendedNodeModel, object);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel extendedNodeModel, Object object, Transferable transferable) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (!(variablesFilter instanceof ExtendedNodeModelFilter)) {
            return extendedNodeModel.getPasteTypes(object, transferable);
        }
        return ((ExtendedNodeModelFilter)variablesFilter).getPasteTypes(extendedNodeModel, object, transferable);
    }

    public void setName(ExtendedNodeModel extendedNodeModel, Object object, String string) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (!(variablesFilter instanceof ExtendedNodeModelFilter)) {
            extendedNodeModel.setName(object, string);
        } else {
            ((ExtendedNodeModelFilter)variablesFilter).setName(extendedNodeModel, object, string);
        }
    }

    public String getIconBaseWithExtension(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        VariablesFilter variablesFilter = this.getFilter(object, true, null);
        if (!(variablesFilter instanceof ExtendedNodeModelFilter)) {
            return extendedNodeModel.getIconBaseWithExtension(object);
        }
        return ((ExtendedNodeModelFilter)variablesFilter).getIconBaseWithExtension(extendedNodeModel, object);
    }
}

