/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.spi.designtime.idebridge.action;

import com.sun.rave.designtime.DesignBean;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public abstract class AbstractDesignBeanAction
extends AbstractAction
implements ContextAwareAction {
    protected static final String PROP_DESIGN_BEANS = "designBeans";

    public AbstractDesignBeanAction() {
        this.putValue("Name", this.getDisplayName(new DesignBean[0]));
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("This can't be called directly, it is just a placeholder, the context aware instance has to be used."));
    }

    public final Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(this, lookup);
    }

    protected abstract String getDisplayName(DesignBean[] var1);

    protected abstract String getIconBase(DesignBean[] var1);

    protected abstract boolean isEnabled(DesignBean[] var1);

    protected abstract void performAction(DesignBean[] var1);

    protected JMenuItem getMenuPresenter(Action action, Lookup.Result result) {
        return new Actions.MenuItem(action, true);
    }

    protected JMenuItem getPopupPresenter(Action action, Lookup.Result result) {
        return new Actions.MenuItem(action, false);
    }

    protected Component getToolbarPresenter(Action action, Lookup.Result result) {
        return new Actions.ToolbarButton(action);
    }

    protected static final DesignBean[] getDesignBeans(Lookup.Result result) {
        Node[] nodeArray = AbstractDesignBeanAction.getNodes(result);
        ArrayList<DesignBean> arrayList = new ArrayList<DesignBean>();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            DesignBean designBean = (DesignBean)node.getLookup().lookup(DesignBean.class);
            if (designBean == null || arrayList.contains(designBean)) continue;
            arrayList.add(designBean);
        }
        return arrayList.toArray(new DesignBean[arrayList.size()]);
    }

    private static final Node[] getNodes(Lookup.Result result) {
        Collection collection = result.allInstances();
        return collection.toArray(new Node[collection.size()]);
    }

    private static class DelegateAction
    implements Action,
    LookupListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar {
        private final AbstractDesignBeanAction delegate;
        private final Lookup.Result result;
        private boolean enabled = true;
        private final PropertyChangeSupport support = new PropertyChangeSupport(this);

        public DelegateAction(AbstractDesignBeanAction abstractDesignBeanAction, Lookup lookup) {
            this.delegate = abstractDesignBeanAction;
            this.result = lookup.lookup(new Lookup.Template(Node.class));
            this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)this.result));
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.delegate.performAction(AbstractDesignBeanAction.getDesignBeans(this.result));
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        public void putValue(String string, Object object) {
            this.delegate.putValue(string, object);
        }

        public Object getValue(String string) {
            if ("Name".equals(string)) {
                return this.delegate.getDisplayName(AbstractDesignBeanAction.getDesignBeans(this.result));
            }
            if ("iconBase".equals(string)) {
                return this.delegate.getIconBase(AbstractDesignBeanAction.getDesignBeans(this.result));
            }
            return this.delegate.getValue(string);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            if (this.enabled == bl) {
                return;
            }
            this.enabled = bl;
            this.support.firePropertyChange("enabled", !bl, bl);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            DesignBean[] designBeanArray = AbstractDesignBeanAction.getDesignBeans(this.result);
            this.setEnabled(this.delegate.isEnabled(designBeanArray));
            this.support.firePropertyChange(AbstractDesignBeanAction.PROP_DESIGN_BEANS, null, designBeanArray);
        }

        public JMenuItem getMenuPresenter() {
            return this.delegate.getMenuPresenter(this, this.result);
        }

        public JMenuItem getPopupPresenter() {
            return this.delegate.getPopupPresenter(this, this.result);
        }

        public Component getToolbarPresenter() {
            return this.delegate.getToolbarPresenter(this, this.result);
        }
    }
}

