/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.BinaryElementOpen;
import org.netbeans.modules.java.source.ui.JavaTypeDescription;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JavaTypeProvider
implements TypeProvider {
    private static final Logger LOGGER = Logger.getLogger(JavaTypeProvider.class.getName());
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    private Set<CacheItem> cache;
    private volatile boolean isCanceled = false;
    private final TypeElementFinder.Customizer customizer;
    private ClasspathInfo cpInfo;
    private GlobalPathRegistryListener pathListener;

    public String name() {
        return "java";
    }

    public String getDisplayName() {
        return "Java Classes";
    }

    public void cleanup() {
        this.cache = null;
        if (this.pathListener != null) {
            GlobalPathRegistry.getDefault().removeGlobalPathRegistryListener(this.pathListener);
        }
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public JavaTypeProvider() {
        this(null, null);
    }

    public JavaTypeProvider(ClasspathInfo classpathInfo, TypeElementFinder.Customizer customizer) {
        this.cpInfo = classpathInfo;
        this.customizer = customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result result) {
        Object object;
        Object object2;
        Object object3;
        long l;
        AbstractCollection abstractCollection;
        ClassIndex.NameKind nameKind;
        String string = context.getText();
        SearchType searchType = context.getSearchType();
        boolean bl = Lookup.getDefault().lookup(BinaryElementOpen.class) != null;
        switch (searchType) {
            case EXACT_NAME: {
                nameKind = ClassIndex.NameKind.SIMPLE_NAME;
                break;
            }
            case CASE_INSENSITIVE_EXACT_NAME: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case PREFIX: {
                nameKind = ClassIndex.NameKind.PREFIX;
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
                break;
            }
            case REGEXP: {
                nameKind = ClassIndex.NameKind.REGEXP;
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case CAMEL_CASE: {
                nameKind = ClassIndex.NameKind.CAMEL_CASE;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected search type: " + searchType);
            }
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        Future future = OpenProjects.getDefault().openProjects();
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            LOGGER.fine(interruptedException.getMessage());
        }
        catch (ExecutionException executionException) {
            LOGGER.fine(executionException.getMessage());
        }
        if (this.cache == null) {
            int n;
            FileObject[] fileObjectArray;
            abstractCollection = null;
            if (this.cpInfo == null) {
                l = System.currentTimeMillis();
                object3 = RepositoryUpdater.getDefault().getScannedSources();
                fileObjectArray = object3.getRoots();
                l7 += System.currentTimeMillis() - l;
                object2 = new FileObject[1];
                abstractCollection = new HashSet(fileObjectArray.length);
                for (n = 0; n < fileObjectArray.length; ++n) {
                    object2[0] = fileObjectArray[n];
                    l = System.currentTimeMillis();
                    object = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((FileObject[])object2));
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add((CacheItem)new CacheItem(fileObjectArray[n], (ClasspathInfo)object, false));
                    l8 += System.currentTimeMillis() - l;
                }
                l = System.currentTimeMillis();
                object3 = RepositoryUpdater.getDefault().getScannedBinaries();
                fileObjectArray = object3.getRoots();
                l6 += System.currentTimeMillis() - l;
                object2 = new FileObject[1];
                for (n = 0; n < fileObjectArray.length; ++n) {
                    try {
                        if (this.isCanceled) {
                            return;
                        }
                        l = System.currentTimeMillis();
                        if (!bl && (object = SourceForBinaryQuery.findSourceRoots((URL)fileObjectArray[n].getURL())).getRoots().length == 0) continue;
                        l5 += System.currentTimeMillis() - l;
                        l = System.currentTimeMillis();
                        object2[0] = fileObjectArray[n];
                        object = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((FileObject[])object2), (ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH);
                        abstractCollection.add(new CacheItem(fileObjectArray[n], (ClasspathInfo)object, true));
                        l8 += System.currentTimeMillis() - l;
                        continue;
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        if (!this.isCanceled) continue;
                        return;
                    }
                    finally {
                        if (this.isCanceled) {
                            return;
                        }
                    }
                }
            } else {
                object3 = this.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT).getRoots();
                fileObjectArray = this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE).getRoots();
                object2 = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).getRoots();
                abstractCollection = new HashSet(((FileObject[])object3).length + fileObjectArray.length + ((Object)object2).length);
                for (n = 0; n < ((ClassPath)object3).length; ++n) {
                    l = System.currentTimeMillis();
                    object = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{object3[n]}), (ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH);
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add(new CacheItem((FileObject)object3[n], (ClasspathInfo)object, true));
                    l8 += System.currentTimeMillis() - l;
                }
                for (n = 0; n < fileObjectArray.length; ++n) {
                    l = System.currentTimeMillis();
                    object = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObjectArray[n]}), (ClassPath)EMPTY_CLASSPATH);
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add(new CacheItem(fileObjectArray[n], (ClasspathInfo)object, true));
                    l8 += System.currentTimeMillis() - l;
                }
                for (n = 0; n < ((Object)object2).length; ++n) {
                    l = System.currentTimeMillis();
                    object = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{object2[n]}));
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add(new CacheItem((FileObject)object2[n], (ClasspathInfo)object, false));
                    l8 += System.currentTimeMillis() - l;
                }
            }
            if (!this.isCanceled) {
                this.cache = abstractCollection;
            } else {
                return;
            }
        }
        abstractCollection = new ArrayList(this.cache.size() * 20);
        object3 = null;
        boolean bl2 = RepositoryUpdater.getDefault().isScanInProgress();
        if (bl2) {
            object2 = NbBundle.getMessage(JavaTypeProvider.class, (String)"LBL_ScanInProgress_warning");
            result.setMessage((String)object2);
        } else {
            result.setMessage(null);
        }
        for (CacheItem cacheItem : this.cache) {
            JavaSource javaSource;
            Object object4;
            l = System.currentTimeMillis();
            switch (nameKind) {
                case REGEXP: 
                case CASE_INSENSITIVE_REGEXP: {
                    string = JavaTypeProvider.removeNonJavaChars(string);
                    object4 = searchType == SearchType.CASE_INSENSITIVE_EXACT_NAME ? string : string + "*";
                    object = object4 = ((String)object4).replace("*", ".*").replace('?', '.');
                    break;
                }
                default: {
                    object = string;
                }
            }
            if (this.customizer != null) {
                object3 = this.customizer.query(cacheItem.classpathInfo, (String)object, nameKind, EnumSet.of(cacheItem.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE));
            } else {
                object4 = new Set[1];
                javaSource = JavaSource.create((ClasspathInfo)cacheItem.classpathInfo, (FileObject[])new FileObject[0]);
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>((Set[])object4, cacheItem, (String)object, nameKind){
                        final /* synthetic */ Set[] val$n;
                        final /* synthetic */ CacheItem val$ci;
                        final /* synthetic */ String val$textForQuery;
                        final /* synthetic */ ClassIndex.NameKind val$nameKind;
                        {
                            this.val$n = setArray;
                            this.val$ci = cacheItem;
                            this.val$textForQuery = string;
                            this.val$nameKind = nameKind;
                        }

                        public void run(CompilationController compilationController) throws Exception {
                            this.val$n[0] = this.val$ci.classpathInfo.getClassIndex().getDeclaredTypes(this.val$textForQuery, this.val$nameKind, EnumSet.of(this.val$ci.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE));
                        }
                    }, true);
                    object3 = object4[0];
                }
                catch (IOException iOException) {
                    LOGGER.fine(iOException.getMessage());
                }
            }
            if (this.isCanceled) {
                return;
            }
            l4 += System.currentTimeMillis() - l;
            l = System.currentTimeMillis();
            object4 = object3.iterator();
            while (object4.hasNext()) {
                javaSource = (ElementHandle)object4.next();
                JavaTypeDescription javaTypeDescription = new JavaTypeDescription(cacheItem, (ElementHandle<TypeElement>)javaSource);
                ((ArrayList)abstractCollection).add(javaTypeDescription);
                if (!this.isCanceled) continue;
                return;
            }
            l3 += System.currentTimeMillis() - l;
        }
        if (!this.isCanceled) {
            l = System.currentTimeMillis();
            LOGGER.fine("PERF -  GSS:  " + l7 + " GSB " + l6 + " CP: " + l8 + " SFB: " + l5 + " GTN: " + l4 + "  ADD: " + l3 + "  SORT: " + (l2 += System.currentTimeMillis() - l));
            result.addResult((List)((Object)abstractCollection));
        }
    }

    private static boolean isAllUpper(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isUpperCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String removeNonJavaChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '*' && c != '?') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static class CacheItem {
        public final boolean isBinary;
        public final FileObject fileObject;
        public final ClasspathInfo classpathInfo;
        public String projectName;
        public Icon projectIcon;
        private ClassPath.Entry defEntry;

        public CacheItem(FileObject fileObject, ClasspathInfo classpathInfo, boolean bl) {
            this.isBinary = bl;
            this.fileObject = fileObject;
            this.classpathInfo = classpathInfo;
        }

        public int hashCode() {
            return this.fileObject == null ? 0 : this.fileObject.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CacheItem) {
                CacheItem cacheItem = (CacheItem)object;
                return this.fileObject == null ? cacheItem.fileObject == null : this.fileObject.equals(cacheItem.fileObject);
            }
            return false;
        }

        public FileObject getRoot() {
            return this.fileObject;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public synchronized String getProjectName() {
            if (!this.isBinary && this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        public synchronized Icon getProjectIcon() {
            if (!this.isBinary && this.projectIcon == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        private void initProjectInfo() {
            Project project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
            if (project != null) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                this.projectName = projectInformation.getDisplayName();
                this.projectIcon = projectInformation.getIcon();
            }
        }
    }
}

