/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeNameIdGenerator {
    private static final String ARRAY_SUFFIX = "Arr";
    private final Elements elements;
    private final Types types;
    private final Map<String, String> qualNameToId;

    private TypeNameIdGenerator(Elements elements, Types types) {
        this.elements = elements;
        this.types = types;
        this.qualNameToId = new HashMap<String, String>(20);
    }

    static TypeNameIdGenerator createFor(Collection<TypeMirror> collection, Elements elements, Types types) {
        TypeNameIdGenerator typeNameIdGenerator = new TypeNameIdGenerator(elements, types);
        typeNameIdGenerator.generateMapping(collection);
        return typeNameIdGenerator;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateMapping(Collection<TypeMirror> collection) {
        Object object;
        Object object2;
        int n = collection.size();
        int n2 = Math.max(5, n / 3);
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        HashSet<Object> hashSet = new HashSet<Object>((collection.size() * 3 + 1) / 2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n * 3 / 2);
        BitSet bitSet = new BitSet(n);
        BitSet bitSet2 = new BitSet(n);
        int n3 = 0;
        int n4 = 0;
        HashSet<String> hashSet2 = new HashSet<String>(13);
        int n5 = 0;
        for (TypeMirror typeMirror : collection) {
            block29: {
                TypeKind typeKind = typeMirror.getKind();
                if (typeKind != TypeKind.DECLARED && typeKind != TypeKind.ARRAY) continue;
                if (typeKind == TypeKind.ARRAY) {
                    String string;
                    TypeKind typeKind2;
                    int n6 = 0;
                    StringBuilder stringBuilder = new StringBuilder(20);
                    StringBuilder stringBuilder2 = new StringBuilder(26);
                    TypeMirror typeMirror2 = typeMirror;
                    do {
                        ++n6;
                        stringBuilder.append('[');
                        stringBuilder2.append(ARRAY_SUFFIX);
                    } while ((typeKind2 = (typeMirror2 = ((ArrayType)typeMirror2).getComponentType()).getKind()) == TypeKind.ARRAY);
                    if (typeKind2 == TypeKind.DECLARED) {
                        string = this.getTypeFullName(typeMirror2);
                        object2 = stringBuilder.append(string).toString();
                        if (!hashSet.add(object2)) continue;
                        object = stringBuilder2.insert(0, TypeNameIdGenerator.getTypeBriefName(string)).toString();
                        break block29;
                    } else {
                        string = typeKind2.isPrimitive() ? this.getParamTypeId(typeMirror) : this.getParamTypeId(typeMirror2);
                        assert ((n4 += this.registerPrimitiveTypeIdUsage(string, hashMap, bitSet, hashSet2)) <= n3);
                        continue;
                    }
                }
                assert (typeKind == TypeKind.DECLARED);
                object2 = this.getTypeFullName(typeMirror);
                if (!hashSet.add(object2)) continue;
                object = TypeNameIdGenerator.getTypeBriefName((String)object2);
            }
            arrayList.add((String)object2);
            arrayList2.add((String)object);
            bitSet2.set(n5);
            ++n3;
            n4 += this.registerBriefTypeIdUsage((String)object, n5, hashMap, bitSet, hashSet2);
            ++n5;
        }
        hashSet.clear();
        hashSet = null;
        assert (n4 <= n3);
        assert (n4 == bitSet.cardinality());
        assert (n3 == bitSet2.cardinality());
        int n7 = n3 - n4;
        if (n7 > 0) {
            BitSet bitSet3 = (BitSet)bitSet2.clone();
            bitSet3.andNot(bitSet);
            n5 = bitSet3.nextSetBit(0);
            while (n5 >= 0) {
                String string = (String)arrayList.get(n5);
                object2 = (String)arrayList2.get(n5);
                hashSet2.add((String)object2);
                this.qualNameToId.put(string, (String)object2);
                n5 = bitSet3.nextSetBit(n5 + 1);
            }
        }
        if (n4 > 0) {
            BitSet bitSet4 = (BitSet)bitSet.clone();
            hashMap.clear();
            bitSet2.clear();
            bitSet.clear();
            n3 = 0;
            n4 = 0;
            String[] stringArray = new String[n];
            n5 = bitSet4.nextSetBit(0);
            while (n5 >= 0) {
                String string;
                object2 = (String)arrayList.get(n5);
                object = (String)arrayList2.get(n5);
                stringArray[n5] = string = TypeNameIdGenerator.getLongerTypeId((String)object2, (String)object);
                bitSet2.set(n5);
                ++n3;
                n4 += this.registerBriefTypeIdUsage(string, n5, hashMap, bitSet, hashSet2);
                n5 = bitSet4.nextSetBit(n5 + 1);
            }
            assert (n4 <= n3);
            assert (n4 == bitSet.cardinality());
            assert (n3 == bitSet2.cardinality());
            n7 = n3 - n4;
            if (n7 > 0) {
                object2 = (BitSet)bitSet2.clone();
                ((BitSet)object2).andNot(bitSet);
                n5 = ((BitSet)object2).nextSetBit(0);
                while (n5 >= 0 && n5 < n) {
                    object = (String)arrayList.get(n5);
                    String string = stringArray[n5];
                    hashSet2.add(string);
                    this.qualNameToId.put((String)object, string);
                    n5 = ((BitSet)object2).nextSetBit(n5 + 1);
                }
            }
        }
        if (n4 > 0) {
            HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>(n4 * 3 / 2);
            BitSet bitSet5 = bitSet;
            n5 = bitSet5.nextSetBit(0);
            while (n5 >= 0) {
                String string;
                object2 = (String)arrayList2.get(n5);
                object = (Integer)hashMap2.get(object2);
                int n8 = object == null ? 0 : (Integer)object;
                String string2 = (String)arrayList.get(n5);
                while (hashSet2.contains(string = (String)object2 + ++n8)) {
                }
                hashMap2.put(object2, n8);
                hashSet2.add(string);
                this.qualNameToId.put(string2, string);
                n5 = bitSet5.nextSetBit(n5 + 1);
            }
        }
        if (arrayList != null) {
            arrayList = null;
        }
        if (arrayList2 != null) {
            arrayList2 = null;
        }
        if (hashMap != null) {
            hashMap.clear();
        }
        if (bitSet2 != null) {
            bitSet2.clear();
        }
        if (bitSet != null) {
            bitSet.clear();
        }
        if (hashSet2 != null) {
            hashSet2.clear();
            hashSet2 = null;
        }
        if (collection != null) {
            collection.clear();
        }
    }

    private int registerPrimitiveTypeIdUsage(String string, Map<String, Object> map, BitSet bitSet, Collection<String> collection) {
        if (!collection.add(string)) {
            return 0;
        }
        int n = 0;
        Object object = map.get(string);
        if (object != null && object != Boolean.TRUE) {
            assert (object.getClass() == Integer.class);
            int n2 = (Integer)object;
            assert (!bitSet.get(n2));
            bitSet.set(n2);
            map.put(string, Boolean.TRUE);
            ++n;
        }
        return n;
    }

    private int registerBriefTypeIdUsage(String string, int n, Map<String, Object> map, BitSet bitSet, Collection<String> collection) {
        boolean bl;
        Object object = map.put(string, n);
        boolean bl2 = bl = object != null || collection != null && collection.contains(string);
        assert (!bitSet.get(n));
        int n2 = 0;
        if (bl) {
            if (object != null && object != Boolean.TRUE) {
                assert (object.getClass() == Integer.class);
                int n3 = (Integer)object;
                assert (!bitSet.get(n3));
                bitSet.set(n3);
                ++n2;
            }
            bitSet.set(n);
            map.put(string, Boolean.TRUE);
            ++n2;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    String getParamTypeId(TypeMirror typeMirror) {
        String string;
        String string2;
        block23: {
            if (typeMirror == null) {
                throw new IllegalArgumentException("null");
            }
            TypeKind typeKind = typeMirror.getKind();
            if (typeKind != TypeKind.DECLARED && typeKind != TypeKind.ARRAY) {
                if (typeKind.isPrimitive()) {
                    return ((Object)typeMirror).toString();
                }
                switch (typeKind) {
                    case ERROR: {
                        return "ErrorType";
                    }
                    case NONE: {
                        assert (false);
                        return "NoType";
                    }
                    case VOID: {
                        assert (false);
                        return "VoidType";
                    }
                    case NULL: {
                        assert (false);
                        return "NullType";
                    }
                    case EXECUTABLE: 
                    case PACKAGE: 
                    case TYPEVAR: 
                    case WILDCARD: {
                        assert (false);
                        return null;
                    }
                }
                return "UnknownType";
            }
            if (typeKind == TypeKind.ARRAY) {
                TypeKind typeKind2;
                int n = 0;
                StringBuilder stringBuilder = new StringBuilder(20);
                TypeMirror typeMirror2 = typeMirror;
                do {
                    ++n;
                    stringBuilder.append('[');
                } while ((typeKind2 = (typeMirror2 = ((ArrayType)typeMirror2).getComponentType()).getKind()) == TypeKind.ARRAY);
                if (typeKind2 == TypeKind.DECLARED) {
                    string2 = stringBuilder.append(this.getTypeFullName(typeMirror2)).toString();
                    break block23;
                } else {
                    if (!typeKind2.isPrimitive()) {
                        return this.getParamTypeId(typeMirror2);
                    }
                    StringBuilder stringBuilder2 = new StringBuilder(17);
                    stringBuilder2.append(((Object)typeMirror2).toString());
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return stringBuilder2.toString();
                        }
                        stringBuilder2.append(ARRAY_SUFFIX);
                        ++n2;
                    }
                }
            }
            assert (typeKind == TypeKind.DECLARED);
            string2 = this.getTypeFullName(typeMirror);
        }
        if ((string = this.qualNameToId.get(string2)) == null) {
            throw new IllegalArgumentException("unknown type");
        }
        return string;
    }

    private String getTypeFullName(TypeMirror typeMirror) {
        assert (typeMirror.getKind() == TypeKind.DECLARED);
        DeclaredType declaredType = (DeclaredType)this.types.erasure(typeMirror);
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        return this.elements.getBinaryName(typeElement).toString();
    }

    private static String getTypeBriefName(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? string : string.substring(n + 1);
        int n2 = string2.lastIndexOf(36);
        if (n2 != -1) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            do {
                stringBuilder.deleteCharAt(n2);
            } while ((n2 = string2.lastIndexOf(36, n2 - 1)) != -1);
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    private static String getLongerTypeId(String string, String string2) {
        int n;
        if (string.charAt(0) == '[') {
            n = 0;
            while (string.charAt(++n) == '[') {
            }
            string = string.substring(n);
        }
        if ((n = string.lastIndexOf(46)) == -1) {
            return string2;
        }
        String string3 = string.substring(0, n);
        StringBuilder stringBuilder = new StringBuilder(10);
        int n2 = -1;
        do {
            int n3 = n2 + 1;
            stringBuilder.append(string3.charAt(n3));
            n2 = string3.indexOf(46, n3);
            assert (n2 != n3);
        } while (n2 != -1);
        return stringBuilder.append(string2).toString();
    }
}

