/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.TestsuiteNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RootNodeChildren
extends Children.Array {
    private volatile boolean filtered;
    private Collection<Report> reports;
    private volatile int passedSuites;
    private volatile int failedSuites;
    private volatile boolean live = false;
    private String runningSuiteName;
    private TestsuiteNode runningSuiteNode;

    RootNodeChildren(boolean bl) {
        this.filtered = bl;
    }

    void displaySuiteRunning(String string) {
        assert (EventQueue.isDispatchThread());
        assert (this.runningSuiteName == null);
        assert (this.runningSuiteNode == null);
        this.runningSuiteName = string;
        if (this.live) {
            this.runningSuiteNode = new TestsuiteNode(string, this.filtered);
            this.add(new Node[]{this.runningSuiteNode});
        }
        assert (this.runningSuiteName != null);
        assert (this.runningSuiteNode != null == this.live);
    }

    TestsuiteNode displayReport(Report report) {
        TestsuiteNode testsuiteNode;
        assert (EventQueue.isDispatchThread());
        assert (this.runningSuiteNode != null == (this.live && this.runningSuiteName != null));
        if (this.reports == null) {
            this.reports = new ArrayList<Report>(10);
        }
        this.reports.add(report);
        boolean bl = this.updateStatistics(report);
        if (this.runningSuiteName != null) {
            this.runningSuiteName = null;
            if (this.live) {
                if (this.filtered && bl) {
                    this.remove(new Node[]{this.runningSuiteNode});
                    testsuiteNode = null;
                } else {
                    this.runningSuiteNode.displayReport(report);
                    testsuiteNode = this.runningSuiteNode;
                }
                this.runningSuiteNode = null;
            } else {
                testsuiteNode = null;
            }
        } else if (!(!this.live || this.filtered && bl)) {
            Node[] nodeArray = new Node[1];
            testsuiteNode = this.createNode(report);
            nodeArray[0] = testsuiteNode;
            this.add(nodeArray);
        } else {
            testsuiteNode = null;
        }
        assert (this.runningSuiteName == null);
        assert (this.runningSuiteNode == null);
        return testsuiteNode;
    }

    void displayReports(Collection<Report> collection) {
        assert (EventQueue.isDispatchThread());
        if (this.reports == null) {
            this.reports = new ArrayList<Report>(collection);
        } else {
            this.reports.addAll(collection);
        }
        if (!this.live) {
            for (Report report : this.reports) {
                this.updateStatistics(report);
            }
        } else if (!this.filtered) {
            Node[] nodeArray = new Node[collection.size()];
            int n = 0;
            for (Report report : collection) {
                this.updateStatistics(report);
                nodeArray[n++] = this.createNode(report);
            }
            this.add(nodeArray);
        } else {
            ArrayList<TestsuiteNode> arrayList = new ArrayList<TestsuiteNode>(collection.size());
            for (Report report : collection) {
                boolean bl = this.updateStatistics(report);
                if (!bl) continue;
                arrayList.add(this.createNode(report));
            }
            if (!arrayList.isEmpty()) {
                Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
                this.add(nodeArray);
            }
        }
    }

    private boolean updateStatistics(Report report) {
        boolean bl;
        boolean bl2 = bl = !report.containsFailed();
        if (bl) {
            ++this.passedSuites;
        } else {
            ++this.failedSuites;
        }
        return bl;
    }

    protected void addNotify() {
        super.addNotify();
        this.live = true;
        this.addAllMatchingNodes();
    }

    protected void removeNotify() {
        super.removeNotify();
        this.live = false;
    }

    private void addAllMatchingNodes() {
        int n;
        boolean bl = this.filtered;
        int n2 = bl ? this.failedSuites : this.failedSuites + this.passedSuites;
        int n3 = n = this.runningSuiteNode != null ? n2 + 1 : n2;
        if (n != 0) {
            Node[] nodeArray = new Node[n];
            Iterator<Report> iterator = this.reports.iterator();
            int n4 = 0;
            while (n4 < n2) {
                Report report = iterator.next();
                if (bl && !report.containsFailed()) continue;
                nodeArray[n4++] = this.createNode(report);
            }
            if (this.runningSuiteNode != null) {
                nodeArray[n4++] = this.runningSuiteNode;
            }
            this.add(nodeArray);
        }
    }

    private void removeAllNodes() {
        this.remove(this.getNodes());
    }

    private TestsuiteNode createNode(Report report) {
        return new TestsuiteNode(report, this.filtered);
    }

    void setFiltered(boolean bl) {
        assert (EventQueue.isDispatchThread());
        if (bl == this.filtered) {
            return;
        }
        this.filtered = bl;
        if (!this.live) {
            return;
        }
        if (this.passedSuites == 0) {
            return;
        }
        if (bl) {
            this.removePassedSuites();
        } else {
            this.addPassedSuites();
        }
    }

    private void removePassedSuites() {
        assert (EventQueue.isDispatchThread());
        assert (this.live);
        Node[] nodeArray = new Node[this.passedSuites];
        Node[] nodeArray2 = this.getNodes();
        int n = 0;
        int n2 = 0;
        while (n2 < nodeArray.length) {
            TestsuiteNode testsuiteNode = (TestsuiteNode)nodeArray2[n];
            Report report = testsuiteNode.getReport();
            if (report != null) {
                if (!report.containsFailed()) {
                    nodeArray[n2++] = testsuiteNode;
                } else {
                    testsuiteNode.setFiltered(this.filtered);
                }
            }
            ++n;
        }
        while (n < nodeArray2.length) {
            Report report;
            assert ((report = ((TestsuiteNode)nodeArray2[n]).getReport()) == null || report.containsFailed());
            ((TestsuiteNode)nodeArray2[n++]).setFiltered(this.filtered);
        }
        this.remove(nodeArray);
    }

    private void addPassedSuites() {
        assert (EventQueue.isDispatchThread());
        assert (this.live);
        this.removeAllNodes();
        this.addAllMatchingNodes();
    }
}

