/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.IOException;
import java.io.Reader;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.TroubleParser;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class XmlOutputParser
extends DefaultHandler {
    private static final int STATE_OUT_OF_SCOPE = 1;
    private static final int STATE_TESTSUITE = 2;
    private static final int STATE_PROPERTIES = 3;
    private static final int STATE_PROPERTY = 4;
    private static final int STATE_TESTCASE = 8;
    private static final int STATE_FAILURE = 12;
    private static final int STATE_ERROR = 13;
    private static final int STATE_OUTPUT_STD = 16;
    private static final int STATE_OUTPUT_ERR = 17;
    private int state = 1;
    int unknownElemNestLevel = 0;
    private final XMLReader xmlReader = XMLUtil.createXMLReader();
    private Report report;
    private Report.Testcase testcase;
    private Report.Trouble trouble;
    private StringBuffer charactersBuf;
    private final RegexpUtils regexp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Report parseXmlOutput(Reader reader) throws SAXException, IOException {
        XmlOutputParser xmlOutputParser = new XmlOutputParser();
        try {
            xmlOutputParser.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException sAXException) {
            String string = sAXException.getMessage();
            int n = 1;
            if (string != null && ErrorManager.getDefault().isLoggable(n)) {
                ErrorManager.getDefault().log(n, "Exception while parsing XML output from JUnit: " + string);
            }
            throw sAXException;
        }
        catch (IOException iOException) {
            assert (false);
        }
        finally {
            reader.close();
        }
        return xmlOutputParser.report;
    }

    private XmlOutputParser() throws SAXException {
        this.xmlReader.setContentHandler(this);
        this.regexp = RegexpUtils.getInstance();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 3: {
                if (string3.equals("property")) {
                    this.state = 4;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 2: {
                if (string3.equals("testcase")) {
                    this.testcase = this.createTestcaseReport(attributes.getValue("classname"), attributes.getValue("name"), attributes.getValue("time"));
                    this.state = 8;
                    break;
                }
                if (string3.equals("system-out")) {
                    this.state = 16;
                    break;
                }
                if (string3.equals("system-err")) {
                    this.state = 17;
                    break;
                }
                if (string3.equals("properties")) {
                    this.state = 3;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 8: {
                if (string3.equals("failure")) {
                    this.state = 12;
                } else if (string3.equals("error")) {
                    this.state = 13;
                } else {
                    this.startUnknownElem();
                }
                if (this.state < 0) break;
                assert (this.testcase != null);
                this.trouble = new Report.Trouble(this.state == 13);
                String string4 = attributes.getValue("type");
                if (string4 != null) {
                    this.trouble.exceptionClsName = string4;
                }
                if ((string4 = attributes.getValue("message")) != null) {
                    this.trouble.message = string4;
                }
                if (this.trouble.isFakeError()) {
                    this.trouble.error = false;
                    --this.report.errors;
                    ++this.report.failures;
                }
                if (!this.trouble.isComparisonFailure() || this.trouble.message == null || !this.trouble.message.startsWith("null expected:")) break;
                this.trouble.message = this.trouble.message.substring(5);
                break;
            }
            case 1: {
                if (string3.equals("testsuite")) {
                    this.report = this.createReport(attributes.getValue("name"), attributes.getValue("tests"), attributes.getValue("failures"), attributes.getValue("errors"), attributes.getValue("time"));
                    this.state = 2;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                this.startUnknownElem();
                break;
            }
            default: {
                assert (this.state < 0);
                ++this.unknownElemNestLevel;
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (this.state) {
            case 3: {
                assert (string3.equals("properties"));
                this.state = 2;
                break;
            }
            case 2: {
                assert (string3.equals("testsuite"));
                this.state = 1;
                break;
            }
            case 8: {
                assert (string3.equals("testcase"));
                assert (this.testcase != null);
                this.report.reportTest(this.testcase, Report.InfoSource.XML_FILE);
                this.testcase = null;
                this.state = 2;
                break;
            }
            case 1: {
                assert (false);
                break;
            }
            case 4: {
                assert (string3.equals("property"));
                this.state = 3;
                break;
            }
            case 12: 
            case 13: {
                assert (this.state == 12 && string3.equals("failure") || this.state == 13 && string3.equals("error"));
                assert (this.testcase != null);
                assert (this.trouble != null);
                if (this.charactersBuf != null) {
                    this.parseTroubleReport(this.charactersBuf.toString(), this.trouble);
                    this.charactersBuf = null;
                }
                this.testcase.trouble = this.trouble;
                this.trouble = null;
                this.state = 8;
                break;
            }
            case 16: 
            case 17: {
                assert (this.state == 16 && string3.equals("system-out") || this.state == 17 && string3.equals("system-err"));
                if (this.charactersBuf != null) {
                    String[] stringArray = this.getOutput(this.charactersBuf.toString());
                    if (this.state == 16) {
                        this.report.outputStd = stringArray;
                    } else {
                        this.report.outputErr = stringArray;
                    }
                    this.charactersBuf = null;
                }
                this.state = 2;
                break;
            }
            default: {
                assert (this.state < 0);
                if (--this.unknownElemNestLevel != 0) break;
                this.state = -this.state;
            }
        }
    }

    private void startUnknownElem() {
        this.state = -this.state;
        ++this.unknownElemNestLevel;
    }

    private Report createReport(String string, String string2, String string3, String string4, String string5) {
        int n;
        if (string == null) {
            string = NbBundle.getMessage(XmlOutputParser.class, (String)"UNNKOWN_NAME");
        }
        String[] stringArray = new String[]{string2, string3, string4};
        int[] nArray = new int[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            boolean bl;
            String string6 = stringArray[n];
            if (string6 == null) {
                bl = false;
            } else {
                try {
                    nArray[n] = Integer.parseInt(stringArray[n]);
                    bl = nArray[n] >= 0;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = false;
                }
            }
            if (bl) continue;
            nArray[n] = -1;
        }
        n = this.regexp.parseTimeMillisNoNFE(string5);
        Report report = new Report(string);
        report.totalTests = nArray[0];
        report.failures = nArray[1];
        report.errors = nArray[2];
        report.elapsedTimeMillis = n;
        return report;
    }

    private Report.Testcase createTestcaseReport(String string, String string2, String string3) {
        Report.Testcase testcase = new Report.Testcase();
        testcase.className = string;
        testcase.name = string2;
        testcase.timeMillis = this.regexp.parseTimeMillisNoNFE(string3);
        return testcase;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        switch (this.state) {
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                if (this.charactersBuf == null) {
                    this.charactersBuf = new StringBuffer(512);
                }
                this.charactersBuf.append(cArray, n, n2);
            }
        }
    }

    private void parseTroubleReport(String string, Report.Trouble trouble) {
        String[] stringArray = string.split("[\\r\\n]+");
        TroubleParser troubleParser = new TroubleParser(trouble, this.regexp);
        for (String string2 : stringArray) {
            if (!troubleParser.processMessage(string2)) continue;
            return;
        }
        troubleParser.finishProcessing();
    }

    private String[] getOutput(String string) {
        String[] stringArray = string.split("(?:\\r|\\r\\n|\\n)");
        if (stringArray.length >= 1 && stringArray[stringArray.length - 1].length() == 0) {
            String[] stringArray2 = stringArray;
            if ((stringArray = new String[stringArray.length - 1]).length > 0) {
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray.length);
            }
        }
        return stringArray;
    }
}

