/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Dimension;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.openide.util.WeakListeners;

public final class CompletionSettings
implements PreferenceChangeListener {
    private static final Logger LOG = Logger.getLogger(CompletionSettings.class.getName());
    private static final Set<String> MANAGED_SETTINGS = new HashSet<String>(Arrays.asList("completion-auto-popup", "completion-auto-popup-delay", "completion-pane-max-size", "completion-instant-substitution", "javadoc-auto-popup", "javadoc-auto-popup-delay", "javadoc-preferred-size"));
    private static Reference<CompletionSettings> ref = null;
    private Preferences preferences = null;
    private PreferenceChangeListener weakListener = null;
    private boolean completionAutoPopup;
    private int completionAutoPopupDelay;
    private Dimension completionPaneMaxSize;
    private boolean completionInstantSubstitution;
    private boolean docsAutoPopup;
    private int docsAutoPopupDelay;
    private Dimension docsPreferredSize;

    public static synchronized CompletionSettings getInstance() {
        CompletionSettings completionSettings;
        CompletionSettings completionSettings2 = completionSettings = ref == null ? null : ref.get();
        if (completionSettings == null) {
            completionSettings = new CompletionSettings();
            ref = new SoftReference<CompletionSettings>(completionSettings);
        }
        return completionSettings;
    }

    public boolean completionAutoPopup() {
        this.initialize();
        return this.completionAutoPopup;
    }

    public int completionAutoPopupDelay() {
        this.initialize();
        return this.completionAutoPopupDelay;
    }

    public boolean documentationAutoPopup() {
        this.initialize();
        return this.docsAutoPopup;
    }

    public int documentationAutoPopupDelay() {
        this.initialize();
        return this.docsAutoPopupDelay;
    }

    public Dimension completionPaneMaximumSize() {
        this.initialize();
        return this.completionPaneMaxSize;
    }

    public Dimension documentationPopupPreferredSize() {
        this.initialize();
        return this.docsPreferredSize;
    }

    public boolean completionInstantSubstitution() {
        this.initialize();
        return this.completionInstantSubstitution;
    }

    public synchronized void notifyEditorComponentChange(JTextComponent jTextComponent) {
        if (this.preferences != null) {
            assert (this.weakListener != null);
            this.preferences.removePreferenceChangeListener(this.weakListener);
            this.preferences = null;
            this.weakListener = null;
        }
        if (jTextComponent != null) {
            String string = DocumentUtilities.getMimeType((JTextComponent)jTextComponent);
            Preferences preferences = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
            this.read(preferences);
            this.preferences = preferences;
            this.weakListener = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.preferences);
            this.preferences.addPreferenceChangeListener(this.weakListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        String string;
        String string2 = string = preferenceChangeEvent != null ? preferenceChangeEvent.getKey() : null;
        if (string == null || MANAGED_SETTINGS.contains(string)) {
            CompletionSettings completionSettings = this;
            synchronized (completionSettings) {
                if (this.preferences != null) {
                    this.read(this.preferences);
                }
            }
        }
    }

    private CompletionSettings() {
    }

    private synchronized void initialize() {
        if (this.preferences == null) {
            Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
            this.read(preferences);
            this.preferences = preferences;
            this.weakListener = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.preferences);
            this.preferences.addPreferenceChangeListener(this.weakListener);
        }
    }

    private void read(Preferences preferences) {
        this.completionAutoPopup = preferences.getBoolean("completion-auto-popup", true);
        this.completionAutoPopupDelay = preferences.getInt("completion-auto-popup-delay", 250);
        this.completionPaneMaxSize = CompletionSettings.parseDimension(preferences.get("completion-pane-max-size", null), new Dimension(400, 300));
        this.completionInstantSubstitution = preferences.getBoolean("completion-instant-substitution", true);
        this.docsAutoPopup = preferences.getBoolean("javadoc-auto-popup", true);
        this.docsAutoPopupDelay = preferences.getInt("javadoc-auto-popup-delay", 200);
        this.docsPreferredSize = CompletionSettings.parseDimension(preferences.get("javadoc-preferred-size", null), new Dimension(500, 300));
    }

    private static Dimension parseDimension(String string, Dimension dimension) {
        int[] nArray = new int[2];
        int n = 0;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                if (n > 1) {
                    return dimension;
                }
                try {
                    nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.log(Level.WARNING, null, numberFormatException);
                    return dimension;
                }
                ++n;
            }
        }
        if (n != 2) {
            return dimension;
        }
        return new Dimension(nArray[0], nArray[1]);
    }
}

