/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DataSerializer;
import org.netbeans.modules.vmd.api.io.ProjectTypeInfo;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentSave {
    static final Lookup.Result<DataSerializer> customDataSerializers = Lookup.getDefault().lookupResult(DataSerializer.class);
    static final String XML_ROOT_NODE = "VisualDesign";
    static final String PROP_PROJECT_TYPE = "projectType";
    static final String DOCUMENT_NODE = "Document";
    static final String VERSION_ATTR = "version";
    static final String COMPONENT_NODE = "Component";
    static final String PROPERTY_NODE = "Property";
    static final String COMPONENTID_ATTR = "componentID";
    static final String TYPEID_ATTR = "typeID";
    static final String NAME_ATTR = "name";
    static final String VALUE_ATTR = "value";
    static final String VERSION_VALUE_1 = "1";
    static Object sync = new Object();

    public static void save(DataObjectContext dataObjectContext, DesignDocument designDocument) {
        Document document = XMLUtil.createDocument((String)XML_ROOT_NODE, null, null, null);
        Node node = document.getFirstChild();
        DocumentSave.setAttribute(document, node, VERSION_ATTR, VERSION_VALUE_1);
        String string = designDocument.getDocumentInterface().getProjectType();
        DocumentSave.setAttribute(document, node, PROP_PROJECT_TYPE, string);
        Element element = document.createElement(DOCUMENT_NODE);
        DocumentSave.setAttribute(document, element, VERSION_ATTR, ProjectTypeInfo.getProjectTypeInfoFor(string).getDocumentVersion());
        DocumentSave.checkDocumentValidity(designDocument);
        DocumentSave.saveComponent(document, element, designDocument.getRootComponent());
        node.appendChild(element);
        for (DataSerializer dataSerializer : customDataSerializers.allInstances()) {
            Node node2 = dataSerializer.serializeData(dataObjectContext, designDocument, document);
            if (node2 == null) continue;
            document.getFirstChild().appendChild(node2);
        }
        try {
            DocumentSave.writeDocument(IOSupport.getDesignFile(dataObjectContext), document);
        }
        catch (IOException iOException) {
            throw Debug.error((Object[])new Object[]{iOException});
        }
    }

    private static void checkDocumentValidity(DesignDocument designDocument) {
        HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>();
        HashSet<DesignComponent> hashSet2 = new HashSet<DesignComponent>();
        DocumentSave.collectComponentsInTree(hashSet, designDocument.getRootComponent());
        for (DesignComponent designComponent : hashSet) {
            DocumentSave.collectUsedReferences(hashSet2, designComponent);
        }
        for (DesignComponent designComponent : hashSet2) {
            if (hashSet.contains(designComponent)) continue;
            Debug.warning((Object[])new Object[]{"Saving", "Referenced component is not in the tree", designComponent});
        }
    }

    private static void saveComponent(Document document, Node node, DesignComponent designComponent) {
        ComponentDescriptor componentDescriptor = designComponent.getComponentDescriptor();
        Element element = document.createElement(COMPONENT_NODE);
        node.appendChild(element);
        DocumentSave.setAttribute(document, element, COMPONENTID_ATTR, Long.toString(designComponent.getComponentID()));
        DocumentSave.setAttribute(document, element, TYPEID_ATTR, designComponent.getType().getEncoded());
        Collection collection = componentDescriptor.getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : collection) {
            String string;
            if (!propertyDescriptor.isUseForSerialization() || designComponent.isDefaultValue(string = propertyDescriptor.getName())) continue;
            PropertyValue propertyValue = designComponent.readProperty(string);
            String string2 = propertyValue.serialize();
            Element element2 = document.createElement(PROPERTY_NODE);
            element.appendChild(element2);
            DocumentSave.setAttribute(document, element2, NAME_ATTR, propertyDescriptor.getName());
            DocumentSave.setAttribute(document, element2, TYPEID_ATTR, propertyDescriptor.getType().getEncoded());
            DocumentSave.setAttribute(document, element2, VALUE_ATTR, string2);
        }
        for (PropertyDescriptor propertyDescriptor : designComponent.getComponents()) {
            DocumentSave.saveComponent(document, element, (DesignComponent)propertyDescriptor);
        }
    }

    private static void collectComponentsInTree(HashSet<DesignComponent> hashSet, DesignComponent designComponent) {
        hashSet.add(designComponent);
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            DocumentSave.collectComponentsInTree(hashSet, designComponent2);
        }
    }

    private static void collectUsedReferences(HashSet<DesignComponent> hashSet, DesignComponent designComponent) {
        ComponentDescriptor componentDescriptor = designComponent.getComponentDescriptor();
        Collection collection = componentDescriptor.getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : collection) {
            if (!propertyDescriptor.isUseForSerialization()) continue;
            PropertyValue propertyValue = designComponent.readProperty(propertyDescriptor.getName());
            Debug.collectAllComponentReferences((PropertyValue)propertyValue, hashSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDocument(final FileObject fileObject, final Document document) throws IOException {
        Object object = sync;
        synchronized (object) {
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream outputStream = null;
                    FileLock fileLock = null;
                    try {
                        fileLock = fileObject.lock();
                        outputStream = fileObject.getOutputStream(fileLock);
                        XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
            });
        }
    }

    private static void setAttribute(Document document, Node node, String string, String string2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Attr attr = document.createAttribute(string);
        attr.setValue(string2);
        namedNodeMap.setNamedItem(attr);
    }
}

