/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io.editor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.io.editor.CodeEditorTopComponent;
import org.netbeans.modules.vmd.io.editor.DataEditorViewLookupFactoryRegistry;
import org.netbeans.modules.vmd.io.editor.EditorTopComponent;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class EditorViewElement
implements MultiViewElement,
Serializable {
    private static final long serialVersionUID = -1L;
    private static final String CLOSING_ID = "ID_JAVA_CLOSING";
    private DataObjectContext context;
    private DataEditorView view;
    private transient DataEditorView.Kind kind;
    private transient Lookup lookup;
    private transient EditorTopComponent topComponent;
    private transient MultiViewElementCallback callback;

    public EditorViewElement() {
    }

    public EditorViewElement(DataObjectContext dataObjectContext, DataEditorView dataEditorView) {
        this.context = dataObjectContext;
        this.view = dataEditorView;
        this.init();
    }

    private void init() {
        this.kind = this.view.getKind();
        ArrayList<Object> arrayList = DataEditorViewLookupFactoryRegistry.getLookupObjects(this.context, this.view);
        ArrayList<Lookup> arrayList2 = DataEditorViewLookupFactoryRegistry.getLookups(this.context, this.view);
        arrayList.add(this.view);
        arrayList2.add(Lookups.fixed((Object[])arrayList.toArray()));
        this.lookup = new ProxyLookup(arrayList2.toArray(new Lookup[arrayList2.size()]));
        IOSupport.getDocumentSerializer(this.context.getDataObject()).startLoadingDocument();
    }

    public JComponent getVisualRepresentation() {
        JComponent jComponent;
        if (this.topComponent == null && (jComponent = this.view.getVisualRepresentation()) != null) {
            this.topComponent = this.kind == DataEditorView.Kind.CODE ? new CodeEditorTopComponent(this.context, this.lookup, jComponent) : new EditorTopComponent(this.context, this.lookup, jComponent);
        }
        return this.topComponent;
    }

    public JComponent getToolbarRepresentation() {
        return this.view.getToolbarRepresentation();
    }

    public Action[] getActions() {
        return this.callback != null ? this.callback.createDefaultActions() : new Action[]{};
    }

    public Lookup getLookup() {
        this.getVisualRepresentation();
        return this.topComponent.getLookup();
    }

    public void componentOpened() {
        this.view.componentOpened();
    }

    public void componentClosed() {
        this.view.componentClosed();
    }

    public void componentShowing() {
        this.view.componentShowing();
    }

    public void componentHidden() {
        this.view.componentHidden();
    }

    public void componentActivated() {
        IOSupport.notifyDataEditorViewActivated(this.view);
        this.view.componentActivated();
    }

    public void componentDeactivated() {
        this.view.componentDeactivated();
    }

    public UndoRedo getUndoRedo() {
        UndoRedo undoRedo = this.view.getUndoRedo();
        if (undoRedo != null) {
            return undoRedo;
        }
        if (this.kind != DataEditorView.Kind.MODEL) {
            return null;
        }
        return IOSupport.getDocumentSerializer(this.context.getDataObject()).getUndoRedoManager();
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.callback = multiViewElementCallback;
        IOSupport.getDataObjectInteface(this.context.getDataObject()).setMVTC(multiViewElementCallback.getTopComponent());
    }

    public CloseOperationState canCloseElement() {
        return MultiViewFactory.createUnsafeCloseState((String)CLOSING_ID, null, null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.context);
        objectOutputStream.writeObject(this.view);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = objectInputStream.readObject();
        if (!(object instanceof DataObjectContext)) {
            throw new ClassNotFoundException("DataObjectContext expected but not found");
        }
        this.context = (DataObjectContext)object;
        object = objectInputStream.readObject();
        if (!(object instanceof DataEditorView)) {
            throw new ClassNotFoundException("DataEditorView expected but not found");
        }
        this.view = (DataEditorView)object;
        this.init();
    }
}

