/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.hierarchy;

import java.util.Iterator;
import javax.swing.JEditorPane;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;

public class ContextUtils {
    public static final boolean USE_REFERENCE_RESOLVER = ContextUtils.getBoolean("hierarchy.use.reference", true);

    private ContextUtils() {
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public static CsmFile findFile(Node[] nodeArray) {
        if (nodeArray != null && nodeArray.length > 0) {
            CsmInclude csmInclude;
            CsmFile csmFile;
            CsmReference csmReference;
            if (USE_REFERENCE_RESOLVER && (csmReference = ContextUtils.findReference(nodeArray[0])) != null && CsmKindUtilities.isInclude((CsmObject)csmReference.getOwner()) && (csmFile = (csmInclude = (CsmInclude)csmReference.getOwner()).getIncludeFile()) != null) {
                return csmFile;
            }
            return ContextUtils.findFile(nodeArray[0]);
        }
        return null;
    }

    public static CsmFile findFile(Node node) {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            return CsmUtilities.getCsmFile((Node)node, (boolean)false);
        }
        return null;
    }

    public static CsmClass getContextClass(Node[] nodeArray) {
        CsmReference csmReference;
        CsmDeclaration csmDeclaration = null;
        if (USE_REFERENCE_RESOLVER && ContextUtils.isSupportedReference(csmReference = ContextUtils.findReference(nodeArray[0]))) {
            CsmVariable csmVariable;
            CsmClassifier csmClassifier;
            csmDeclaration = csmReference.getReferencedObject();
            if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
                return (CsmClass)csmDeclaration;
            }
            if (CsmKindUtilities.isVariable((CsmObject)csmDeclaration) && CsmKindUtilities.isClass((CsmObject)(csmClassifier = (csmVariable = (CsmVariable)csmDeclaration).getType().getClassifier()))) {
                return (CsmClass)csmClassifier;
            }
        }
        if (CsmKindUtilities.isClass((CsmObject)(csmDeclaration = ContextUtils.findDeclaration(nodeArray[0])))) {
            return (CsmClass)csmDeclaration;
        }
        return null;
    }

    public static boolean isSupportedReference(CsmReference csmReference) {
        return csmReference != null && !CsmKindUtilities.isMacro((CsmObject)csmReference.getOwner()) && !CsmKindUtilities.isInclude((CsmObject)csmReference.getOwner());
    }

    public static CsmReference findReference(Node node) {
        return CsmReferenceResolver.getDefault().findReference(node);
    }

    public static CsmDeclaration findDeclaration(Node node) {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            int n = jEditorPaneArray[0].getCaret().getDot();
            CsmFile csmFile = CsmUtilities.getCsmFile((Node)node, (boolean)false);
            if (csmFile != null) {
                return ContextUtils.findInnerFileDeclaration(csmFile, n);
            }
        }
        return null;
    }

    private static CsmDeclaration findInnerFileDeclaration(CsmFile csmFile, int n) {
        CsmDeclaration csmDeclaration = null;
        for (CsmDeclaration csmDeclaration2 : csmFile.getDeclarations()) {
            if (!ContextUtils.isInObject((CsmObject)csmDeclaration2, n)) continue;
            csmDeclaration = ContextUtils.findInnerDeclaration(csmDeclaration2, n);
            csmDeclaration = csmDeclaration != null ? csmDeclaration : csmDeclaration2;
            break;
        }
        return csmDeclaration;
    }

    private static CsmDeclaration findInnerDeclaration(CsmDeclaration csmDeclaration, int n) {
        CsmClass csmClass;
        Iterator iterator = null;
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmDeclaration)) {
            iterator = ((CsmNamespaceDefinition)csmDeclaration).getDeclarations().iterator();
        } else if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
            csmClass = (CsmClass)csmDeclaration;
            iterator = csmClass.getMembers().iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                csmClass = (CsmDeclaration)iterator.next();
                if (!ContextUtils.isInObject((CsmObject)csmClass, n)) continue;
                CsmDeclaration csmDeclaration2 = ContextUtils.findInnerDeclaration((CsmDeclaration)csmClass, n);
                if (CsmKindUtilities.isClass((CsmObject)csmDeclaration2)) {
                    return csmDeclaration2;
                }
                if (!CsmKindUtilities.isClass((CsmObject)csmClass)) break;
                return csmClass;
            }
        }
        return null;
    }

    private static boolean isInObject(CsmObject csmObject, int n) {
        if (!CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return false;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return csmOffsetable.getStartOffset() <= n && n <= csmOffsetable.getEndOffset();
    }
}

