/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector;

import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.inspector.InspectorManagerView;
import org.netbeans.modules.vmd.inspector.InspectorWrapperTree;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InspectorRegistry {
    private static WeakHashMap<DesignDocument, InspectorRegistry> registryMap;
    private WeakSet<DesignComponent> components = new WeakSet();

    public static InspectorRegistry getInstance(DesignDocument designDocument) {
        if (registryMap == null) {
            registryMap = new WeakHashMap();
        }
        if (registryMap.get(designDocument) == null) {
            registryMap.put(designDocument, new InspectorRegistry());
        }
        return registryMap.get(designDocument);
    }

    private InspectorRegistry() {
    }

    public void addComponent(DesignComponent designComponent) {
        this.components.add((Object)designComponent);
    }

    public Collection<DesignComponent> getComponentsToUpdate() {
        if (this.components == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableCollection(this.components);
    }

    public void cleanUpRegistry() {
        if (!Debug.isFriend(InspectorManagerView.class)) {
            throw new IllegalStateException("This method is only accessible from class InspectorWrapperTree");
        }
        if (this.components != null) {
            this.components.clear();
        }
    }

    public void remove(Collection<DesignComponent> collection) {
        if (!Debug.isFriend(InspectorWrapperTree.class)) {
            throw new IllegalStateException("This method is only accessible from class InspectorWrapperTree");
        }
        if (this.components != null && this.components.size() > 0 && collection != null && collection.size() == 0) {
            this.components.removeAll(collection);
        }
    }
}

