/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xslt.core.XSLTDataObject;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class XSLTDataLoader
extends UniFileLoader {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE = "application/xslt+xml";
    public static final String PRIMARY_EXTENSION = "xsl";
    public static final String PRIMARY_EXTENSION2 = "xslt";
    static final String TRANSFORM_MAP_FILE = "transformmap.xml";
    public static final String ACTION_CONTEXT = "Loaders/application/xslt+xml/Actions";
    static final String LOADER_NAME = "LBL_loader_name";

    public XSLTDataLoader() {
        super("org.netbeans.modules.xslt.core.XSLTDataObject");
    }

    protected void initialize() {
        super.initialize();
        this.getExtensions().addMimeType(MIME_TYPE);
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(XSLTDataLoader.class, (String)LOADER_NAME);
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new XSLTDataObject(fileObject, (MultiFileLoader)this);
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        FileObject fileObject2 = null;
        String string = fileObject.getExt();
        if (string.equals(PRIMARY_EXTENSION) || string.equals(PRIMARY_EXTENSION2)) {
            fileObject2 = this.isXsltProjectContext(fileObject) ? fileObject : null;
        }
        return fileObject2;
    }

    private boolean isXsltProjectContext(FileObject fileObject) {
        boolean bl = false;
        try {
            String string;
            if (!fileObject.getFileSystem().isDefault() && !fileObject.isFolder() && ((string = fileObject.getExt()).equals(PRIMARY_EXTENSION) || string.equals(PRIMARY_EXTENSION2))) {
                FileObject fileObject2 = Util.getProjectSource((Project)Util.getProject((FileObject)fileObject));
                bl = fileObject2 != null && fileObject2.getFileObject(TRANSFORM_MAP_FILE) != null;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
        }
        return bl;
    }

    private boolean isEqualInputFile(String string, FileObject fileObject) {
        return string != null && fileObject != null && string.equals(fileObject.getNameExt());
    }

    private FileObject getTransformMapFo(FileObject fileObject) {
        return fileObject.getParent().getFileObject(TRANSFORM_MAP_FILE);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new FileEntry(multiDataObject, fileObject);
    }

    protected String actionsContext() {
        return ACTION_CONTEXT;
    }
}

