/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.text.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionResultItem;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionUtil;
import org.netbeans.modules.xslt.core.text.completion.XSLTEditorComponentHolder;
import org.netbeans.modules.xslt.core.text.completion.handler.HandlerAttributeEnumValues;
import org.netbeans.modules.xslt.core.text.completion.handler.HandlerCallTemplateName;
import org.netbeans.modules.xslt.core.text.completion.handler.HandlerCoreXPathFunctions;
import org.netbeans.modules.xslt.core.text.completion.handler.HandlerUseAttributeSets;
import org.netbeans.modules.xslt.core.text.completion.handler.HandlerWithParamName;
import org.netbeans.modules.xslt.core.text.completion.handler.XSLTCompletionHandler;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;

public class XSLTCompletionQuery
extends AsyncCompletionQuery
implements Runnable,
XSLTEditorComponentHolder {
    private static final List<XSLTCompletionHandler> xsltCompletionHandlers = new ArrayList<XSLTCompletionHandler>(Arrays.asList(new HandlerAttributeEnumValues(), new HandlerCallTemplateName(), new HandlerWithParamName(), new HandlerUseAttributeSets(), new HandlerCoreXPathFunctions()));
    private CompletionResultSet resultSet;
    private int caretOffset;
    private Document document;
    private JEditorPane srcEditorPane;

    protected void query(CompletionResultSet completionResultSet, Document document, int n) {
        this.resultSet = completionResultSet;
        this.document = document;
        this.caretOffset = n;
        StyledDocument styledDocument = (StyledDocument)document;
        styledDocument.render(this);
    }

    public void run() {
        this.makeResultSet();
    }

    private void makeResultSet() {
        if (this.resultSet == null || this.document == null || this.srcEditorPane == null || this.caretOffset < 0) {
            this.resultSet.finish();
            return;
        }
        for (XSLTCompletionHandler xSLTCompletionHandler : xsltCompletionHandlers) {
            List<XSLTCompletionResultItem> list = xSLTCompletionHandler.getResultItemList(this);
            if (list.isEmpty()) continue;
            this.resultSet.addAllItems(list);
            break;
        }
        this.resultSet.setAnchorOffset(this.caretOffset);
        this.resultSet.finish();
    }

    protected void prepareQuery(JTextComponent jTextComponent) {
        super.prepareQuery(jTextComponent);
        this.srcEditorPane = XSLTCompletionUtil.getXsltDataEditorSupport() == null ? null : (JEditorPane)jTextComponent;
    }

    public JEditorPane getSourceEditorComponent() {
        return this.srcEditorPane;
    }
}

