/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.actions;

import org.netbeans.modules.sun.manager.jbi.nodes.Shutdownable;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public abstract class ShutdownAction
extends NodeAction {
    protected void performAction(final Node[] nodeArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    for (Node node : nodeArray) {
                        Lookup lookup = node.getLookup();
                        Shutdownable shutdownable = (Shutdownable)lookup.lookup(Shutdownable.class);
                        if (shutdownable == null) continue;
                        shutdownable.shutdown(ShutdownAction.this.isForceAction());
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        });
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        if (nodeArray != null && nodeArray.length > 0) {
            bl = true;
            for (Node node : nodeArray) {
                Lookup lookup = node.getLookup();
                Shutdownable shutdownable = (Shutdownable)lookup.lookup(Shutdownable.class);
                try {
                    if (shutdownable == null || shutdownable.canShutdown(this.isForceAction())) continue;
                    bl = false;
                    break;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected abstract boolean isForceAction();

    public static class Force
    extends ShutdownAction {
        public String getName() {
            return NbBundle.getMessage(ShutdownAction.class, (String)"LBL_ForceShutdownAction");
        }

        protected boolean isForceAction() {
            return true;
        }
    }

    public static class Normal
    extends ShutdownAction {
        public String getName() {
            return NbBundle.getMessage(ShutdownAction.class, (String)"LBL_ShutdownAction");
        }

        protected boolean isForceAction() {
            return false;
        }
    }
}

