/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.actions;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.sun.manager.jbi.actions.ShutdownAction;
import org.netbeans.modules.sun.manager.jbi.nodes.Undeployable;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public abstract class UndeployAction
extends NodeAction {
    protected void performAction(final Node[] nodeArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    for (Node node : nodeArray) {
                        Lookup lookup = node.getLookup();
                        Undeployable undeployable = (Undeployable)lookup.lookup(Undeployable.class);
                        if (undeployable == null) continue;
                        undeployable.undeploy(UndeployAction.this.isForceAction());
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        });
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        if (nodeArray != null && nodeArray.length > 0) {
            bl = true;
            for (Node node : nodeArray) {
                Undeployable undeployable = (Undeployable)node.getLookup().lookup(Undeployable.class);
                try {
                    if (undeployable == null || undeployable.canUndeploy(this.isForceAction())) continue;
                    bl = false;
                    break;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected abstract boolean isForceAction();

    public static class Force
    extends UndeployAction
    implements Presenter.Popup {
        public String getName() {
            return NbBundle.getMessage(ShutdownAction.class, (String)"LBL_ForceUndeployAction");
        }

        public JMenuItem getPopupPresenter() {
            JMenu jMenu = new JMenu(NbBundle.getMessage(ShutdownAction.class, (String)"LBL_Advanced"));
            SystemAction systemAction = SystemAction.get(ShutdownAction.Force.class);
            JMenuItem jMenuItem = new JMenuItem();
            Actions.connect((JMenuItem)jMenuItem, (Action)systemAction, (boolean)false);
            jMenu.add(jMenuItem);
            SystemAction systemAction2 = SystemAction.get(Force.class);
            JMenuItem jMenuItem2 = new JMenuItem();
            Actions.connect((JMenuItem)jMenuItem2, (Action)systemAction2, (boolean)false);
            jMenu.add(jMenuItem2);
            return jMenu;
        }

        protected boolean isForceAction() {
            return true;
        }
    }

    public static class Normal
    extends UndeployAction {
        protected boolean isForceAction() {
            return false;
        }

        public String getName() {
            return NbBundle.getMessage(ShutdownAction.class, (String)"LBL_UndeployAction");
        }
    }
}

