/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.sun.manager.jbi.editors.SimpleTabularDataEditor;
import org.netbeans.modules.sun.manager.jbi.editors.TabularDataCellEditorFactory;
import org.netbeans.modules.sun.manager.jbi.editors.TabularDataCellRendererFactory;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTabularDataCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor,
ActionListener {
    private TableCellRenderer headerCellRenderer;
    private int indexColumnCount;
    private String[] columnNames;
    private String[] columnDescriptions;
    private OpenType[] columnTypes;
    private TabularType tabularType;
    private TabularData tabularData;
    private String tableLabelText;
    private String tableLabelDescription;
    protected JBIComponentConfigurationDescriptor descriptor;
    protected boolean isWritable = true;
    private JButton addButton;
    private JPanel buttonPanel;
    private JButton deleteAllButton;
    private JButton deleteButton;
    private JScrollPane jScrollPane1;
    private JLabel label;
    private JTable table;

    public SimpleTabularDataCustomEditor(TabularData tabularData, String string, String string2, JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor, boolean bl) {
        this.tableLabelText = string;
        this.tableLabelDescription = string2;
        this.tabularData = tabularData;
        this.tabularType = tabularData.getTabularType();
        this.descriptor = jBIComponentConfigurationDescriptor;
        this.isWritable = bl;
        this.init();
    }

    public SimpleTabularDataCustomEditor(SimpleTabularDataEditor simpleTabularDataEditor, String string, String string2, JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor, boolean bl) {
        this.tableLabelText = string;
        this.tableLabelDescription = string2;
        this.tabularData = (TabularData)simpleTabularDataEditor.getValue();
        this.tabularType = simpleTabularDataEditor.getTabluarType();
        this.descriptor = jBIComponentConfigurationDescriptor;
        this.isWritable = bl;
        this.init();
    }

    private void init() {
        this.initComponents();
        this.headerCellRenderer = this.createTableHeaderRenderer();
        DefaultTableModel defaultTableModel = this.initTableModel(this.tabularData);
        this.table = this.createTable(defaultTableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.table);
        this.configureTableColumns(this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = SimpleTabularDataCustomEditor.this.table.getSelectionModel().getMinSelectionIndex();
                    SimpleTabularDataCustomEditor.this.deleteButton.setEnabled(SimpleTabularDataCustomEditor.this.isWritable && n != -1);
                }
            }
        });
        this.addButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.deleteAllButton.addActionListener(this);
        this.addButton.setEnabled(this.isWritable);
        this.deleteButton.setEnabled(false);
        this.deleteAllButton.setEnabled(this.isWritable && defaultTableModel.getRowCount() > 0);
    }

    protected TableCellRenderer createTableHeaderRenderer() {
        return new TabularDataTableHeaderRenderer();
    }

    public TabularData getPropertyValue() throws IllegalStateException {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        TabularDataSupport tabularDataSupport = null;
        try {
            tabularDataSupport = new TabularDataSupport(this.tabularType);
            CompositeType compositeType = this.tabularType.getRowType();
            int n = 0;
            for (Vector vector : this.getDataVector()) {
                Object object;
                int n2;
                ArrayList<String> arrayList;
                Object[] objectArray = vector.toArray();
                if (this.descriptor != null) {
                    arrayList = new ArrayList<String>();
                    for (n2 = 0; n2 < objectArray.length; ++n2) {
                        object = objectArray[n2];
                        String string = this.columnNames[n2];
                        JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor = this.descriptor.getChild(string);
                        if (!jBIComponentConfigurationDescriptor.isRequired() || object != null && (!(object instanceof String) || ((String)object).length() != 0)) continue;
                        arrayList.add(jBIComponentConfigurationDescriptor.getDisplayName());
                    }
                    if (arrayList.size() > 0) {
                        String string = NbBundle.getMessage(SimpleTabularDataCustomEditor.class, (String)"MSG_REQUIRED_FIELD_IS_MISSING", (Object)(n + 1), arrayList);
                        throw new RuntimeException(string);
                    }
                }
                arrayList = new ArrayList();
                for (n2 = 0; n2 < this.indexColumnCount; ++n2) {
                    object = objectArray[n2];
                    if (objectArray != null && (!(object instanceof String) || ((String)object).length() != 0)) continue;
                    arrayList.add(this.columnNames[n2]);
                }
                if (arrayList.size() > 0) {
                    String string = NbBundle.getMessage(SimpleTabularDataCustomEditor.class, (String)"MSG_INDEX_FIELD_IS_MISSING", (Object)(n + 1), arrayList);
                    throw new RuntimeException(string);
                }
                CompositeDataSupport compositeDataSupport = new CompositeDataSupport(compositeType, this.columnNames, objectArray);
                tabularDataSupport.put(compositeDataSupport);
                ++n;
            }
        }
        catch (KeyAlreadyExistsException keyAlreadyExistsException) {
            List<String> list = Arrays.asList(this.columnNames).subList(0, this.indexColumnCount);
            String string = NbBundle.getMessage(SimpleTabularDataCustomEditor.class, (String)"MSG_TABULAR_DATA_KEY_ALREADY_EXISTS", list);
            throw new RuntimeException(string);
        }
        catch (OpenDataException openDataException) {
            openDataException.printStackTrace();
            throw new RuntimeException(openDataException.getMessage());
        }
        return tabularDataSupport;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(450, 250);
    }

    protected JTable createTable(DefaultTableModel defaultTableModel) {
        JTable jTable = new JTable(defaultTableModel){

            public Class getColumnClass(int n) {
                OpenType openType = SimpleTabularDataCustomEditor.this.columnTypes[n];
                String string = openType.getClassName();
                Class<Object> clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    clazz = String.class;
                }
                return clazz;
            }

            public TableCellEditor getCellEditor(int n, int n2) {
                if (!SimpleTabularDataCustomEditor.this.isWritable) {
                    return null;
                }
                Class clazz = this.getColumnClass(n2);
                return TabularDataCellEditorFactory.getEditor(clazz, SimpleTabularDataCustomEditor.this.descriptor, SimpleTabularDataCustomEditor.this.isWritable);
            }

            public TableCellRenderer getCellRenderer(int n, int n2) {
                Class clazz = this.getColumnClass(n2);
                return TabularDataCellRendererFactory.getRenderer(clazz);
            }
        };
        return jTable;
    }

    protected void configureTableColumns(JTable jTable) {
        for (int i = 0; i < this.columnNames.length; ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            tableColumn.setHeaderRenderer(this.headerCellRenderer);
        }
    }

    private DefaultTableModel initTableModel(TabularData tabularData) {
        if (this.tabularType == null) {
            this.tabularType = tabularData.getTabularType();
        }
        CompositeType compositeType = this.tabularType.getRowType();
        List<String> list = this.tabularType.getIndexNames();
        this.indexColumnCount = list.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list);
        for (String object2 : compositeType.keySet()) {
            if (list.contains(object2)) continue;
            arrayList.add(object2);
        }
        this.columnNames = arrayList.toArray(new String[0]);
        this.columnDescriptions = new String[this.columnNames.length];
        this.columnTypes = new OpenType[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            String string = this.columnNames[i];
            this.columnDescriptions[i] = compositeType.getDescription(string);
            this.columnTypes[i] = compositeType.getType(string);
        }
        Vector vector = new Vector();
        for (Object obj : tabularData.values()) {
            CompositeData compositeData = (CompositeData)obj;
            Vector<Object> vector2 = new Vector<Object>();
            for (String string : this.columnNames) {
                vector2.add(compositeData.get(string));
            }
            vector.add(vector2);
        }
        Vector<String> vector3 = new Vector<String>();
        for (int i = 0; i < this.columnNames.length; ++i) {
            vector3.addElement(this.columnNames[i]);
        }
        DefaultTableModel defaultTableModel = this.createTableModel();
        defaultTableModel.setDataVector(vector, vector3);
        return defaultTableModel;
    }

    protected DefaultTableModel createTableModel() {
        return new DefaultTableModel();
    }

    protected Vector createRow() {
        Vector<Object> vector = new Vector<Object>();
        CompositeType compositeType = this.tabularType.getRowType();
        for (int i = 0; i < this.columnNames.length; ++i) {
            String string = this.columnNames[i];
            OpenType<?> openType = compositeType.getType(string);
            if (openType.equals(SimpleType.STRING)) {
                vector.add("");
                continue;
            }
            if (openType.equals(SimpleType.INTEGER)) {
                vector.add(0);
                continue;
            }
            if (openType instanceof TabularType) {
                vector.add(new TabularDataSupport((TabularType)openType));
                continue;
            }
            System.out.println("Unknown type: " + openType);
            vector.add("");
        }
        return vector;
    }

    private Vector<Vector> getDataVector() {
        return ((DefaultTableModel)this.table.getModel()).getDataVector();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        Vector<Vector> vector = this.getDataVector();
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.addButton) {
            Vector vector2 = this.createRow();
            if (vector2 != null) {
                vector.addElement(vector2);
                this.table.addNotify();
                int n = vector.size() - 1;
                this.table.getSelectionModel().setSelectionInterval(n, n);
            }
        } else {
            if (jButton == this.deleteButton) {
                int[] nArray = this.table.getSelectedRows();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    vector.removeElementAt(nArray[i]);
                }
            } else {
                vector.clear();
            }
            this.table.addNotify();
            this.table.getSelectionModel().clearSelection();
        }
        this.deleteAllButton.setEnabled(this.isWritable && !vector.isEmpty());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.deleteAllButton = new JButton();
        this.label = new JLabel();
        this.jScrollPane1.setViewportView(this.table);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SimpleTabularDataCustomEditor.class, (String)"LBL_ADD"));
        this.buttonPanel.add(this.addButton);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SimpleTabularDataCustomEditor.class, (String)"ACS_ADD"));
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(SimpleTabularDataCustomEditor.class, (String)"LBL_DELETE"));
        this.buttonPanel.add(this.deleteButton);
        this.deleteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SimpleTabularDataCustomEditor.class, (String)"ACS_DELETE"));
        Mnemonics.setLocalizedText((AbstractButton)this.deleteAllButton, (String)NbBundle.getMessage(SimpleTabularDataCustomEditor.class, (String)"LBL_DELETE_ALL"));
        this.buttonPanel.add(this.deleteAllButton);
        this.deleteAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SimpleTabularDataCustomEditor.class, (String)"ACS_DELETE_ALL"));
        this.label.setLabelFor(this.table);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)this.tableLabelText);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 380, Short.MAX_VALUE).add(2, (Component)this.buttonPanel, -1, 380, Short.MAX_VALUE).add((Component)this.label, -2, 364, -2)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.label).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 168, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.buttonPanel, -2, -1, -2).addContainerGap()));
        this.label.getAccessibleContext().setAccessibleDescription(this.tableLabelDescription);
    }

    class TabularDataTableHeaderRenderer
    extends DefaultTableCellRenderer {
        TabularDataTableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            Object object2;
            Object object3;
            if (jTable != null && (object3 = jTable.getTableHeader()) != null) {
                this.setForeground(((Component)object3).getForeground());
                this.setBackground(((Component)object3).getBackground());
                this.setFont(((Component)object3).getFont());
            }
            if (SimpleTabularDataCustomEditor.this.descriptor != null) {
                object2 = SimpleTabularDataCustomEditor.this.descriptor.getChild(object.toString());
                object3 = ((JBIComponentConfigurationDescriptor)object2).getDisplayName();
                string = ((JBIComponentConfigurationDescriptor)object2).getDescription();
            } else {
                object3 = object.toString().toUpperCase();
                string = SimpleTabularDataCustomEditor.this.columnDescriptions[this.getColumnIndex(n2)];
            }
            object2 = n2 < SimpleTabularDataCustomEditor.this.indexColumnCount ? "<html><body><b><i>" + (String)object3 + "</i></b></body></html>" : "<html><body><b>" + (String)object3 + "</b></body></html>";
            this.setText((String)object2);
            this.setToolTipText(string);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            return this;
        }

        protected int getColumnIndex(int n) {
            return n;
        }
    }
}

