/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.editors;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import org.netbeans.modules.sun.manager.jbi.editors.ApplicationVariableType;
import org.netbeans.modules.sun.manager.jbi.editors.TabularDataActionTableCellEditor;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationDescriptor;
import org.netbeans.modules.sun.manager.jbi.util.StackTraceUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class TabularDataCellEditorFactory {
    private static final TableCellEditor STRING_EDITOR = new StringCellEditor();
    private static final TableCellEditor BOOLEAN_EDITOR = new BooleanCellEditor();
    private static final TableCellEditor DOUBLE_EDITOR = new NumberCellEditor();
    private static final TableCellEditor PASSWORD_EDITOR = new PasswordCellEditor();
    private static final Map<Class, TableCellEditor> classMap = new HashMap<Class, TableCellEditor>();
    private static final Map<ApplicationVariableType, TableCellEditor> avTypeMap = new HashMap<ApplicationVariableType, TableCellEditor>();

    public static TableCellEditor getEditor(Class clazz) {
        TableCellEditor tableCellEditor = classMap.get(clazz);
        if (tableCellEditor == null) {
            tableCellEditor = STRING_EDITOR;
        }
        return tableCellEditor;
    }

    public static TableCellEditor getEditor(Class clazz, JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor, boolean bl) {
        if (clazz.equals(TabularData.class)) {
            return new TabularDataActionTableCellEditor(new TabularDataCellEditor(), jBIComponentConfigurationDescriptor, bl);
        }
        return TabularDataCellEditorFactory.getEditor(clazz);
    }

    public static TableCellEditor getEditor(ApplicationVariableType applicationVariableType) {
        TableCellEditor tableCellEditor = avTypeMap.get((Object)applicationVariableType);
        if (tableCellEditor == null) {
            tableCellEditor = STRING_EDITOR;
        }
        return tableCellEditor;
    }

    static {
        classMap.put(String.class, STRING_EDITOR);
        classMap.put(Number.class, DOUBLE_EDITOR);
        classMap.put(Boolean.class, BOOLEAN_EDITOR);
        avTypeMap.put(ApplicationVariableType.STRING, STRING_EDITOR);
        avTypeMap.put(ApplicationVariableType.NUMBER, DOUBLE_EDITOR);
        avTypeMap.put(ApplicationVariableType.BOOLEAN, BOOLEAN_EDITOR);
        avTypeMap.put(ApplicationVariableType.PASSWORD, PASSWORD_EDITOR);
    }

    private static class TabularDataCellEditor
    extends DefaultCellEditor {
        public TabularDataCellEditor() {
            super(new JTextField());
            this.setClickCountToStart(1);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            if (object != null) {
                TabularData tabularData = (TabularData)object;
                stringBuilder.append("{");
                for (Object obj : tabularData.values()) {
                    CompositeData compositeData = (CompositeData)obj;
                    String string = this.getStringForRowData(compositeData);
                    stringBuilder.append(string);
                }
                stringBuilder.append("}");
            }
            return super.getTableCellEditorComponent(jTable, stringBuilder.toString(), bl, n, n2);
        }

        private String getStringForRowData(CompositeData compositeData) {
            Collection<?> collection = compositeData.values();
            return collection.toString();
        }
    }

    private static class StringCellEditor
    extends DefaultCellEditor {
        private static final Border myBorder = new EmptyBorder(1, 4, 1, 1);

        public StringCellEditor() {
            super(new JTextField());
            this.setClickCountToStart(1);
            ((JComponent)this.getComponent()).setBorder(myBorder);
        }
    }

    private static class PasswordCellEditor
    extends DefaultCellEditor {
        private static final Border myBorder = new EmptyBorder(1, 3, 1, 1);

        public PasswordCellEditor() {
            super(new JPasswordField());
            this.setClickCountToStart(1);
            ((JComponent)this.getComponent()).setBorder(myBorder);
            ((JPasswordField)this.getComponent()).setEchoChar('*');
        }
    }

    private static class BooleanCellEditor
    extends DefaultCellEditor {
        public BooleanCellEditor() {
            super(new JCheckBox());
        }

        public Object getCellEditorValue() {
            Boolean bl = (Boolean)super.getCellEditorValue();
            return bl.toString();
        }
    }

    private static class NumberCellEditor
    extends GenericCellEditor {
        private static final Border myBorder = new EmptyBorder(1, 4, 1, 1);

        private NumberCellEditor() {
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            ((JComponent)component).setBorder(myBorder);
            return component;
        }

        public Object getCellEditorValue() {
            if (this.value != null && ((String)this.value).trim().length() > 0) {
                try {
                    Double.parseDouble((String)this.value);
                    return this.value;
                }
                catch (NumberFormatException numberFormatException) {
                    String string = NbBundle.getMessage(TabularDataCellEditorFactory.class, (String)"MSG_INVALID_NUMBER", (Object)this.value);
                    if (StackTraceUtil.isCalledBy("*", "vetoableChange")) {
                        throw new RuntimeException(string);
                    }
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
            return "";
        }
    }

    private static class GenericCellEditor
    extends DefaultCellEditor {
        Class[] argTypes = new Class[]{String.class};
        Constructor constructor;
        Object value;

        public GenericCellEditor() {
            super(new JTextField());
            this.getComponent().setName("Table.editor");
            this.setClickCountToStart(1);
        }

        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            if ("".equals(string)) {
                if (this.constructor.getDeclaringClass() == String.class) {
                    this.value = string;
                }
                super.stopCellEditing();
            }
            try {
                this.value = this.constructor.newInstance(string);
            }
            catch (Exception exception) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class<Object> clazz = jTable.getColumnClass(n2);
                if (clazz == Object.class) {
                    clazz = String.class;
                }
                this.constructor = clazz.getConstructor(this.argTypes);
            }
            catch (Exception exception) {
                return null;
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        public Object getCellEditorValue() {
            return this.value;
        }
    }
}

