/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.editors;

import java.awt.Component;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.swing.JCheckBox;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.sun.manager.jbi.editors.ApplicationVariableType;

public class TabularDataCellRendererFactory {
    private static TableCellRenderer STRING_RENDERER = new StringCellRenderer();
    private static TableCellRenderer BOOLEAN_RENDERER = new BooleanCellRenderer();
    private static TableCellRenderer DOUBLE_RENDERER = new DoubleCellRenderer();
    private static TableCellRenderer PASSWORD_RENDERER = new PasswordCellRenderer();
    private static TableCellRenderer TABULAR_DATA_RENDERER = new TabularDataCellRenderer();
    private static final Map<Class, TableCellRenderer> classMap = new HashMap<Class, TableCellRenderer>();
    private static final Map<ApplicationVariableType, TableCellRenderer> avTypeMap = new HashMap<ApplicationVariableType, TableCellRenderer>();

    public static TableCellRenderer getRenderer(Class clazz) {
        TableCellRenderer tableCellRenderer = classMap.get(clazz);
        if (tableCellRenderer == null) {
            tableCellRenderer = STRING_RENDERER;
        }
        return tableCellRenderer;
    }

    public static TableCellRenderer getRenderer(ApplicationVariableType applicationVariableType) {
        TableCellRenderer tableCellRenderer = avTypeMap.get((Object)applicationVariableType);
        if (tableCellRenderer == null) {
            tableCellRenderer = STRING_RENDERER;
        }
        return tableCellRenderer;
    }

    static {
        classMap.put(String.class, STRING_RENDERER);
        classMap.put(Number.class, DOUBLE_RENDERER);
        classMap.put(Boolean.class, BOOLEAN_RENDERER);
        classMap.put(TabularData.class, TABULAR_DATA_RENDERER);
        avTypeMap.put(ApplicationVariableType.STRING, STRING_RENDERER);
        avTypeMap.put(ApplicationVariableType.NUMBER, DOUBLE_RENDERER);
        avTypeMap.put(ApplicationVariableType.BOOLEAN, BOOLEAN_RENDERER);
        avTypeMap.put(ApplicationVariableType.PASSWORD, PASSWORD_RENDERER);
    }

    static class TabularDataCellRenderer
    extends StringCellRenderer {
        TabularDataCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null && object instanceof TabularData) {
                TabularData tabularData = (TabularData)object;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("{");
                for (Object obj : tabularData.values()) {
                    CompositeData compositeData = (CompositeData)obj;
                    String string = this.getStringForRowData(compositeData);
                    stringBuilder.append(string);
                }
                stringBuilder.append("}");
                object = stringBuilder.toString();
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        private String getStringForRowData(CompositeData compositeData) {
            Collection<?> collection = compositeData.values();
            return collection.toString();
        }
    }

    static class PasswordCellRenderer
    extends JPasswordField
    implements TableCellRenderer,
    Serializable {
        private static final Border myBorder = new EmptyBorder(1, 4, 1, 1);

        public PasswordCellRenderer() {
            this.setOpaque(true);
            this.setBorder(myBorder);
            this.setEchoChar('*');
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setValue(object);
            return this;
        }

        protected void setValue(Object object) {
            this.setText(object == null ? "" : object.toString());
        }
    }

    static class BooleanCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border myBorder = new EmptyBorder(1, 4, 1, 1);

        public BooleanCellRenderer() {
            this.setBorder(myBorder);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && object.toString().equalsIgnoreCase("true"));
            return this;
        }
    }

    static class DoubleCellRenderer
    extends DefaultTableCellRenderer {
        private static final Border myBorder = new EmptyBorder(1, 4, 1, 1);
        NumberFormat formatter;

        public DoubleCellRenderer() {
            this.setHorizontalAlignment(2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setBorder(myBorder);
            return component;
        }

        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            if (object == null || ((String)object).trim().length() == 0) {
                this.setText("");
            } else {
                double d = Double.parseDouble((String)object);
                this.setText(this.formatter.format(d));
            }
        }
    }

    static class StringCellRenderer
    extends DefaultTableCellRenderer {
        private static final Border myBorder = new EmptyBorder(1, 4, 1, 1);

        public StringCellRenderer() {
            this.setHorizontalAlignment(2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setBorder(myBorder);
            return component;
        }
    }
}

