/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.management.connectors;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.netbeans.modules.sun.manager.jbi.management.connectors.ConnectionType;
import org.netbeans.modules.sun.manager.jbi.management.connectors.ServerConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPServerConnector
extends ServerConnector
implements Serializable {
    static final String PROTOCOL_CLASS = "com.sun.enterprise.admin.jmx.remote.protocol";
    static final String HTTP_AUTH_PROPERTY_NAME = "com.sun.enterprise.as.http.auth";
    static final String DEFAULT_HTTP_AUTH_SCHEME = "BASIC";
    static final String ADMIN_USER_ENV_PROPERTY_NAME = "USER";
    static final String ADMIN_PASSWORD_ENV_PROPERTY_NAME = "PASSWORD";
    static final String RTS_HTTP_CONNECTOR = "s1ashttp";
    transient MBeanServerConnection connection;
    private ClassLoader jbiClassLoader;

    public HTTPServerConnector(String string, String string2, String string3, String string4, ClassLoader classLoader) {
        super(string, string2, string3, string4);
        this.jbiClassLoader = classLoader;
        try {
            this.initialize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setParameters(String string, String string2, String string3, String string4) {
        this.hostName = string;
        this.port = string2;
        this.userName = string3;
        this.password = string4;
        try {
            this.initialize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    private void initialize() throws Exception {
        boolean bl = true;
        int n = new Integer(this.getPort());
        this.connection = this.getMBeanServerConnection(this.getHostName(), n, this.getUserName(), this.getPassword());
    }

    boolean isMBeanRegistered(MBeanServerConnection mBeanServerConnection, String string) throws MalformedObjectNameException, NullPointerException, IOException {
        boolean bl = false;
        ObjectName objectName = new ObjectName(string);
        bl = mBeanServerConnection.isRegistered(objectName);
        return bl;
    }

    public MBeanServerConnection getMBeanServerConnection(String string, int n, String string2, String string3) throws Exception {
        MBeanServerConnection mBeanServerConnection = null;
        boolean bl = false;
        String string4 = "com.sun.jbi:ServiceName=JbiAdminUiService,ComponentType=System";
        try {
            mBeanServerConnection = this.getMBeanServerConnection(string, n, string2, string3, ConnectionType.HTTP);
            bl = this.isMBeanRegistered(mBeanServerConnection, string4);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            mBeanServerConnection = null;
        }
        catch (IOException iOException) {
            mBeanServerConnection = null;
        }
        catch (RuntimeException runtimeException) {
            mBeanServerConnection = null;
        }
        catch (Exception exception) {
            mBeanServerConnection = null;
        }
        if (mBeanServerConnection == null) {
            try {
                mBeanServerConnection = this.getMBeanServerConnection(string, n, string2, string3, ConnectionType.HTTPS);
                bl = this.isMBeanRegistered(mBeanServerConnection, string4);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                mBeanServerConnection = null;
            }
            catch (IOException iOException) {
                mBeanServerConnection = null;
            }
            catch (RuntimeException runtimeException) {
                mBeanServerConnection = null;
            }
            catch (Exception exception) {
                mBeanServerConnection = null;
            }
        }
        if (mBeanServerConnection == null) {
            try {
                mBeanServerConnection = this.getMBeanServerConnection(string, n, string2, string3, ConnectionType.JRMP);
                bl = this.isMBeanRegistered(mBeanServerConnection, string4);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                mBeanServerConnection = null;
            }
            catch (IOException iOException) {
                mBeanServerConnection = null;
            }
            catch (RuntimeException runtimeException) {
                mBeanServerConnection = null;
            }
            catch (Exception exception) {
                mBeanServerConnection = null;
            }
        }
        return mBeanServerConnection;
    }

    protected MBeanServerConnection getMBeanServerConnection(String string, int n, String string2, String string3, ConnectionType connectionType) throws Exception {
        if (connectionType == ConnectionType.JRMP) {
            String string4 = "service:jmx:rmi:///jndi/rmi://" + string + ":" + n + "/management/rmi-jmx-connector";
            return this.getMBeanServerConnection(string4, string2, string3);
        }
        JMXServiceURL jMXServiceURL = new JMXServiceURL(connectionType.getProtocol(), string, n);
        JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, this.initEnvironment(string2, string3));
        return jMXConnector.getMBeanServerConnection();
    }

    private Map<String, Object> initEnvironment(String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("jmx.remote.protocol.provider.class.loader", this.jbiClassLoader);
        hashMap.put("jmx.remote.protocol.provider.pkgs", PROTOCOL_CLASS);
        hashMap.put(ADMIN_USER_ENV_PROPERTY_NAME, string);
        hashMap.put(ADMIN_PASSWORD_ENV_PROPERTY_NAME, string2);
        hashMap.put(HTTP_AUTH_PROPERTY_NAME, DEFAULT_HTTP_AUTH_SCHEME);
        return hashMap;
    }

    protected MBeanServerConnection getMBeanServerConnection(String string, String string2, String string3) throws Exception {
        JMXServiceURL jMXServiceURL = new JMXServiceURL(string);
        String[] stringArray = new String[]{string2, string3};
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put("jmx.remote.credentials", stringArray);
        JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
        return jMXConnector.getMBeanServerConnection();
    }

    public static void main(String[] stringArray) {
        String string = "localhost";
        String string2 = "";
        string2 = "5651";
        String string3 = "admin";
        String string4 = "adminadmin";
        HTTPServerConnector hTTPServerConnector = new HTTPServerConnector(string, string2, string3, string4, null);
        if (hTTPServerConnector.getConnection() != null) {
            System.out.println("Connection Retrieved." + hTTPServerConnector.toString());
            hTTPServerConnector.printOut();
        } else {
            System.out.println("Connection Failed");
        }
    }
}

