/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.management.model;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentConfigurationDescriptor;
import org.netbeans.modules.sun.manager.jbi.management.model.constraint.CompositeConstraint;
import org.netbeans.modules.sun.manager.jbi.management.model.constraint.JBIComponentConfigurationConstraint;
import org.netbeans.modules.sun.manager.jbi.management.model.constraint.JBIComponentConfigurationConstraintFactory;
import org.netbeans.modules.sun.manager.jbi.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBIComponentConfigurationParser {
    private static final String CONFIGURATION_NAMESPACE = "http://www.sun.com/jbi/Configuration/V1.0";
    private static final String PROPERTY = "Property";
    private static final String PROPERTY_GROUP = "PropertyGroup";
    private static final String APPLICATION_CONFIGURATION = "ApplicationConfiguration";
    private static final String APPLICATION_VARIABLE = "ApplicationVariable";
    private static final String CONFIGURATION = "Configuration";
    private static final String CONSTRAINT = "Constraint";
    private static final String NAME = "name";
    private static final String DISPLAY_NAME = "displayName";
    private static final String DISPLAY_DESCRIPTION = "displayDescription";
    private static final String ENCRYPTED = "encrypted";
    private static final String IS_APPLICATION_RESTART_REQUIRED = "isApplicationRestartRequired";
    private static final String IS_COMPONENT_RESTART_REQUIRED = "isComponentRestartRequired";
    private static final String IS_SERVER_RESTART_REQUIRED = "isServerRestartRequired";
    private static final String REQUIRED = "required";
    private static final String SHOW_DISPLAY = "showDisplay";
    private static final String ON_CHANGE_MESSAGE = "onChangeMessage";
    private static final String TYPE = "type";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String FACET = "facet";
    private static final String FACET_VALUE = "value";

    public static JBIComponentConfigurationDescriptor parse(String string) throws ParserConfigurationException, IOException, SAXException {
        JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor = null;
        if (string != null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            jBIComponentConfigurationDescriptor = JBIComponentConfigurationParser.parse(document);
        }
        return jBIComponentConfigurationDescriptor;
    }

    public static JBIComponentConfigurationDescriptor parse(Document document) throws ParserConfigurationException, IOException, SAXException {
        JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor = null;
        NodeList nodeList = document.getElementsByTagNameNS(CONFIGURATION_NAMESPACE, CONFIGURATION);
        if (nodeList != null && nodeList.getLength() == 1) {
            Element element = (Element)nodeList.item(0);
            jBIComponentConfigurationDescriptor = new JBIComponentConfigurationDescriptor();
            JBIComponentConfigurationParser.parseConfigurationElement(jBIComponentConfigurationDescriptor, element);
        }
        return jBIComponentConfigurationDescriptor;
    }

    private static void parseConfigurationElement(JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor, Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            String string2;
            String string3;
            JBIComponentConfigurationDescriptor jBIComponentConfigurationDescriptor2;
            Element element2;
            String string4;
            if (!(nodeList.item(i) instanceof Element) || !(string4 = (element2 = (Element)nodeList.item(i)).getLocalName()).equals(PROPERTY) && !string4.equals(PROPERTY_GROUP) && !string4.equals(APPLICATION_VARIABLE) && !string4.equals(APPLICATION_CONFIGURATION)) continue;
            if (string4.equals(APPLICATION_VARIABLE)) {
                jBIComponentConfigurationDescriptor2 = new JBIComponentConfigurationDescriptor.ApplicationVariable();
            } else if (string4.equals(APPLICATION_CONFIGURATION)) {
                jBIComponentConfigurationDescriptor2 = new JBIComponentConfigurationDescriptor.ApplicationConfiguration();
            } else {
                String string5;
                String string6;
                jBIComponentConfigurationDescriptor2 = new JBIComponentConfigurationDescriptor();
                jBIComponentConfigurationDescriptor2.setName(element2.getAttribute(NAME));
                jBIComponentConfigurationDescriptor2.setDisplayName(element2.getAttribute(DISPLAY_NAME));
                jBIComponentConfigurationDescriptor2.setDescription(element2.getAttribute(DISPLAY_DESCRIPTION));
                jBIComponentConfigurationDescriptor2.setTypeQName(XmlUtil.getAttributeNSName(element2, TYPE));
                jBIComponentConfigurationDescriptor2.setPropertyType(string4);
                string3 = element2.getAttribute(REQUIRED);
                if (string3.length() != 0) {
                    jBIComponentConfigurationDescriptor2.setRequired(Boolean.valueOf(string3));
                }
                if ((string2 = element2.getAttribute(SHOW_DISPLAY)).length() != 0) {
                    jBIComponentConfigurationDescriptor2.setShowDisplay(string2);
                }
                if ((string = element2.getAttribute(ENCRYPTED)).length() != 0) {
                    jBIComponentConfigurationDescriptor2.setEncrypted(Boolean.valueOf(string));
                }
                if ((string6 = element2.getAttribute(ON_CHANGE_MESSAGE)).length() != 0) {
                    jBIComponentConfigurationDescriptor2.setOnChangeMessage(string6);
                }
                if ((string5 = element2.getAttribute(DEFAULT_VALUE)).length() != 0) {
                    jBIComponentConfigurationDescriptor2.setDefaultValue(string5);
                }
                CompositeConstraint compositeConstraint = new CompositeConstraint();
                ArrayList<String> arrayList = null;
                NodeList nodeList2 = element2.getElementsByTagNameNS(CONFIGURATION_NAMESPACE, CONSTRAINT);
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    String string7 = element3.getAttribute(FACET);
                    String string8 = element3.getAttribute(FACET_VALUE);
                    if (string7.equals("enumeration")) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(string8);
                        continue;
                    }
                    JBIComponentConfigurationConstraint jBIComponentConfigurationConstraint = JBIComponentConfigurationConstraintFactory.newConstraint(string7, string8);
                    compositeConstraint.addConstraint(jBIComponentConfigurationConstraint);
                }
                if (arrayList != null) {
                    JBIComponentConfigurationConstraint jBIComponentConfigurationConstraint = JBIComponentConfigurationConstraintFactory.newConstraint("enumeration", arrayList);
                    compositeConstraint.addConstraint(jBIComponentConfigurationConstraint);
                }
                jBIComponentConfigurationDescriptor2.setConstraint(compositeConstraint);
            }
            string3 = element2.getAttribute(IS_APPLICATION_RESTART_REQUIRED);
            if (string3.length() != 0) {
                jBIComponentConfigurationDescriptor2.setApplicationRestartRequired(Boolean.valueOf(string3));
            }
            if ((string2 = element2.getAttribute(IS_COMPONENT_RESTART_REQUIRED)).length() != 0) {
                jBIComponentConfigurationDescriptor2.setComponentRestartRequired(Boolean.valueOf(string2));
            }
            if ((string = element2.getAttribute(IS_SERVER_RESTART_REQUIRED)).length() != 0) {
                jBIComponentConfigurationDescriptor2.setServerRestartRequired(Boolean.valueOf(string));
            }
            jBIComponentConfigurationDescriptor.addChild(jBIComponentConfigurationDescriptor2);
            JBIComponentConfigurationParser.parseConfigurationElement(jBIComponentConfigurationDescriptor2, element2);
        }
    }
}

