/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.management.wrapper.api.impl;

import com.sun.esb.management.api.runtime.RuntimeManagementService;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.sun.manager.jbi.management.JBIComponentType;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeManagementServiceWrapperImpl
implements RuntimeManagementServiceWrapper {
    private RuntimeManagementService service;
    private List<JBIComponentInfo> serviceEngineStatusList;
    private List<JBIComponentInfo> bindingComponentStatusList;
    private List<JBIComponentInfo> sharedLibraryStatusList;
    private List<ServiceAssemblyInfo> serviceAssemblyStatusList;

    public RuntimeManagementServiceWrapperImpl(RuntimeManagementService runtimeManagementService) {
        this.service = runtimeManagementService;
    }

    @Override
    public List<JBIComponentInfo> listBindingComponents(String string) throws ManagementRemoteException {
        if (this.bindingComponentStatusList == null) {
            String string2 = this.service.listBindingComponents(string);
            this.bindingComponentStatusList = JBIComponentInfo.readFromXmlText((String)string2);
        }
        return this.bindingComponentStatusList;
    }

    @Override
    public List<JBIComponentInfo> listServiceEngines(String string) throws ManagementRemoteException {
        if (this.serviceEngineStatusList == null) {
            String string2 = this.service.listServiceEngines(string);
            this.serviceEngineStatusList = JBIComponentInfo.readFromXmlText((String)string2);
        }
        return this.serviceEngineStatusList;
    }

    @Override
    public List<JBIComponentInfo> listSharedLibraries(String string) throws ManagementRemoteException {
        if (this.sharedLibraryStatusList == null) {
            String string2 = this.service.listSharedLibraries(string);
            this.sharedLibraryStatusList = JBIComponentInfo.readFromXmlText((String)string2);
        }
        return this.sharedLibraryStatusList;
    }

    @Override
    public List<ServiceAssemblyInfo> listServiceAssemblies(String string) throws ManagementRemoteException {
        if (this.serviceAssemblyStatusList == null) {
            String string2 = this.service.listServiceAssemblies(string);
            this.serviceAssemblyStatusList = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)string2);
        }
        return this.serviceAssemblyStatusList;
    }

    @Override
    public List<ServiceAssemblyInfo> listServiceAssemblies(String string, String string2) throws ManagementRemoteException {
        String string3 = this.service.listServiceAssemblies(string, string2);
        return ServiceAssemblyInfo.readFromXmlTextWithProlog((String)string3);
    }

    @Override
    public String shutdownComponent(String string, boolean bl, String string2) throws ManagementRemoteException {
        return this.service.shutdownComponent(string, bl, string2);
    }

    @Override
    public String shutdownServiceAssembly(String string, boolean bl, String string2) throws ManagementRemoteException {
        return this.service.shutdownServiceAssembly(string, bl, string2);
    }

    @Override
    public String startComponent(String string, String string2) throws ManagementRemoteException {
        return this.service.startComponent(string, string2);
    }

    @Override
    public String startServiceAssembly(String string, String string2) throws ManagementRemoteException {
        return this.service.startServiceAssembly(string, string2);
    }

    @Override
    public String stopComponent(String string, String string2) throws ManagementRemoteException {
        return this.service.stopComponent(string, string2);
    }

    @Override
    public String stopServiceAssembly(String string, String string2) throws ManagementRemoteException {
        return this.service.stopServiceAssembly(string, string2);
    }

    @Override
    public List<JBIComponentInfo> listJBIComponents(JBIComponentType jBIComponentType, String string) throws ManagementRemoteException {
        List<JBIComponentInfo> list = null;
        if (JBIComponentType.SERVICE_ENGINE.equals((Object)jBIComponentType)) {
            list = this.listServiceEngines(string);
        } else if (JBIComponentType.BINDING_COMPONENT.equals((Object)jBIComponentType)) {
            list = this.listBindingComponents(string);
        } else if (JBIComponentType.SHARED_LIBRARY.equals((Object)jBIComponentType)) {
            list = this.listSharedLibraries(string);
        } else assert (false);
        return list;
    }

    @Override
    public void clearServiceAssemblyStatusCache() {
        this.serviceAssemblyStatusList = null;
    }

    @Override
    public void clearJBIComponentStatusCache(JBIComponentType jBIComponentType) {
        switch (jBIComponentType) {
            case SERVICE_ENGINE: {
                this.serviceEngineStatusList = null;
                break;
            }
            case BINDING_COMPONENT: {
                this.bindingComponentStatusList = null;
                break;
            }
            case SHARED_LIBRARY: {
                this.sharedLibraryStatusList = null;
                break;
            }
            default: {
                assert (false) : "Unknown component type: " + (Object)((Object)jBIComponentType);
                break;
            }
        }
    }

    @Override
    public List<String> getServiceAssemblyNames(String string, String string2) throws ManagementRemoteException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ServiceAssemblyInfo> list = this.listServiceAssemblies(string, string2);
        for (ServiceAssemblyInfo serviceAssemblyInfo : list) {
            arrayList.add(serviceAssemblyInfo.getName());
        }
        return arrayList;
    }

    @Override
    public ServiceAssemblyInfo getServiceAssembly(String string, String string2) throws ManagementRemoteException {
        for (ServiceAssemblyInfo serviceAssemblyInfo : this.listServiceAssemblies(string2)) {
            if (!serviceAssemblyInfo.getName().equals(string)) continue;
            return serviceAssemblyInfo;
        }
        return null;
    }

    @Override
    public ServiceUnitInfo getServiceUnit(String string, String string2, String string3) throws ManagementRemoteException {
        ServiceAssemblyInfo serviceAssemblyInfo = this.getServiceAssembly(string, string3);
        if (serviceAssemblyInfo != null) {
            List list = serviceAssemblyInfo.getServiceUnitInfoList();
            for (ServiceUnitInfo serviceUnitInfo : list) {
                if (!serviceUnitInfo.getName().equals(string2)) continue;
                return serviceUnitInfo;
            }
        }
        return null;
    }

    @Override
    public JBIComponentInfo getJBIComponent(JBIComponentType jBIComponentType, String string, String string2) throws ManagementRemoteException {
        List<JBIComponentInfo> list = null;
        if (JBIComponentType.SERVICE_ENGINE.equals((Object)jBIComponentType)) {
            list = this.listServiceEngines(string2);
        } else if (JBIComponentType.BINDING_COMPONENT.equals((Object)jBIComponentType)) {
            list = this.listBindingComponents(string2);
        } else if (JBIComponentType.SHARED_LIBRARY.equals((Object)jBIComponentType)) {
            list = this.listSharedLibraries(string2);
        } else assert (false);
        for (JBIComponentInfo jBIComponentInfo : list) {
            if (!jBIComponentInfo.getName().equals(string)) continue;
            return jBIComponentInfo;
        }
        return null;
    }
}

