/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.nodes;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class JBIArtifactValidator {
    private static ComponentValidator serviceEngineValidator;
    private static ComponentValidator bindingComponentValidator;
    private static SharedLibraryValidator sharedLibraryValidator;
    private static ServiceAssemblyValidator serviceAssemblyValidator;

    public static JBIArtifactValidator getServiceEngineValidator(String string) {
        if (serviceEngineValidator == null) {
            serviceEngineValidator = new ServiceEngineValidator();
        }
        serviceEngineValidator.setComponentName(string);
        return serviceEngineValidator;
    }

    public static JBIArtifactValidator getBindingComponentValidator(String string) {
        if (bindingComponentValidator == null) {
            bindingComponentValidator = new BindingComponentValidator();
        }
        bindingComponentValidator.setComponentName(string);
        return bindingComponentValidator;
    }

    public static JBIArtifactValidator getSharedLibraryValidator() {
        if (sharedLibraryValidator == null) {
            sharedLibraryValidator = new SharedLibraryValidator();
        }
        return sharedLibraryValidator;
    }

    public static JBIArtifactValidator getServiceAssemblyValidator() {
        if (serviceAssemblyValidator == null) {
            serviceAssemblyValidator = new ServiceAssemblyValidator();
        }
        return serviceAssemblyValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(File file) {
        boolean bl = false;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        if (documentBuilder != null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                JarEntry jarEntry = (JarEntry)jarFile.getEntry("META-INF/jbi.xml");
                if (jarEntry != null) {
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    Document document = documentBuilder.parse(inputStream);
                    bl = this.validate(document);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bl;
    }

    protected abstract boolean validate(Document var1);

    private static class ServiceAssemblyValidator
    extends JBIArtifactValidator {
        private ServiceAssemblyValidator() {
        }

        protected boolean validate(Document document) {
            NodeList nodeList = document.getElementsByTagName("service-assembly");
            return nodeList.getLength() == 1;
        }
    }

    private static class SharedLibraryValidator
    extends JBIArtifactValidator {
        private SharedLibraryValidator() {
        }

        protected boolean validate(Document document) {
            NodeList nodeList = document.getElementsByTagName("shared-library");
            return nodeList.getLength() > 0;
        }
    }

    private static class BindingComponentValidator
    extends ComponentValidator {
        BindingComponentValidator() {
            super("binding-component");
        }
    }

    private static class ServiceEngineValidator
    extends ComponentValidator {
        ServiceEngineValidator() {
            super("service-engine");
        }
    }

    private static class ComponentValidator
    extends JBIArtifactValidator {
        private String componentType;
        private String componentName;

        ComponentValidator(String string) {
            this.componentType = string;
        }

        public void setComponentName(String string) {
            this.componentName = string;
        }

        protected boolean validate(Document document) {
            Element element;
            String string;
            NodeList nodeList = document.getElementsByTagName("component");
            if (nodeList.getLength() > 0 && (string = (element = (Element)nodeList.item(0)).getAttribute("type")) != null && string.equals(this.componentType)) {
                Element element2;
                NodeList nodeList2;
                if (this.componentName == null) {
                    return true;
                }
                String string2 = null;
                NodeList nodeList3 = element.getElementsByTagName("identification");
                if (nodeList3.getLength() > 0 && (nodeList2 = (element2 = (Element)nodeList3.item(0)).getElementsByTagName("name")).getLength() > 0) {
                    Element element3 = (Element)nodeList2.item(0);
                    string2 = element3.getFirstChild().getNodeValue();
                }
                if (this.componentName.equals(string2)) {
                    return true;
                }
            }
            return false;
        }
    }
}

