/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.nodes;

import com.sun.esb.management.api.deployment.DeploymentService;
import com.sun.esb.management.common.ManagementRemoteException;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.sun.manager.jbi.actions.DeployAction;
import org.netbeans.modules.sun.manager.jbi.actions.RefreshAction;
import org.netbeans.modules.sun.manager.jbi.management.AppserverJBIMgmtController;
import org.netbeans.modules.sun.manager.jbi.management.JBIMBeanTaskResultHandler;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.nodes.AppserverJBIMgmtContainerNode;
import org.netbeans.modules.sun.manager.jbi.nodes.Deployable;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIArtifactValidator;
import org.netbeans.modules.sun.manager.jbi.nodes.JBIComponentContainerNode;
import org.netbeans.modules.sun.manager.jbi.nodes.NodeType;
import org.netbeans.modules.sun.manager.jbi.util.FileFilters;
import org.netbeans.modules.sun.manager.jbi.util.ProgressUI;
import org.netbeans.modules.sun.manager.jbi.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIServiceAssembliesNode
extends AppserverJBIMgmtContainerNode
implements Deployable {
    private static String lastInstallDir = null;
    private boolean busy;

    public JBIServiceAssembliesNode(AppserverJBIMgmtController appserverJBIMgmtController) {
        super(appserverJBIMgmtController, NodeType.SERVICE_ASSEMBLIES);
        this.setDisplayName(NbBundle.getMessage(JBIServiceAssembliesNode.class, (String)"SERVICE_ASSEMBLIES"));
    }

    @Override
    public Action[] getActions(boolean bl) {
        return new SystemAction[]{SystemAction.get(DeployAction.DeployOnly.class), SystemAction.get(DeployAction.DeployAndStart.class), null, SystemAction.get(RefreshAction.class)};
    }

    public Image getIcon(int n) {
        String string = "resources/folder.png";
        String string2 = "resources/ServiceAssemblyBadge.png";
        String string3 = this.busy ? "resources/waiting.png" : null;
        return Utils.getBadgedIcon(this.getClass(), string, string2, string3);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    @Override
    public void refresh() {
        RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
        runtimeManagementServiceWrapper.clearServiceAssemblyStatusCache();
        super.refresh();
    }

    private void setBusy(boolean bl) {
        this.busy = bl;
        this.fireIconChange();
    }

    @Override
    public void deploy(boolean bl) {
        List<File> list;
        DeploymentService deploymentService = this.getDeploymentService();
        assert (deploymentService != null);
        JFileChooser jFileChooser = this.getJFileChooser();
        int n = jFileChooser.showDialog(null, NbBundle.getMessage(JBIServiceAssembliesNode.class, (String)"LBL_Deploy_Service_Assembly_Button"));
        if (n != 0) {
            return;
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        if (fileArray.length > 0) {
            lastInstallDir = fileArray[0].getParent();
        }
        if ((list = this.filterSelectedFiles(fileArray)).size() == 0) {
            return;
        }
        String string = NbBundle.getMessage(JBIServiceAssembliesNode.class, (String)"LBL_Deploying_Service_Assembly");
        final ProgressUI progressUI = new ProgressUI(string, false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JBIServiceAssembliesNode.this.setBusy(true);
                progressUI.start();
            }
        });
        for (File file : list) {
            String string2 = file.getAbsolutePath();
            try {
                String string3 = deploymentService.deployServiceAssembly(string2, "server");
                assert (string3 != null);
                String string4 = string3.toLowerCase();
                if (!(string4.contains("error") || string4.contains("warning") || string4.contains("exception") || string4.contains("info"))) {
                    if (!bl) continue;
                    String string5 = string3;
                    RuntimeManagementServiceWrapper runtimeManagementServiceWrapper = this.getRuntimeManagementServiceWrapper();
                    string3 = runtimeManagementServiceWrapper.startServiceAssembly(string5, "server");
                    JBIMBeanTaskResultHandler.showRemoteInvokationResult("startServiceAssembly", string5, string3);
                    continue;
                }
                JBIMBeanTaskResultHandler.showRemoteInvokationResult("deployServiceAssembly", string2, string3);
            }
            catch (ManagementRemoteException managementRemoteException) {
                JBIMBeanTaskResultHandler.showRemoteInvokationResult("deployServiceAssembly", string2, managementRemoteException.getMessage());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                progressUI.finish();
                JBIServiceAssembliesNode.this.setBusy(false);
            }
        });
    }

    protected Map<Attribute, MBeanAttributeInfo> getGeneralSheetSetProperties() {
        return null;
    }

    @Override
    public Attribute setSheetProperty(String string, Object object) {
        return null;
    }

    private JFileChooser getJFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        ResourceBundle resourceBundle = NbBundle.getBundle(JBIComponentContainerNode.class);
        jFileChooser.setDialogTitle(resourceBundle.getString("LBL_Deploy_Service_Assembly_Chooser_Name"));
        jFileChooser.setDialogType(2);
        jFileChooser.setApproveButtonMnemonic(resourceBundle.getString("Deploy_Service_Assembly_Button_Mnemonic").charAt(0));
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.addChoosableFileFilter(FileFilters.ArchiveFileFilter.getInstance());
        jFileChooser.setApproveButtonToolTipText(resourceBundle.getString("LBL_Deploy_Service_Assembly_Button"));
        jFileChooser.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_Deploy_Service_Assembly_Chooser_Name"));
        jFileChooser.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_Deploy_Service_Assembly_Chooser_Name"));
        if (lastInstallDir != null) {
            jFileChooser.setCurrentDirectory(new File(lastInstallDir));
        }
        return jFileChooser;
    }

    private List<File> filterSelectedFiles(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        if (documentBuilder != null) {
            JBIArtifactValidator jBIArtifactValidator = JBIArtifactValidator.getServiceAssemblyValidator();
            for (File file : fileArray) {
                if (jBIArtifactValidator.validate(file)) {
                    arrayList.add(file);
                    continue;
                }
                String string = NbBundle.getMessage(this.getClass(), (String)"MSG_INVALID_SERVICE_ASSEMBLY_DEPLOYMENT", (Object)file.getName());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
        return arrayList;
    }

    @Override
    protected boolean needRefresh(String string) {
        return string.equals("ServiceAssembly");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JBIServiceAssembliesNode.class);
    }
}

