/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.sun.manager.jbi.util.Utils;
import org.openide.util.NbBundle;

public class ProgressUI
implements ProgressListener {
    private String title;
    private boolean modal;
    private ProgressHandle handle;
    private ProgressObject progObj;
    private JDialog dialog;
    private JLabel messageLabel;
    private String lastMessage;
    private JComponent progressComponent;
    private boolean finished;

    public ProgressUI(String string, boolean bl) {
        this.modal = bl;
        this.title = string;
        this.handle = ProgressHandleFactory.createHandle((String)string);
    }

    public void start() {
        if (this.modal) {
            this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
        }
        this.handle.start();
    }

    public void progress(final String string) {
        this.handle.progress(string);
        if (this.modal) {
            Utils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    if (ProgressUI.this.messageLabel != null) {
                        ProgressUI.this.messageLabel.setText(string);
                    } else {
                        ProgressUI.this.lastMessage = string;
                    }
                }
            });
        }
    }

    public void finish() {
        this.handle.finish();
        if (this.progObj != null) {
            this.progObj.removeProgressListener((ProgressListener)this);
            this.progObj = null;
        }
        Utils.runInEventDispatchThread(new Runnable(){

            public void run() {
                ProgressUI.this.finished = true;
                if (ProgressUI.this.dialog != null) {
                    ProgressUI.this.dialog.setVisible(false);
                    ProgressUI.this.dialog.dispose();
                    ProgressUI.this.dialog = null;
                }
            }
        });
    }

    public void failed(String string) {
        this.finish();
    }

    public void setProgressObject(ProgressObject progressObject) {
        if (this.progObj != null) {
            this.progObj.removeProgressListener((ProgressListener)this);
        }
        this.progObj = progressObject;
        if (this.progObj != null) {
            this.progObj.addProgressListener((ProgressListener)this);
        }
    }

    private JComponent createProgressDialog(ProgressHandle progressHandle, String string) {
        JPanel jPanel = new JPanel();
        this.messageLabel = new JLabel();
        jPanel.setLayout(new GridBagLayout());
        this.messageLabel.setText(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        jPanel.add((Component)this.messageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        jPanel.add((Component)this.progressComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 12, 12);
        JButton jButton = new JButton(NbBundle.getMessage(ProgressUI.class, (String)"LBL_Cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProgressUI.class, (String)"AD_Cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressUI.this.finish();
            }
        });
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    public void handleProgressEvent(ProgressEvent progressEvent) {
        DeploymentStatus deploymentStatus = progressEvent.getDeploymentStatus();
        StateType stateType = deploymentStatus.getState();
        if (stateType == StateType.COMPLETED) {
            this.progress(deploymentStatus.getMessage());
        } else if (stateType == StateType.RUNNING) {
            this.progress(deploymentStatus.getMessage());
        } else if (stateType == StateType.FAILED) {
            this.failed(deploymentStatus.getMessage());
        } else if (stateType == StateType.RELEASED) {
            this.failed(deploymentStatus.getMessage());
        }
    }
}

