/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sun.manager.jbi.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.sun.manager.jbi.util.ServerInstance;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerInstanceReader {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String RELATIVE_FILE_PATH = FILE_SEPARATOR + "config" + FILE_SEPARATOR + "J2EE" + FILE_SEPARATOR + "InstalledServers" + FILE_SEPARATOR + ".nbattrs";
    private static final String NB_DEFAULT_ATTRS_DTD = "xml/entities/NetBeans/DTD_DefaultAttributes_1_0";
    private static final String NB_DEFAULT_ATTRS_PUBLIC_ID = "-//NetBeans//DTD DefaultAttributes 1.0//EN";
    private static final String LOCAL_NB_DEFAULT_ATTRS_DTD = "NetBeansDefaultAttrs_1_0.dtd";
    private List<ServerInstance> instances;
    private String fileName;

    public ServerInstanceReader(String string) {
        assert (string != null);
        this.fileName = string.replace('\\', '/');
        assert (new File(string).exists()) : "Server config file " + string + " doesn't exist.";
    }

    public List<ServerInstance> getServerInstances() {
        if (this.instances == null) {
            this.instances = new ArrayList<ServerInstance>();
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                        if (ServerInstanceReader.NB_DEFAULT_ATTRS_PUBLIC_ID.equals(string)) {
                            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(ServerInstanceReader.NB_DEFAULT_ATTRS_DTD);
                            if (fileObject != null) {
                                return new InputSource(fileObject.getInputStream());
                            }
                            URL uRL = this.getClass().getResource(ServerInstanceReader.LOCAL_NB_DEFAULT_ATTRS_DTD);
                            return new InputSource(uRL.openStream());
                        }
                        return null;
                    }
                });
                Document document = documentBuilder.parse(new File(this.fileName));
                NodeList nodeList = (NodeList)xPath.evaluate("/attributes/fileobject", document, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    NodeList nodeList2 = node.getChildNodes();
                    ServerInstance serverInstance = new ServerInstance();
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Node node2 = nodeList2.item(j);
                        String string = node2.getNodeName();
                        if (node2.getNodeType() != 1 || !string.equalsIgnoreCase("attr")) continue;
                        Element element = (Element)node2;
                        String string2 = element.getAttribute("name");
                        String string3 = element.getAttribute("stringvalue");
                        if (string2.equalsIgnoreCase("displayName")) {
                            serverInstance.setDisplayName(string3);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("DOMAIN")) {
                            serverInstance.setDomain(string3);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("HttpMonitorOn")) {
                            serverInstance.setHttpMonitorOn(string3);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("httpportnumber")) {
                            serverInstance.setHttpPortNumber(string3);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("LOCATION")) {
                            serverInstance.setLocation(string3);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("password")) {
                            serverInstance.setPassword(string3);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("url")) {
                            serverInstance.setUrl(string3);
                            continue;
                        }
                        if (!string2.equalsIgnoreCase("username")) continue;
                        serverInstance.setUserName(string3);
                    }
                    if (serverInstance.getHostName() == null || serverInstance.getLocation() == null) continue;
                    this.instances.add(serverInstance);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return this.instances;
    }

    public static void main(String[] stringArray) {
        ServerInstanceReader serverInstanceReader = null;
        try {
            serverInstanceReader = new ServerInstanceReader("C:/Documents and Settings/Graj/.netbeans/dev" + RELATIVE_FILE_PATH);
            List<ServerInstance> list = serverInstanceReader.getServerInstances();
            for (ServerInstance serverInstance : list) {
                serverInstance.printOut();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

