/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.form.valid;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import org.netbeans.modules.soa.ui.form.CommonUiBundle;
import org.netbeans.modules.soa.ui.form.FormLifeCycle;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public abstract class AbstractDialogDescriptor
extends DialogDescriptor
implements ValidStateManager.ValidStateListener {
    protected JButton btnOk;
    protected JButton btnCancel;
    private ValidStateManager.Provider myVsmProvider;

    public AbstractDialogDescriptor(Object object, String string) {
        super(object, string, true, -1, null, 0, null, null);
        assert (object != null);
        assert (object instanceof Container);
        assert (object instanceof FormLifeCycle);
        this.btnOk = new JButton(NbBundle.getMessage(CommonUiBundle.class, (String)"BTN_Ok"));
        this.btnOk.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommonUiBundle.class, (String)"ACSN_BTN_Ok"));
        this.btnOk.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommonUiBundle.class, (String)"ACSD_BTN_Ok"));
        this.btnCancel = new JButton(NbBundle.getMessage(CommonUiBundle.class, (String)"BTN_Cancel"));
        this.btnCancel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommonUiBundle.class, (String)"ACSN_BTN_Cancel"));
        this.btnCancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommonUiBundle.class, (String)"ACSD_BTN_Cancel"));
        this.setOptions(new Object[]{this.btnOk, this.btnCancel});
        this.setClosingOptions(new Object[]{this.btnCancel});
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractDialogDescriptor.this.btnOk.equals(actionEvent.getSource())) {
                    AbstractDialogDescriptor.this.processOkButton();
                }
            }
        };
        this.setButtonListener(actionListener);
        ValidStateManager validStateManager = this.getValidStateManager(true);
        if (validStateManager != null) {
            validStateManager.addValidStateListener(this);
            this.updateOkButton(validStateManager);
        }
    }

    public synchronized ValidStateManager getValidStateManager(boolean bl) {
        if (this.myVsmProvider == null) {
            final Object object = this.getMessage();
            this.myVsmProvider = object instanceof ValidStateManager.Provider ? (ValidStateManager.Provider)object : (object instanceof ValidStateManager ? new ValidStateManager.Provider(){

                public ValidStateManager getValidStateManager(boolean bl) {
                    return (ValidStateManager)object;
                }
            } : new ValidStateManager.Provider.Default());
        }
        return this.myVsmProvider.getValidStateManager(bl);
    }

    public Object getDefaultValue() {
        return this.btnOk;
    }

    public boolean isOkHasPressed() {
        return this.getValue() == this.btnOk;
    }

    public abstract void processOkButton();

    public abstract void processWindowClose();

    public void setMessage(Object object) {
        assert (object != null);
        assert (object instanceof Container);
        assert (object instanceof FormLifeCycle);
        ValidStateManager validStateManager = this.getValidStateManager(true);
        if (validStateManager != null) {
            validStateManager.removeValidStateListener(this);
        }
        this.myVsmProvider = null;
        super.setMessage(object);
        validStateManager = this.getValidStateManager(true);
        if (validStateManager != null) {
            validStateManager.addValidStateListener(this);
        }
    }

    public void stateChanged(ValidStateManager validStateManager, boolean bl) {
        this.updateOkButton(validStateManager);
    }

    protected void setOptionClosable(Object object, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(this.getClosingOptions()));
        if (bl) {
            if (!arrayList.contains(object)) {
                arrayList.add(object);
            }
        } else if (arrayList.contains(object)) {
            arrayList.remove(object);
        }
        this.setClosingOptions(arrayList.toArray());
    }

    protected void updateOkButton(ValidStateManager validStateManager) {
        if (validStateManager.isValid()) {
            this.btnOk.setEnabled(true);
            this.btnOk.setToolTipText(null);
        } else {
            this.btnOk.setEnabled(false);
            Validator.Reason reason = validStateManager.getFistReason(Validator.Severity.ERROR);
            if (reason != null) {
                this.btnOk.setToolTipText(reason.getText());
            }
        }
    }
}

