/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.api.support;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.ext.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathNumericLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathVariableReference;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExpressionUpdaterVisitor
implements XPathVisitor {
    private Map<XPathExpression, XPathExpression> myMap = new IdentityHashMap<XPathExpression, XPathExpression>();
    private XPathExpression myExpression;

    ExpressionUpdaterVisitor(Map<XPathExpression, XPathExpression> map, XPathExpression xPathExpression) {
        this.myMap = map;
        this.myExpression = xPathExpression;
    }

    public void visit(LocationStep locationStep) {
        this.updateExpression((XPathExpression)locationStep);
        XPathPredicateExpression[] xPathPredicateExpressionArray = locationStep.getPredicates();
        boolean bl = false;
        if (xPathPredicateExpressionArray != null) {
            int n = 0;
            for (XPathPredicateExpression xPathPredicateExpression : xPathPredicateExpressionArray) {
                XPathExpression xPathExpression = this.myMap.remove(xPathPredicateExpression);
                if (xPathExpression != null) {
                    bl = true;
                    xPathPredicateExpressionArray[n] = (XPathPredicateExpression)xPathExpression;
                }
                ++n;
            }
        }
        if (bl) {
            locationStep.setPredicates(xPathPredicateExpressionArray);
        }
    }

    public void visit(XPathCoreFunction xPathCoreFunction) {
        this.updateExpression((XPathExpression)xPathCoreFunction);
        this.visitChildren((XPathOperationOrFuntion)xPathCoreFunction);
    }

    public void visit(XPathCoreOperation xPathCoreOperation) {
        this.updateExpression((XPathExpression)xPathCoreOperation);
        this.visitChildren((XPathOperationOrFuntion)xPathCoreOperation);
    }

    public void visit(XPathExpressionPath xPathExpressionPath) {
        this.updateExpression((XPathExpression)xPathExpressionPath);
        XPathExpression xPathExpression = xPathExpressionPath.getRootExpression();
        XPathExpression xPathExpression2 = this.myMap.remove(xPathExpression);
        if (xPathExpression2 != null) {
            xPathExpressionPath.setRootExpression(xPathExpression2);
        }
        boolean bl = false;
        LocationStep[] locationStepArray = xPathExpressionPath.getSteps();
        if (locationStepArray != null) {
            int n = 0;
            for (LocationStep locationStep : locationStepArray) {
                xPathExpression2 = this.myMap.remove(locationStep);
                if (xPathExpression2 != null) {
                    bl = true;
                    locationStepArray[n] = (LocationStep)xPathExpression2;
                }
                ++n;
            }
        }
        if (bl) {
            xPathExpressionPath.setSteps(locationStepArray);
        }
    }

    public void visit(XPathExtensionFunction xPathExtensionFunction) {
        this.updateExpression((XPathExpression)xPathExtensionFunction);
        this.visitChildren((XPathOperationOrFuntion)xPathExtensionFunction);
    }

    public void visit(XPathLocationPath xPathLocationPath) {
        this.updateExpression((XPathExpression)xPathLocationPath);
        LocationStep[] locationStepArray = xPathLocationPath.getSteps();
        boolean bl = false;
        if (locationStepArray != null) {
            int n = 0;
            for (LocationStep locationStep : locationStepArray) {
                XPathExpression xPathExpression = this.myMap.remove(locationStep);
                if (xPathExpression != null) {
                    bl = true;
                    locationStepArray[n] = (LocationStep)xPathExpression;
                }
                ++n;
            }
        }
        if (bl) {
            xPathLocationPath.setSteps(locationStepArray);
        }
    }

    public void visit(XPathStringLiteral xPathStringLiteral) {
        this.updateExpression((XPathExpression)xPathStringLiteral);
    }

    public void visit(XPathNumericLiteral xPathNumericLiteral) {
        this.updateExpression((XPathExpression)xPathNumericLiteral);
    }

    public void visit(XPathVariableReference xPathVariableReference) {
        this.updateExpression((XPathExpression)xPathVariableReference);
    }

    public void visit(XPathPredicateExpression xPathPredicateExpression) {
        this.updateExpression((XPathExpression)xPathPredicateExpression);
    }

    XPathExpression getExpression() {
        return this.myExpression;
    }

    protected void visitChildren(XPathOperationOrFuntion xPathOperationOrFuntion) {
        List list = xPathOperationOrFuntion.getChildren();
        ArrayList<XPathExpression> arrayList = null;
        boolean bl = false;
        if (list != null) {
            arrayList = new ArrayList<XPathExpression>(list.size());
            for (XPathExpression xPathExpression : list) {
                XPathExpression xPathExpression2 = this.myMap.remove(xPathExpression);
                if (xPathExpression2 != null) {
                    bl = true;
                    arrayList.add(xPathExpression2);
                    continue;
                }
                arrayList.add(xPathExpression);
            }
        }
        if (bl) {
            xPathOperationOrFuntion.clearChildren();
            for (XPathExpression xPathExpression : arrayList) {
                xPathOperationOrFuntion.addChild(xPathExpression);
            }
        }
    }

    private void updateExpression(XPathExpression xPathExpression) {
        XPathExpression xPathExpression2 = this.myMap.get(xPathExpression);
        if (xPathExpression2 != null && this.myExpression == xPathExpression) {
            this.myExpression = xPathExpression2;
        }
    }
}

